/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.http;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URIUtils {
    static final BitSet digit;
    static final BitSet alpha;
    static final BitSet reserved;
    static final BitSet mark;
    static final BitSet alphanum;
    static final BitSet unreserved;
    static final BitSet percent;
    static final BitSet hex;
    static final BitSet escaped;
    static final BitSet uric;
    static final BitSet allowed_query;

    public static String encodeQuery(String unescaped, String charset) throws Exception {
        return new String(URIUtils.encode(unescaped, allowed_query, charset));
    }

    static char[] encode(String original, BitSet allowed, String charset) throws Exception {
        byte[] octets;
        if (original == null) {
            throw new Exception("original is null");
        }
        if (allowed == null) {
            throw new Exception("null allowed characters");
        }
        try {
            octets = original.getBytes(charset);
        }
        catch (UnsupportedEncodingException error) {
            throw new Exception(error.getMessage());
        }
        StringBuffer buf = new StringBuffer(octets.length);
        for (int i = 0; i < octets.length; ++i) {
            char c = (char)octets[i];
            if (allowed.get(c)) {
                buf.append(c);
                continue;
            }
            buf.append('%');
            byte b = octets[i];
            char hexadecimal = Character.forDigit(b >> 4 & 0xF, 16);
            buf.append(Character.toUpperCase(hexadecimal));
            hexadecimal = Character.forDigit(b & 0xF, 16);
            buf.append(Character.toUpperCase(hexadecimal));
        }
        return buf.toString().toCharArray();
    }

    static {
        int i;
        digit = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            digit.set(i);
        }
        alpha = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            alpha.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            alpha.set(i);
        }
        reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        alphanum = new BitSet(256);
        alphanum.or(alpha);
        alphanum.or(digit);
        unreserved = new BitSet(256);
        unreserved.or(alphanum);
        unreserved.or(mark);
        percent = new BitSet(256);
        percent.set(37);
        hex = new BitSet(256);
        hex.or(digit);
        for (i = 97; i <= 102; ++i) {
            hex.set(i);
        }
        for (i = 65; i <= 70; ++i) {
            hex.set(i);
        }
        escaped = new BitSet(256);
        escaped.or(percent);
        escaped.or(hex);
        uric = new BitSet(256);
        uric.or(reserved);
        uric.or(unreserved);
        uric.or(escaped);
        allowed_query = new BitSet(256);
        allowed_query.or(uric);
        allowed_query.clear(37);
    }
}

