/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video;

import android.graphics.Rect;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
public class LiteCameraAreaFocusListener
implements CameraVideoCapturer.AreaFocusCallback {
    private final ReadWriteLock mNativeHandleLock = new ReentrantReadWriteLock();
    private long mNativeHandle = 0L;

    @CalledByNative
    private LiteCameraAreaFocusListener(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    public void focusArea(Rect rect) {
        this.mNativeHandleLock.readLock().lock();
        if (rect == null) {
            this.onCameraFocusChanged(this.mNativeHandle, 0, 0, 0, 0);
        } else {
            this.onCameraFocusChanged(this.mNativeHandle, rect.left, rect.top, rect.right, rect.bottom);
        }
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void exposureArea(Rect rect) {
        this.mNativeHandleLock.readLock().lock();
        if (rect == null) {
            this.onCameraExposureChanged(this.mNativeHandle, 0, 0, 0, 0);
        } else {
            this.onCameraExposureChanged(this.mNativeHandle, rect.left, rect.top, rect.right, rect.bottom);
        }
        this.mNativeHandleLock.readLock().unlock();
    }

    @CalledByNative
    private void setNativeHandle(long nativeHandle) {
        this.mNativeHandleLock.writeLock().lock();
        this.mNativeHandle = nativeHandle;
        this.mNativeHandleLock.writeLock().unlock();
    }

    private native void onCameraFocusChanged(long var1, int var3, int var4, int var5, int var6);

    private native void onCameraExposureChanged(long var1, int var3, int var4, int var5, int var6);
}

