/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video;

import com.netease.lava.webrtc.CalledByNative;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
public class LiteCameraEventListener
implements CameraVideoCapturer.CameraEventsHandler {
    private final ReadWriteLock mNativeHandleLock = new ReentrantReadWriteLock();
    private long mNativeHandle = 0L;

    @CalledByNative
    private LiteCameraEventListener() {
    }

    @Override
    public void onCameraError(String errorDescription, int deviceErrorType, boolean callback) {
        this.mNativeHandleLock.readLock().lock();
        this.onCameraError(this.mNativeHandle, errorDescription, deviceErrorType, callback);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onCameraDisconnected(boolean callback) {
        this.mNativeHandleLock.readLock().lock();
        this.onCameraDisconnected(this.mNativeHandle, callback);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onCameraFreezed(String errorDescription) {
        this.mNativeHandleLock.readLock().lock();
        this.onCameraFreezed(this.mNativeHandle, errorDescription);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onCameraOpening(String cameraName) {
        this.mNativeHandleLock.readLock().lock();
        this.onCameraOpening(this.mNativeHandle, cameraName);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onFirstFrameAvailable() {
        this.mNativeHandleLock.readLock().lock();
        this.onFirstFrameAvailable(this.mNativeHandle);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onCameraClosed() {
        this.mNativeHandleLock.readLock().lock();
        this.onCameraClosed(this.mNativeHandle);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onCameraFormatsInrequired(String deviceName, String deviceId, String formats, String selectFormat) {
        this.mNativeHandleLock.readLock().lock();
        this.onCameraFormatsInrequired(this.mNativeHandle, deviceName, deviceId, formats, selectFormat);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onCameraReOpen(int tryNum) {
        this.mNativeHandleLock.readLock().lock();
        this.onCameraReOpen(this.mNativeHandle, tryNum);
        this.mNativeHandleLock.readLock().unlock();
    }

    @CalledByNative
    private void setNativeHandle(long nativeHandle) {
        this.mNativeHandleLock.writeLock().lock();
        this.mNativeHandle = nativeHandle;
        this.mNativeHandleLock.writeLock().unlock();
    }

    private native void onCameraError(long var1, String var3, int var4, boolean var5);

    private native void onCameraDisconnected(long var1, boolean var3);

    private native void onCameraFreezed(long var1, String var3);

    private native void onCameraOpening(long var1, String var3);

    private native void onFirstFrameAvailable(long var1);

    private native void onCameraClosed(long var1);

    private native void onCameraReOpen(long var1, int var3);

    private native void onCameraFormatsInrequired(long var1, String var3, String var4, String var5, String var6);
}

