/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.GlGenericDrawer;
import com.netease.lava.webrtc.GlRectDrawer;
import com.netease.lava.webrtc.GlTextureFrameBuffer;
import com.netease.lava.webrtc.GlUtil;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.TextureBufferImpl;
import com.netease.lava.webrtc.TimestampAligner;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.VideoFrameDrawer;
import com.netease.lava.webrtc.YuvConverter;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.LooperUtils;
import com.netease.yunxin.lite.video.IVideoFrameFilter;
import com.netease.yunxin.lite.video.device.cameracapture.core.CapturerObserver;
import javax.annotation.Nullable;

public class LiteNativeCapturerObserver
implements CapturerObserver {
    private static String TAG = "LavaNativeCapturerObserver";
    private final long nativeSource;
    private boolean mIsScreenCast;
    private static volatile IVideoFrameFilter videoFrameFilter;
    private volatile boolean isReleased;
    private static boolean useAdaptThread;
    Handler adapterHandler;
    YuvConverter yuvConverter;
    private EglBase mEglBase;
    private static EglBase.Context sharedContext;
    private boolean mEglBaseCreateFailed = false;
    private int frameBufferId;
    private int dstTextureId;
    private boolean hasCallbacks = false;
    private int mWidth;
    private int mHeight;
    private static boolean useGPUBaseProcess;
    private long m_FrameIndex;
    private VideoFrame resultFrame;
    @Nullable
    private boolean[] hasPendingTexture;
    @Nullable
    private boolean[] isTextureInUse;
    @Nullable
    private GlTextureFrameBuffer[] rgbTextureFrameBuffers;
    private final GlGenericDrawer drawer = new GlRectDrawer();
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    private static boolean useCaptureObserverNewOption;

    public static void setFilter(IVideoFrameFilter frameFilter) {
        videoFrameFilter = frameFilter;
    }

    public static void setEGLBase(EglBase.Context eglBaseContext) {
        sharedContext = eglBaseContext;
        Logging.d(TAG, "setEGLBase: " + sharedContext);
    }

    @CalledByNative
    public LiteNativeCapturerObserver(long nativeSource, boolean isScreenCast) {
        this.nativeSource = nativeSource;
        this.mIsScreenCast = isScreenCast;
        this.isReleased = false;
        HandlerThread thread = new HandlerThread("AdapterThread");
        thread.start();
        this.adapterHandler = new Handler(thread.getLooper());
        this.yuvConverter = new YuvConverter();
        this.m_FrameIndex = 0L;
        Logging.d(TAG, "ctor ");
    }

    @CalledByNative
    public void releaseCapturerObserver() {
        Logging.d(TAG, "releaseCapturerObserver.");
        this.isReleased = true;
        if (this.adapterHandler != null) {
            this.adapterHandler.post(() -> {
                Logging.d(TAG, "releaseCapturerObserver in handler start");
                if (useGPUBaseProcess) {
                    this.drawer.release();
                    this.frameDrawer.release();
                    if (this.hasPendingTexture != null) {
                        this.hasPendingTexture = null;
                    }
                    if (this.isTextureInUse != null) {
                        this.isTextureInUse = null;
                    }
                    if (this.rgbTextureFrameBuffers != null) {
                        for (int i = 0; i < 3; ++i) {
                            this.rgbTextureFrameBuffers[i].release();
                        }
                        this.rgbTextureFrameBuffers = null;
                    }
                    if (useCaptureObserverNewOption) {
                        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.dstTextureId}, (int)0);
                        this.dstTextureId = 0;
                        GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.frameBufferId}, (int)0);
                        this.frameBufferId = 0;
                    }
                } else {
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{this.dstTextureId}, (int)0);
                    this.dstTextureId = 0;
                    GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.frameBufferId}, (int)0);
                    this.frameBufferId = 0;
                }
                if (this.yuvConverter != null) {
                    this.yuvConverter.release();
                    this.yuvConverter = null;
                }
                if (this.mEglBase != null) {
                    this.mEglBase.release();
                    this.mEglBase = null;
                }
                this.adapterHandler.removeCallbacksAndMessages(null);
                LooperUtils.quitSafely(this.adapterHandler);
                this.adapterHandler = null;
                Logging.d(TAG, "releaseCapturerObserver in handler end");
            });
        }
    }

    @Override
    public void onCapturerStarted(boolean success) {
        this.isReleased = false;
        LiteNativeCapturerObserver.nativeCapturerStarted(this.nativeSource, success);
    }

    @Override
    public synchronized void onCapturerStopped() {
        this.isReleased = true;
        LiteNativeCapturerObserver.nativeCapturerStopped(this.nativeSource);
    }

    @Override
    public synchronized void onFrameCaptured(VideoFrame frame) {
        if (useAdaptThread != ContextUtils.isUseAdaptThread() || useGPUBaseProcess != ContextUtils.isUseGPUBaseProcess() || useCaptureObserverNewOption != ContextUtils.isUseCaptureObserverNewOption()) {
            useAdaptThread = ContextUtils.isUseAdaptThread();
            useGPUBaseProcess = ContextUtils.isUseGPUBaseProcess();
            useCaptureObserverNewOption = ContextUtils.isUseCaptureObserverNewOption();
            Logging.d(TAG, "onFrameCaptured, useAdaptThread:" + useAdaptThread + ", useGPUBaseProcess:" + useGPUBaseProcess + ", useCaptureObserverNewOption:" + useCaptureObserverNewOption);
        }
        if (useCaptureObserverNewOption && useGPUBaseProcess) {
            this.onFrameCaptured3(frame);
        } else {
            this.onFrameCaptured1(frame);
        }
    }

    public void onFrameCaptured1(VideoFrame frame) {
        VideoFrame videoFrame;
        final long cameraCaptureTimeNs = TimestampAligner.getRtcTimeNanos();
        if (videoFrameFilter != null && !this.mIsScreenCast && (videoFrame = videoFrameFilter.onVideoFrameFilter(frame)) != null) {
            final long externalBeautyProcessTimeCost = TimestampAligner.getRtcTimeNanos() - cameraCaptureTimeNs;
            if (this.isReleased) {
                return;
            }
            if (!useAdaptThread || this.mEglBaseCreateFailed) {
                LiteNativeCapturerObserver.nativeOnFrameCaptured(this.nativeSource, videoFrame.getBuffer().getWidth(), videoFrame.getBuffer().getHeight(), videoFrame.getRotation(), cameraCaptureTimeNs, externalBeautyProcessTimeCost, 0L, videoFrame.getBuffer());
                return;
            }
            if (this.adapterHandler != null) {
                videoFrame.retain();
                boolean isPosted = this.adapterHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        long convertTimeStartNs = TimestampAligner.getRtcTimeNanos();
                        long convertTimeCostNs = 0L;
                        try {
                            if (LiteNativeCapturerObserver.this.mEglBase == null) {
                                LiteNativeCapturerObserver.this.mEglBase = EglBase.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
                                LiteNativeCapturerObserver.this.mEglBase.createDummyPbufferSurface();
                                LiteNativeCapturerObserver.this.mEglBase.makeCurrent();
                                int[] frameBuffers = new int[1];
                                GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
                                LiteNativeCapturerObserver.this.frameBufferId = frameBuffers[0];
                                LiteNativeCapturerObserver.this.dstTextureId = GlUtil.generateTexture(3553);
                                Logging.d(TAG, "onFrameCaptured, make current\uff01 Generate fbo:" + LiteNativeCapturerObserver.this.frameBufferId + " dstTextureId: " + LiteNativeCapturerObserver.this.dstTextureId);
                            }
                        }
                        catch (Exception exception) {
                            Logging.e(TAG, "onFrameCaptured, EglBase create context exception: " + exception.getMessage());
                            LiteNativeCapturerObserver.this.mEglBase = null;
                            LiteNativeCapturerObserver.this.mEglBaseCreateFailed = true;
                            videoFrame.release();
                            return;
                        }
                        VideoFrame replaceFrame = videoFrame;
                        if (videoFrame.getBuffer() instanceof TextureBufferImpl) {
                            TextureBufferImpl originBuffer = (TextureBufferImpl)videoFrame.getBuffer();
                            if (LiteNativeCapturerObserver.this.mWidth != originBuffer.getWidth() || LiteNativeCapturerObserver.this.mHeight != originBuffer.getHeight()) {
                                LiteNativeCapturerObserver.this.mWidth = originBuffer.getWidth();
                                LiteNativeCapturerObserver.this.mHeight = originBuffer.getHeight();
                                GlUtil.allocateTexture(LiteNativeCapturerObserver.this.dstTextureId, 6407, LiteNativeCapturerObserver.this.mWidth, LiteNativeCapturerObserver.this.mHeight);
                            }
                            GlUtil.copyTexture(originBuffer.getTextureId(), LiteNativeCapturerObserver.this.frameBufferId, LiteNativeCapturerObserver.this.dstTextureId, originBuffer.getWidth(), originBuffer.getHeight(), ContextUtils.isGPUCopyBlackList());
                            TextureBufferImpl buffer = new TextureBufferImpl(originBuffer.getWidth(), originBuffer.getHeight(), originBuffer.getType(), LiteNativeCapturerObserver.this.dstTextureId, originBuffer.getTransformMatrix(), LiteNativeCapturerObserver.this.adapterHandler, LiteNativeCapturerObserver.this.yuvConverter, null);
                            originBuffer.release();
                            replaceFrame = new VideoFrame(buffer.toI420(), videoFrame.getRotation(), videoFrame.getTimestampNs());
                            convertTimeCostNs = TimestampAligner.getRtcTimeNanos() - convertTimeStartNs;
                        }
                        if (!LiteNativeCapturerObserver.this.isReleased) {
                            LiteNativeCapturerObserver.nativeOnFrameCaptured(LiteNativeCapturerObserver.this.nativeSource, replaceFrame.getBuffer().getWidth(), replaceFrame.getBuffer().getHeight(), replaceFrame.getRotation(), cameraCaptureTimeNs, externalBeautyProcessTimeCost, convertTimeCostNs, replaceFrame.getBuffer());
                        }
                        replaceFrame.release();
                    }
                });
                if (isPosted && !this.hasCallbacks) {
                    this.hasCallbacks = true;
                }
                return;
            }
        }
        if (this.adapterHandler != null && this.hasCallbacks) {
            this.adapterHandler.removeCallbacksAndMessages(null);
            this.hasCallbacks = false;
        }
        VideoFrame replaceFrame = frame;
        if (!this.isReleased) {
            LiteNativeCapturerObserver.nativeOnFrameCaptured(this.nativeSource, replaceFrame.getBuffer().getWidth(), replaceFrame.getBuffer().getHeight(), replaceFrame.getRotation(), cameraCaptureTimeNs, 0L, 0L, replaceFrame.getBuffer());
        }
    }

    public void onFrameCaptured3(VideoFrame frame) {
        boolean isTextureFrame;
        VideoFrame frameAfterFilter;
        VideoFrame videoFrame = frame;
        final long cameraCaptureTimeNs = TimestampAligner.getRtcTimeNanos();
        long externalBeautyProcessTimeCost = 0L;
        boolean haveValidProcessedFrame = false;
        if (videoFrameFilter != null && !this.mIsScreenCast && (frameAfterFilter = videoFrameFilter.onVideoFrameFilter(frame)) != null) {
            externalBeautyProcessTimeCost = TimestampAligner.getRtcTimeNanos() - cameraCaptureTimeNs;
            haveValidProcessedFrame = true;
            videoFrame = frameAfterFilter;
        }
        videoFrame.setExternalBeautyProcessTimeMs(externalBeautyProcessTimeCost);
        if (this.isReleased) {
            return;
        }
        VideoFrame.Buffer.BufferType bufferType = videoFrame.getBuffer().getInternalBufferType();
        boolean bl = isTextureFrame = bufferType == VideoFrame.Buffer.BufferType.kBufferTypeTexture;
        if (this.mEglBaseCreateFailed || !isTextureFrame) {
            LiteNativeCapturerObserver.nativeOnFrameCaptured(this.nativeSource, videoFrame.getBuffer().getWidth(), videoFrame.getBuffer().getHeight(), videoFrame.getRotation(), videoFrame.getTimestampNs(), videoFrame.getExternalBeautyProcessTimeMs(), 0L, videoFrame.getBuffer());
            return;
        }
        if (this.adapterHandler != null) {
            final long finalExternalBeautyProcessTimeCost = externalBeautyProcessTimeCost;
            final boolean finalHaveValidProcessedFrame = haveValidProcessedFrame;
            final VideoFrame finalVideoFrame = videoFrame;
            finalVideoFrame.retain();
            boolean isPosted = this.adapterHandler.post(new Runnable(){

                @Override
                public void run() {
                    long convertTimeStartNs = TimestampAligner.getRtcTimeNanos();
                    long convertTimeCostNs = 0L;
                    try {
                        if (LiteNativeCapturerObserver.this.mEglBase == null) {
                            LiteNativeCapturerObserver.this.mEglBase = EglBase.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
                            LiteNativeCapturerObserver.this.mEglBase.createDummyPbufferSurface();
                            LiteNativeCapturerObserver.this.mEglBase.makeCurrent();
                            int[] frameBuffers = new int[1];
                            GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
                            LiteNativeCapturerObserver.this.frameBufferId = frameBuffers[0];
                            LiteNativeCapturerObserver.this.dstTextureId = GlUtil.generateTexture(3553);
                            Logging.d(TAG, "onFrameCaptured, make current\uff01 Generate fbo:" + LiteNativeCapturerObserver.this.frameBufferId + " dstTextureId: " + LiteNativeCapturerObserver.this.dstTextureId);
                        } else {
                            LiteNativeCapturerObserver.this.mEglBase.makeCurrent();
                        }
                    }
                    catch (Exception exception) {
                        Logging.e(TAG, "onFrameCaptured, EglBase create context exception: " + exception.getMessage());
                        LiteNativeCapturerObserver.this.mEglBase = null;
                        LiteNativeCapturerObserver.this.mEglBaseCreateFailed = true;
                        finalVideoFrame.release();
                        return;
                    }
                    VideoFrame replaceFrame = finalVideoFrame;
                    if (finalVideoFrame.getBuffer() instanceof TextureBufferImpl && finalHaveValidProcessedFrame) {
                        TextureBufferImpl originBuffer = (TextureBufferImpl)finalVideoFrame.getBuffer();
                        if (LiteNativeCapturerObserver.this.mWidth != originBuffer.getWidth() || LiteNativeCapturerObserver.this.mHeight != originBuffer.getHeight()) {
                            LiteNativeCapturerObserver.this.mWidth = originBuffer.getWidth();
                            LiteNativeCapturerObserver.this.mHeight = originBuffer.getHeight();
                            GlUtil.allocateTexture(LiteNativeCapturerObserver.this.dstTextureId, 6407, LiteNativeCapturerObserver.this.mWidth, LiteNativeCapturerObserver.this.mHeight);
                        }
                        GlUtil.copyTexture(originBuffer.getTextureId(), LiteNativeCapturerObserver.this.frameBufferId, LiteNativeCapturerObserver.this.dstTextureId, originBuffer.getWidth(), originBuffer.getHeight(), ContextUtils.isGPUCopyBlackList());
                        TextureBufferImpl buffer = new TextureBufferImpl(originBuffer.getWidth(), originBuffer.getHeight(), originBuffer.getType(), LiteNativeCapturerObserver.this.dstTextureId, originBuffer.getTransformMatrix(), LiteNativeCapturerObserver.this.adapterHandler, LiteNativeCapturerObserver.this.yuvConverter, null);
                        originBuffer.release();
                        replaceFrame = new VideoFrame(buffer, finalVideoFrame.getRotation(), finalVideoFrame.getTimestampNs());
                        convertTimeCostNs = TimestampAligner.getRtcTimeNanos() - convertTimeStartNs;
                    }
                    if (!LiteNativeCapturerObserver.this.isReleased) {
                        LiteNativeCapturerObserver.nativeOnFrameCaptured(LiteNativeCapturerObserver.this.nativeSource, replaceFrame.getBuffer().getWidth(), replaceFrame.getBuffer().getHeight(), replaceFrame.getRotation(), cameraCaptureTimeNs, finalExternalBeautyProcessTimeCost, convertTimeCostNs, replaceFrame.getBuffer());
                    }
                    replaceFrame.release();
                }
            });
            if (isPosted && !this.hasCallbacks) {
                this.hasCallbacks = true;
            }
            return;
        }
        if (this.adapterHandler != null && this.hasCallbacks) {
            this.adapterHandler.removeCallbacksAndMessages(null);
            this.hasCallbacks = false;
        }
    }

    public void onFrameCaptured2(VideoFrame frame) {
        VideoFrame videoFrame;
        VideoFrame replaceFrame = frame;
        long cameraCaptureTimeNs = TimestampAligner.getRtcTimeNanos();
        long externalBeautyProcessTimeCost = 0L;
        if (videoFrameFilter != null && !this.mIsScreenCast && (videoFrame = videoFrameFilter.onVideoFrameFilter(frame)) != null) {
            externalBeautyProcessTimeCost = TimestampAligner.getRtcTimeNanos() - cameraCaptureTimeNs;
            replaceFrame = videoFrame;
        }
        if (this.isReleased) {
            return;
        }
        replaceFrame.setExternalBeautyProcessTimeMs(externalBeautyProcessTimeCost);
        this.handlerTextureFrame(replaceFrame);
    }

    public void handlerTextureFrame(VideoFrame videoFrame) {
        if (this.adapterHandler != null) {
            videoFrame.retain();
            this.adapterHandler.post(() -> {
                boolean isTextureFrame;
                int i;
                if (this.mEglBase == null) {
                    this.mEglBase = EglBase.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
                    this.mEglBase.createDummyPbufferSurface();
                    this.mEglBase.makeCurrent();
                }
                if (this.hasPendingTexture == null) {
                    this.hasPendingTexture = new boolean[3];
                    for (i = 0; i < 3; ++i) {
                        this.hasPendingTexture[i] = false;
                    }
                }
                if (this.isTextureInUse == null) {
                    this.isTextureInUse = new boolean[3];
                    for (i = 0; i < 3; ++i) {
                        this.isTextureInUse[i] = false;
                    }
                }
                if (this.rgbTextureFrameBuffers == null) {
                    this.rgbTextureFrameBuffers = new GlTextureFrameBuffer[3];
                    this.rgbTextureFrameBuffers[0] = new GlTextureFrameBuffer(6408);
                    this.rgbTextureFrameBuffers[1] = new GlTextureFrameBuffer(6408);
                    this.rgbTextureFrameBuffers[2] = new GlTextureFrameBuffer(6408);
                }
                if (this.isReleased) {
                    return;
                }
                this.resultFrame = videoFrame;
                VideoFrame.Buffer.BufferType bufferType = videoFrame.getBuffer().getInternalBufferType();
                boolean bl = isTextureFrame = bufferType == VideoFrame.Buffer.BufferType.kBufferTypeTexture;
                if (!isTextureFrame) {
                    this.tryDeliverVideoFrame();
                    return;
                }
                int index = (int)(this.m_FrameIndex % 3L);
                this.hasPendingTexture[index] = true;
                this.tryDeliverTextureFrame(index);
            });
        }
    }

    private void tryDeliverVideoFrame() {
        this.hasPendingTexture[0] = true;
        this.tryDeliverTextureFrame(0);
    }

    private void tryDeliverTextureFrame(int index) {
        Matrix renderMatrix;
        if (this.isReleased || !this.hasPendingTexture[index] || this.isTextureInUse[index]) {
            return;
        }
        this.isTextureInUse[index] = true;
        this.hasPendingTexture[index] = false;
        ++this.m_FrameIndex;
        long convertTimeStartNs = TimestampAligner.getRtcTimeNanos();
        long convertTimeCostNs = 0L;
        long externalBeautyProcessTimeCost = this.resultFrame.getExternalBeautyProcessTimeMs();
        VideoFrame.Buffer.BufferType bufferType = this.resultFrame.getBuffer().getInternalBufferType();
        boolean isTextureFrame = bufferType == VideoFrame.Buffer.BufferType.kBufferTypeTexture;
        int frameWidth = this.resultFrame.getBuffer().getWidth();
        int frameHeight = this.resultFrame.getBuffer().getHeight();
        Matrix drawMatrix = new Matrix();
        drawMatrix.reset();
        drawMatrix.preTranslate(0.5f, 0.5f);
        if (!isTextureFrame) {
            drawMatrix.preScale(-1.0f, 1.0f);
        }
        drawMatrix.preTranslate(-0.5f, -0.5f);
        this.rgbTextureFrameBuffers[index].setSize(frameWidth, frameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.rgbTextureFrameBuffers[index].getFrameBufferId());
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        int rotation = this.resultFrame.getRotation();
        this.resultFrame.setRotation(0);
        this.frameDrawer.drawFrame(this.resultFrame, this.drawer, drawMatrix, 0, 0, frameWidth, frameHeight);
        this.resultFrame.setRotation(rotation);
        GlUtil.checkNoGLES2Error("tryDeliverTextureFrame");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        Matrix matrix = renderMatrix = isTextureFrame ? ((TextureBufferImpl)this.resultFrame.getBuffer()).getTransformMatrix() : new Matrix();
        Runnable returnTextureFrameRunnable = index == 0 ? this::returnTextureFrame0 : (index == 1 ? this::returnTextureFrame1 : this::returnTextureFrame2);
        TextureBufferImpl buffer = new TextureBufferImpl(frameWidth, frameHeight, VideoFrame.TextureBuffer.Type.RGB, this.rgbTextureFrameBuffers[index].getTextureId(), renderMatrix, this.adapterHandler, this.yuvConverter, returnTextureFrameRunnable);
        convertTimeCostNs = TimestampAligner.getRtcTimeNanos() - convertTimeStartNs;
        VideoFrame replaceFrame = new VideoFrame(buffer, this.resultFrame.getRotation(), this.resultFrame.getTimestampNs());
        this.resultFrame.release();
        LiteNativeCapturerObserver.nativeOnFrameCaptured(this.nativeSource, replaceFrame.getBuffer().getWidth(), replaceFrame.getBuffer().getHeight(), replaceFrame.getRotation(), replaceFrame.getTimestampNs(), externalBeautyProcessTimeCost, convertTimeCostNs, replaceFrame.getBuffer());
        replaceFrame.release();
    }

    private void returnTextureFrame(int index) {
        this.adapterHandler.post(() -> {
            this.isTextureInUse[index] = false;
            if (!this.isReleased) {
                this.tryDeliverTextureFrame(index);
            }
        });
    }

    private void returnTextureFrame0() {
        this.returnTextureFrame(0);
    }

    private void returnTextureFrame1() {
        this.returnTextureFrame(1);
    }

    private void returnTextureFrame2() {
        this.returnTextureFrame(2);
    }

    private static native void nativeCapturerStarted(long var0, boolean var2);

    private static native void nativeCapturerStopped(long var0);

    private static native void nativeOnFrameCaptured(long var0, int var2, int var3, int var4, long var5, long var7, long var9, VideoFrame.Buffer var11);

    static {
        useAdaptThread = false;
        useGPUBaseProcess = false;
        useCaptureObserverNewOption = false;
    }
}

