/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;

public class VideoCompatHelper {
    private static final long QUALITY_LOWEST_PIXEL = 19200L;
    private static final long QUALITY_LOW_PIXEL = 76800L;
    private static final long QUALITY_480P_PIXEL = 307200L;
    private static final long QUALITY_720P_PIXEL = 921600L;
    private static final int QUALITY_1080P_PIXEL = 2073600;
    private static final String KEY_1080P = "1080P";
    private static final String KEY_720P = "720P";
    private static final String KEY_480P = "480P";
    private static final String KEY_LOW = "LOW";
    private static final String KEY_LOWEST = "LOWEST";

    public static int findBestFpsForCapture(String fpsCompat, int width, int height) {
        int frameRate = -1;
        if (!TextUtils.isEmpty((CharSequence)fpsCompat)) {
            Map<String, String> fpsMap = VideoCompatHelper.parseString(fpsCompat);
            if (fpsMap == null) {
                return frameRate;
            }
            long pixel = (long)width * (long)height;
            if (pixel <= 19200L) {
                String fps = fpsMap.get(KEY_LOWEST);
                frameRate = Integer.parseInt(fps);
            } else if (pixel <= 76800L) {
                String fps = fpsMap.get(KEY_LOW);
                frameRate = Integer.parseInt(fps);
            } else if (pixel <= 307200L) {
                String fps = fpsMap.get(KEY_480P);
                frameRate = Integer.parseInt(fps);
            } else if (pixel <= 921600L) {
                String fps = fpsMap.get(KEY_720P);
                frameRate = Integer.parseInt(fps);
            } else if (pixel <= 2073600L) {
                String fps = fpsMap.get(KEY_1080P);
                frameRate = Integer.parseInt(fps);
            }
        }
        return frameRate;
    }

    private static Map<String, String> parseString(String policy) {
        String[] kv;
        HashMap<String, String> policyMap = new HashMap<String, String>();
        if (TextUtils.isEmpty((CharSequence)policy)) {
            return null;
        }
        for (String k : kv = policy.split(",")) {
            String[] entity;
            if (TextUtils.isEmpty((CharSequence)k) || (entity = k.split("=")).length != 2) continue;
            policyMap.put(entity[0], entity[1]);
        }
        return policyMap;
    }
}

