/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.device.AndroidDeviceInfo;
import com.netease.yunxin.lite.video.VideoHwCodecType;
import java.util.Arrays;

public class VideoHwHelper {
    private static final String TAG = "VideoHwHelper";
    private static final String[] H264_HW_ENCODE_BLACKLIST = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060", "vivo Y67A", "PAFM00", "PACM00", "PBAM00"};
    private static final String[] H264_HW_DECODE_BLACKLIST = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060", "vivo Y67A", "PAFM00", "PACM00", "COL-AL10", "OPPO R9m", "PAR-AL00", "MHA-AL00", "PBAM00", "LYA-AL00"};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.MTK.", "OMX.IMG.TOPAZ.", "OMX.hisi.", "OMX.k3.", "OMX.amlogic.", "OMX.rk.", "OMX.MS."};

    public static boolean hasH264HwEncoder() {
        if (Arrays.asList(H264_HW_ENCODE_BLACKLIST).contains(Build.MODEL)) {
            return false;
        }
        return VideoHwHelper.findCodecForType(VideoHwCodecType.H264, true);
    }

    public static boolean hasH265HwEncoder() {
        return VideoHwHelper.findCodecForType(VideoHwCodecType.H265, true);
    }

    public static boolean hasH264HwDecoder() {
        if (Arrays.asList(H264_HW_DECODE_BLACKLIST).contains(Build.MODEL)) {
            return false;
        }
        return VideoHwHelper.findCodecForType(VideoHwCodecType.H264, false);
    }

    public static boolean hasH265HwDecoder() {
        return VideoHwHelper.findCodecForType(VideoHwCodecType.H265, false);
    }

    private static boolean findCodecForType(VideoHwCodecType type, boolean encode) {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        MediaCodecInfo[] infos = VideoHwHelper.getCodecInfos();
        if (infos == null) {
            Logging.i(TAG, "Cannot retrieve codec info.");
            return false;
        }
        for (MediaCodecInfo info : infos) {
            if (info == null || encode && !VideoHwHelper.isEncoder(info) || !encode && VideoHwHelper.isEncoder(info)) continue;
            for (String mimeType : info.getSupportedTypes()) {
                if (!type.mimeType().equals(mimeType) || !VideoHwHelper.isHardwareSupported(info, type)) continue;
                String name = encode ? "encoder" : "decoder";
                Logging.i(TAG, "Found available " + name + ": " + info.getName());
                return true;
            }
        }
        return false;
    }

    private static boolean isEncoder(MediaCodecInfo info) {
        return info != null && info.isEncoder();
    }

    private static MediaCodecInfo[] getCodecInfos() {
        if (Build.VERSION.SDK_INT > 21) {
            return new MediaCodecList(0).getCodecInfos();
        }
        MediaCodecInfo[] codecInfos = new MediaCodecInfo[MediaCodecList.getCodecCount()];
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            try {
                codecInfos[i] = MediaCodecList.getCodecInfoAt((int)i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return codecInfos;
    }

    private static boolean isHardwareSupported(MediaCodecInfo info, VideoHwCodecType type) {
        String name = info.getName();
        switch (type) {
            case H264: {
                for (String hwCodecPrefix : supportedH264HwCodecPrefixes) {
                    if (!name.startsWith(hwCodecPrefix)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isSocSupportedCompat(boolean is1V1Mode, boolean encode) {
        if (!encode && is1V1Mode && !AndroidDeviceInfo.isHardWareVendorQualcomm()) {
            Logging.i(TAG, "1V1 mode only Qcom Soc support HW Decode!");
            return false;
        }
        return true;
    }
}

