/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture;

import android.hardware.Camera;
import android.os.SystemClock;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.Size;
import com.netease.yunxin.lite.video.device.cameracapture.Camera1Capturer;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraCaptureFormat;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraEnumerator;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraFrameRateRange;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class Camera1Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera1Enumerator";
    private static List<String> sCachedDeviceNamesList;
    private static AtomicBoolean needRefreshDeviceNamesList;
    private final boolean captureToTexture;
    private final boolean cameraHQ;
    private final boolean cameraFpsUp;
    private final int cameraStabilizationMode;

    public Camera1Enumerator() {
        this(true, false, true, -1);
    }

    public Camera1Enumerator(boolean captureToTexture, boolean cameraHQ, boolean cameraFpsUp, int cameraStabilizationMode) {
        this.captureToTexture = captureToTexture;
        this.cameraHQ = cameraHQ;
        this.cameraFpsUp = cameraFpsUp;
        this.cameraStabilizationMode = cameraStabilizationMode;
        sCachedDeviceNamesList = null;
    }

    @Override
    public String[] getDeviceNames() {
        if (needRefreshDeviceNamesList.getAndSet(false)) {
            sCachedDeviceNamesList = null;
        }
        if (sCachedDeviceNamesList == null) {
            sCachedDeviceNamesList = new ArrayList<String>();
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                String name = Camera1Enumerator.getDeviceName(i);
                if (name != null) {
                    sCachedDeviceNamesList.add(name);
                    Logging.i(TAG, "index: " + i + ". " + name);
                    continue;
                }
                Logging.e(TAG, "index: " + i + ". failed to query camera name.");
            }
        }
        return sCachedDeviceNamesList.toArray(new String[0]);
    }

    @Override
    public int getDeviceFacing(String deviceName) {
        int cameraIndex = Camera1Enumerator.getCameraIndex(deviceName);
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(cameraIndex);
        if (cameraInfo == null) {
            return -1;
        }
        return cameraInfo.facing == 1 ? 0 : 1;
    }

    @Override
    public List<CameraCaptureFormat> getSupportedFormats(String deviceName) {
        int cameraIndex = Camera1Enumerator.getCameraIndex(deviceName);
        if (cameraIndex < 0) {
            Logging.e(TAG, "getSupportedFormats,an invalid camera index is provided: " + cameraIndex);
            return null;
        }
        return Camera1Enumerator.enumerateFormats(cameraIndex);
    }

    @Override
    public CameraVideoCapturer createCapturer(String deviceName, CameraVideoCapturer.CameraEventsHandler eventsHandler, String orientationFixedConfig) {
        return new Camera1Capturer(deviceName, eventsHandler, this.captureToTexture, this.cameraHQ, this.cameraFpsUp, this.cameraStabilizationMode, orientationFixedConfig);
    }

    @Nullable
    private static Camera.CameraInfo getCameraInfo(int index) {
        if (index < 0) {
            Logging.e(TAG, "getCameraInfo, An invalid Camera index is provided: " + index);
            return null;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)info);
        }
        catch (Exception e) {
            Logging.e(TAG, "getCameraInfo failed on index " + index + " exception: " + e);
            return null;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CameraCaptureFormat> enumerateFormats(int cameraId) {
        Camera.Parameters parameters;
        Logging.i(TAG, "Get supported formats for camera index " + cameraId + ".");
        long startTimeMs = SystemClock.elapsedRealtime();
        Camera camera = null;
        try {
            Logging.i(TAG, "Opening camera with index " + cameraId);
            camera = Camera.open((int)cameraId);
            parameters = camera.getParameters();
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "Open camera failed on camera index " + cameraId + "Exception:" + e);
            ArrayList<CameraCaptureFormat> arrayList = new ArrayList<CameraCaptureFormat>();
            return arrayList;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        ArrayList<CameraCaptureFormat> formatList = new ArrayList<CameraCaptureFormat>();
        try {
            int minFps = 0;
            int maxFps = 0;
            List listFpsRange = parameters.getSupportedPreviewFpsRange();
            if (listFpsRange != null) {
                int[] range = (int[])listFpsRange.get(listFpsRange.size() - 1);
                minFps = range[0];
                maxFps = range[1];
            }
            for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                formatList.add(new CameraCaptureFormat(size.width, size.height, minFps, maxFps));
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index " + cameraId + " Exception: " + e);
        }
        long endTimeMs = SystemClock.elapsedRealtime();
        Logging.i(TAG, "Get supported formats for camera index " + cameraId + " done. Time spent: " + (endTimeMs - startTimeMs) + " ms.");
        return formatList;
    }

    public static List<Size> convertSizes(List<Camera.Size> cameraSizes) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        for (Camera.Size size : cameraSizes) {
            sizes.add(new Size(size.width, size.height));
        }
        return sizes;
    }

    public static List<CameraFrameRateRange> convertFramerates(List<int[]> arrayRanges) {
        ArrayList<CameraFrameRateRange> ranges = new ArrayList<CameraFrameRateRange>();
        for (int[] range : arrayRanges) {
            ranges.add(new CameraFrameRateRange(range[0], range[1]));
        }
        return ranges;
    }

    public static int getCameraIndex(String deviceName) {
        int index;
        Logging.i(TAG, "getCameraIndex: " + deviceName);
        if (sCachedDeviceNamesList != null && (index = sCachedDeviceNamesList.indexOf(deviceName)) >= 0) {
            return index;
        }
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            if (!deviceName.equals(Camera1Enumerator.getDeviceName(i))) continue;
            return i;
        }
        Logging.e(TAG, "No such camera: " + deviceName);
        return -1;
    }

    public static void requiresCameraCacheRefresh() {
        Logging.i(TAG, "Camera cache needs to be refreshed");
        needRefreshDeviceNamesList.set(true);
    }

    @Nullable
    private static String getDeviceName(int index) {
        Camera.CameraInfo info = Camera1Enumerator.getCameraInfo(index);
        if (info == null) {
            return null;
        }
        String facing = info.facing == 1 ? "front" : "back";
        return "Camera " + index + ", Facing " + facing + ", Orientation " + info.orientation;
    }

    static {
        needRefreshDeviceNamesList = new AtomicBoolean(false);
    }
}

