/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.os.SystemClock;
import android.util.AndroidException;
import android.util.Range;
import android.util.Size;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.video.device.cameracapture.Camera2Capturer;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraCaptureFormat;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraEnumerator;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraFrameRateRange;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@TargetApi(value=21)
public class Camera2Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera2Enumerator";
    private static final double NANO_SECONDS_PER_SECOND = 1.0E9;
    private static volatile boolean usbCameraDeviceDetached = false;
    final Context context;
    @Nullable
    final CameraManager cameraManager;

    public Camera2Enumerator(Context context) {
        this.context = context;
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    @Override
    public String[] getDeviceNames() {
        try {
            return this.cameraManager.getCameraIdList();
        }
        catch (AndroidException e) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)e));
            return new String[0];
        }
    }

    @Override
    public int getDeviceFacing(String deviceName) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(deviceName);
        return characteristics != null ? (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) : -1;
    }

    @Override
    public List<CameraCaptureFormat> getSupportedFormats(String deviceName) {
        CameraCharacteristics cameraCharacteristics;
        long startTimeMs = SystemClock.elapsedRealtime();
        try {
            cameraCharacteristics = this.cameraManager.getCameraCharacteristics(deviceName);
        }
        catch (Exception ex) {
            Logging.e(TAG, "getCameraCharacteristics(): " + ex);
            return new ArrayList<CameraCaptureFormat>();
        }
        StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Range[] fpsRanges = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        List<CameraFrameRateRange> framerateRanges = Camera2Enumerator.convertFramerates(fpsRanges, Camera2Enumerator.getFpsUnitFactor(fpsRanges));
        List<com.netease.lava.webrtc.Size> sizes = Camera2Enumerator.getSupportedSizes(cameraCharacteristics);
        int defaultMaxFps = 0;
        for (CameraFrameRateRange cameraFrameRateRange : framerateRanges) {
            defaultMaxFps = Math.max(defaultMaxFps, cameraFrameRateRange.max);
        }
        ArrayList<CameraCaptureFormat> formatList = new ArrayList<CameraCaptureFormat>();
        for (com.netease.lava.webrtc.Size size : sizes) {
            long minFrameDurationNs = 0L;
            try {
                minFrameDurationNs = streamMap.getOutputMinFrameDuration(SurfaceTexture.class, new Size(size.width, size.height));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int maxFps = minFrameDurationNs == 0L ? defaultMaxFps : (int)Math.round(1.0E9 / (double)minFrameDurationNs) * 1000;
            formatList.add(new CameraCaptureFormat(size.width, size.height, 0, maxFps));
            Logging.i(TAG, "Format: " + size.width + "x" + size.height + "@" + maxFps);
        }
        long l = SystemClock.elapsedRealtime();
        Logging.i(TAG, "Get supported formats for camera index " + deviceName + " done. Time spent: " + (l - startTimeMs) + " ms.");
        return formatList;
    }

    @Override
    public CameraVideoCapturer createCapturer(String deviceName, CameraVideoCapturer.CameraEventsHandler eventsHandler, String orientationFixedConfig) {
        return new Camera2Capturer(this.context, deviceName, eventsHandler, true, false, true, -1, orientationFixedConfig);
    }

    @Nullable
    private CameraCharacteristics getCameraCharacteristics(String deviceName) {
        try {
            return this.cameraManager.getCameraCharacteristics(deviceName);
        }
        catch (CameraAccessException | RuntimeException e) {
            Logging.e(TAG, "Camera access exception: " + e);
            return null;
        }
    }

    public static boolean isCamera2BlackList() {
        boolean isCamera2Black = false;
        if (Build.DEVICE.equalsIgnoreCase("ocean") && Build.MODEL.equalsIgnoreCase("oe106")) {
            isCamera2Black = true;
        }
        if (Build.DEVICE.equalsIgnoreCase("trident") && Build.MODEL.equalsIgnoreCase("de106")) {
            isCamera2Black = true;
        }
        if (Build.DEVICE.equalsIgnoreCase("shark") && Build.MODEL.equalsIgnoreCase("skr-a0")) {
            isCamera2Black = true;
        }
        if (Build.DEVICE.equalsIgnoreCase("on7xelte") && Build.MODEL.equalsIgnoreCase("SM-G610F")) {
            isCamera2Black = true;
        }
        if (Build.DEVICE.equalsIgnoreCase("m2c") && Build.MODEL.equalsIgnoreCase("M578CA")) {
            isCamera2Black = true;
        }
        if (Build.DEVICE.equalsIgnoreCase("hnnem-h")) {
            isCamera2Black = true;
        }
        if (Build.MANUFACTURER.equalsIgnoreCase("oneplus")) {
            isCamera2Black = true;
        }
        if (Build.MANUFACTURER.equalsIgnoreCase("samsung") && Build.MODEL != null && (Build.MODEL.contains("SM-G930") || Build.MODEL.contains("SM-G935") || Build.MODEL.contains("SM-G950") || Build.MODEL.contains("SM-G955") || Build.MODEL.equals("SM-G892A") || Build.MODEL.equals("SM-G892U") || Build.MODEL.equals("SC-02H") || Build.MODEL.equals("SC-02J") || Build.MODEL.equals("SC-03J") || Build.MODEL.equals("SCV33") || Build.MODEL.equals("SCV35") || Build.MODEL.equals("SCV36"))) {
            isCamera2Black = true;
        }
        return isCamera2Black;
    }

    public static boolean isSupported(Context context, @Nullable String deviceName) {
        if (Build.VERSION.SDK_INT < 21) {
            Logging.w(TAG, "Camera2 not support, android-sdk version: " + Build.VERSION.SDK_INT);
            return false;
        }
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            if (usbCameraDeviceDetached && deviceName != null) {
                CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(deviceName);
                int hwLevel = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (hwLevel == 2) {
                    Camera2Enumerator.printHWSupportLevel(deviceName, hwLevel);
                    return false;
                }
            } else {
                String[] cameraIds;
                for (String id : cameraIds = cameraManager.getCameraIdList()) {
                    CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(id);
                    int hwLevel = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                    if (hwLevel != 2) continue;
                    Camera2Enumerator.printHWSupportLevel(id, hwLevel);
                    return false;
                }
            }
        }
        catch (CameraAccessException | RuntimeException e) {
            Logging.e(TAG, "Camera access exception: " + e);
            return false;
        }
        return true;
    }

    private static void printHWSupportLevel(String index, int hwLevel) {
        String supportLevel;
        switch (hwLevel) {
            case 2: {
                supportLevel = "LEGACY:device has very limited capabilities";
                break;
            }
            case 0: {
                supportLevel = "LIMITED:device represents the baseline feature set";
                break;
            }
            case 1: {
                supportLevel = "FULL:device is capable of supporting advanced imaging applications.";
                break;
            }
            case 3: {
                supportLevel = "LEVEL_3:device is capable of YUV reprocessing and RAW data capture,in addition to FULL-Level";
                break;
            }
            case 4: {
                supportLevel = "EXTERNAL:device identical to a LIMITED level device,which is backed by an external camera";
                break;
            }
            default: {
                supportLevel = "Unknown";
            }
        }
        Logging.i(TAG, "CameraID: " + index + ", Camera2 support level:" + supportLevel);
    }

    public static int getFpsUnitFactor(Range<Integer>[] fpsRanges) {
        if (fpsRanges.length == 0) {
            return 1000;
        }
        return (Integer)fpsRanges[0].getUpper() < 1000 ? 1000 : 1;
    }

    public static List<com.netease.lava.webrtc.Size> getSupportedSizes(CameraCharacteristics cameraCharacteristics) {
        StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        int supportLevel = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        Size[] nativeSizes = streamMap.getOutputSizes(SurfaceTexture.class);
        List<com.netease.lava.webrtc.Size> sizes = Camera2Enumerator.convertSizes(nativeSizes);
        if (Build.VERSION.SDK_INT < 22 && supportLevel == 2) {
            Rect activeArraySize = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            ArrayList<com.netease.lava.webrtc.Size> filteredSizes = new ArrayList<com.netease.lava.webrtc.Size>();
            for (com.netease.lava.webrtc.Size size : sizes) {
                if (activeArraySize.width() * size.height != activeArraySize.height() * size.width) continue;
                filteredSizes.add(size);
            }
            return filteredSizes;
        }
        return sizes;
    }

    private static List<com.netease.lava.webrtc.Size> convertSizes(Size[] cameraSizes) {
        ArrayList<com.netease.lava.webrtc.Size> sizes = new ArrayList<com.netease.lava.webrtc.Size>();
        for (Size size : cameraSizes) {
            sizes.add(new com.netease.lava.webrtc.Size(size.getWidth(), size.getHeight()));
        }
        return sizes;
    }

    public static List<CameraFrameRateRange> convertFramerates(Range<Integer>[] arrayRanges, int unitFactor) {
        ArrayList<CameraFrameRateRange> ranges = new ArrayList<CameraFrameRateRange>();
        for (Range<Integer> range : arrayRanges) {
            ranges.add(new CameraFrameRateRange((Integer)range.getLower() * unitFactor, (Integer)range.getUpper() * unitFactor));
        }
        return ranges;
    }

    public static int getDeviceIndexByName(CameraManager cameraManager, String deviceName) {
        String[] deviceNames;
        if (cameraManager == null) {
            Logging.e(TAG, "CameraManager is null.");
            return -1;
        }
        try {
            deviceNames = cameraManager.getCameraIdList();
            if (deviceNames == null) {
                Logging.e(TAG, "Get Camera ID list is null.");
                return -1;
            }
        }
        catch (AndroidException e) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)e));
            return -1;
        }
        for (int i = 0; i < deviceNames.length; ++i) {
            if (!deviceName.equals(deviceNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static void onUsbCameraDeviceDetached() {
        usbCameraDeviceDetached = true;
    }
}

