/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture;

import android.content.Context;
import android.media.MediaRecorder;
import android.os.Build;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.SurfaceTextureHelper;
import com.netease.lava.webrtc.device.HardwareLevel;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.video.device.cameracapture.Camera1Capturer;
import com.netease.yunxin.lite.video.device.cameracapture.Camera2Capturer;
import com.netease.yunxin.lite.video.device.cameracapture.Camera2Enumerator;
import com.netease.yunxin.lite.video.device.cameracapture.CameraEnumeratorWrapper;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraCapturer;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import com.netease.yunxin.lite.video.device.cameracapture.core.CapturerObserver;
import javax.annotation.Nullable;

public class CameraCapturerWrapper
implements CameraVideoCapturer {
    private static final String TAG = "CameraCapturerWrapper";
    private CameraCapturer cameraCapturer;

    @Keep
    @CalledByNative
    public CameraCapturerWrapper(Context context, int cameraType, boolean captureToTexture, boolean cameraHQ, boolean cameraFpsUp, int cameraStabilizationMode, String cameraName, @Nullable CameraVideoCapturer.CameraEventsHandler eventsHandler, String rotationCompatConfig) {
        int camType = 0;
        Logging.i(TAG, "CameraCapturerWrapper::cameraType:" + cameraType + ", captureToTexture:" + captureToTexture + ", cameraHQ:" + cameraHQ + ", cameraFpsUp:" + cameraFpsUp + ", cameraStabilizationMode:" + cameraStabilizationMode + ", cameraName:" + cameraName + ", rotationCompat:" + rotationCompatConfig);
        if (Camera2Enumerator.isCamera2BlackList() || HardwareLevel.level() < 2 || Build.VERSION.SDK_INT <= 22) {
            Logging.w(TAG, "Device in Camera2 BlackList OR build version too low, use Camera1!");
            camType = 1;
        } else {
            camType = cameraType;
        }
        if (CameraEnumeratorWrapper.isCamera2FallbackHappened) {
            Logging.w(TAG, "Camera2 Fallback Happened, use Camera1!");
            camType = 1;
        }
        try {
            this.cameraCapturer = camType == 2 && Camera2Enumerator.isSupported(context, cameraName) ? new Camera2Capturer(context, cameraName, eventsHandler, captureToTexture, cameraHQ, cameraFpsUp, cameraStabilizationMode, rotationCompatConfig) : new Camera1Capturer(cameraName, eventsHandler, captureToTexture, cameraHQ, cameraFpsUp, cameraStabilizationMode, rotationCompatConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.e(TAG, "CameraCapturerWrapper create failed! " + e.getMessage());
        }
    }

    @Override
    @Keep
    @CalledByNative
    public void initialize(@Nullable SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.initialize(surfaceTextureHelper, applicationContext, capturerObserver);
        }
    }

    @Override
    @Keep
    @CalledByNative
    public void startCapture(int width, int height, int framerate) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.startCapture(width, height, framerate);
        } else {
            Logging.e(TAG, "startCapture failed! cameraCapturer is null");
        }
    }

    @Override
    @Keep
    @CalledByNative
    public void stopCapture() {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.stopCapture();
        }
    }

    @Override
    @Keep
    @CalledByNative
    public void changeCaptureFormat(int width, int height, int framerate) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.changeCaptureFormat(width, height, framerate);
        }
    }

    @Override
    @Keep
    @CalledByNative
    public void dispose() {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.dispose();
        }
    }

    @Override
    @CalledByNative
    public boolean isScreencast() {
        if (this.cameraCapturer != null) {
            return this.cameraCapturer.isScreencast();
        }
        return false;
    }

    @Override
    @CalledByNative
    public void setZoom(int zoomValue) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.setZoom(zoomValue);
        }
    }

    @Override
    @CalledByNative
    public int getCurrentZoom() {
        if (this.cameraCapturer != null) {
            return this.cameraCapturer.getCurrentZoom();
        }
        return -1;
    }

    @Override
    @CalledByNative
    public int getMaxZoom() {
        if (this.cameraCapturer != null) {
            return this.cameraCapturer.getMaxZoom();
        }
        return -1;
    }

    @Override
    @CalledByNative
    public int setFlash(boolean flash) {
        if (this.cameraCapturer != null) {
            return this.cameraCapturer.setFlash(flash);
        }
        return -1;
    }

    @Override
    @CalledByNative
    public void setMeteringAreas(float x, float y) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.setMeteringAreas(x, y);
        }
    }

    @Override
    @CalledByNative
    public void setFocusAreas(float x, float y) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.setFocusAreas(x, y);
        }
    }

    @CalledByNative
    public void printStackTrace() {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.printStackTrace();
        }
    }

    @Override
    public boolean isCameraZoomSupported() {
        if (this.cameraCapturer != null) {
            return this.cameraCapturer.isCameraZoomSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraTorchSupported() {
        if (this.cameraCapturer != null) {
            return this.cameraCapturer.isCameraTorchSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        if (this.cameraCapturer != null) {
            return this.cameraCapturer.isCameraExposurePositionSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraFocusSupported() {
        if (this.cameraCapturer != null) {
            return this.cameraCapturer.isCameraFocusSupported();
        }
        return false;
    }

    @Override
    public void setFocusAndMeteringCallback(CameraVideoCapturer.AreaFocusCallback callback) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.setFocusAndMeteringCallback(callback);
        }
    }

    @Override
    public void addMediaRecorderToCamera(MediaRecorder mediaRecorder, CameraVideoCapturer.MediaRecorderHandler resultHandler) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.addMediaRecorderToCamera(mediaRecorder, resultHandler);
        }
    }

    @Override
    public void removeMediaRecorderFromCamera(CameraVideoCapturer.MediaRecorderHandler resultHandler) {
        if (this.cameraCapturer != null) {
            this.cameraCapturer.removeMediaRecorderFromCamera(resultHandler);
        }
    }
}

