/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.os.Build;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.device.HardwareLevel;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.CommonUtils;
import com.netease.yunxin.lite.video.device.cameracapture.Camera1Enumerator;
import com.netease.yunxin.lite.video.device.cameracapture.Camera2Enumerator;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraCaptureFormat;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraEnumerator;
import java.util.List;

public class CameraEnumeratorWrapper {
    private static final String TAG = "CameraEnumeratorWrapper";
    private CameraEnumerator cameraEnumerator;
    private volatile int nativeCameraType = 0;
    public static volatile boolean isCamera2FallbackHappened = false;
    private volatile int camType = 0;
    private Context context;
    private BroadcastReceiver usbChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
            if (usbDevice == null) {
                return;
            }
            String action = intent.getAction();
            boolean isVideoDevice = false;
            int interfaceCount = usbDevice.getInterfaceCount();
            for (int i = 0; i < interfaceCount; ++i) {
                if (usbDevice.getInterface(i).getInterfaceClass() != 14) continue;
                isVideoDevice = true;
                break;
            }
            if (!isVideoDevice) {
                return;
            }
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                Camera2Enumerator.onUsbCameraDeviceDetached();
            }
            Logging.i(CameraEnumeratorWrapper.TAG, "usbDeviceChange: " + action + " usbDevice: " + usbDevice.getDeviceName() + "nativeCameraType: " + CameraEnumeratorWrapper.this.nativeCameraType);
            Camera1Enumerator.requiresCameraCacheRefresh();
            CameraEnumeratorWrapper.usbDeviceChange("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action), CameraEnumeratorWrapper.this.nativeCameraType);
        }
    };

    @Keep
    @CalledByNative
    public CameraEnumeratorWrapper(Context context, int cameraType) {
        this.context = context.getApplicationContext();
        this.nativeCameraType = cameraType;
        if (Camera2Enumerator.isCamera2BlackList() || HardwareLevel.level() < 2 || Build.VERSION.SDK_INT <= 22) {
            Logging.w(TAG, "device in Camera2 BlackList or build version too low, use Camera1!");
            this.camType = 1;
        } else {
            this.camType = cameraType;
        }
        if (isCamera2FallbackHappened) {
            Logging.w(TAG, "Camera2 Fallback Happened, use Camera1!");
            this.camType = 1;
        }
        switch (this.camType) {
            case 2: {
                if (Camera2Enumerator.isSupported(context, null)) {
                    this.cameraEnumerator = new Camera2Enumerator(context);
                    break;
                }
                this.cameraEnumerator = new Camera1Enumerator();
                break;
            }
            default: {
                this.cameraEnumerator = new Camera1Enumerator();
            }
        }
        if (this.nativeCameraType == 2 && this.cameraEnumerator instanceof Camera1Enumerator) {
            isCamera2FallbackHappened = true;
        }
        this.enableListenerDeviceChange(true);
    }

    private void enableListenerDeviceChange(boolean enable) {
        if (this.context == null) {
            return;
        }
        Logging.i(TAG, "enableListenerDeviceChange , enable: " + enable);
        if (!enable) {
            this.context.unregisterReceiver(this.usbChangeReceiver);
            return;
        }
        IntentFilter intent = new IntentFilter();
        intent.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intent.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        CommonUtils.safeRegisterReceiver(this.context, this.usbChangeReceiver, intent);
    }

    @Keep
    @CalledByNative
    public String[] getDeviceNames() {
        if (this.cameraEnumerator != null) {
            return this.cameraEnumerator.getDeviceNames();
        }
        return null;
    }

    @Keep
    @CalledByNative
    public int getDeviceFacing(String deviceName) {
        if (this.cameraEnumerator != null) {
            return this.cameraEnumerator.getDeviceFacing(deviceName);
        }
        return -1;
    }

    @Keep
    @CalledByNative
    public List<CameraCaptureFormat> getSupportedFormats(String deviceName) {
        if (this.cameraEnumerator != null) {
            return this.cameraEnumerator.getSupportedFormats(deviceName);
        }
        return null;
    }

    @Keep
    @CalledByNative
    public void release() {
        this.enableListenerDeviceChange(false);
    }

    @Keep
    public static native void usbDeviceChange(boolean var0, int var1);
}

