/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraCharacteristics;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.util.VideoUtils;

public class CoordinateTransformer {
    private Matrix mPreviewToCameraTransform;
    private RectF mSensorRectF;
    private Rect mPreviewRect;
    private static final String TAG = "CoordinateTransformer";
    private int mAreaSize = 200;

    @TargetApi(value=21)
    public CoordinateTransformer(CameraCharacteristics characteristics, Context context) {
        Integer face;
        if (context == null) {
            Logging.e(TAG, "context is null");
            return;
        }
        this.mPreviewRect = VideoUtils.getDisplaySize(context);
        RectF mPreviewRectF = this.rectToRectF(this.mPreviewRect);
        if (this.hasZeroArea(mPreviewRectF)) {
            Logging.e(TAG, "previewRect is null");
        }
        boolean mirrorX = (face = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING)) != null && face == 0;
        Integer sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        int rotation = sensorOrientation == null ? 90 : sensorOrientation;
        Rect rect = (Rect)characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        this.mSensorRectF = new RectF(rect);
        this.mPreviewToCameraTransform = this.previewToCameraTransform(mirrorX, rotation, mPreviewRectF);
    }

    public Rect toCameraSpace(RectF source) {
        RectF result = new RectF();
        this.mPreviewToCameraTransform.mapRect(result, source);
        return this.toIntRect(result);
    }

    public float clamp(float x, float min, float max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public RectF getAreaRect(float x, float y) {
        float left = this.clamp(x - (float)(this.mAreaSize / 2), this.mPreviewRect.left, this.mPreviewRect.right - this.mAreaSize / 2);
        float top = this.clamp(y - (float)(this.mAreaSize / 2), this.mPreviewRect.top, this.mPreviewRect.bottom - this.mAreaSize / 2);
        float right = this.clamp(x + (float)(this.mAreaSize / 2), this.mPreviewRect.left, this.mPreviewRect.right);
        float bottom = this.clamp(y + (float)(this.mAreaSize / 2), this.mPreviewRect.top, this.mPreviewRect.bottom);
        RectF areaRectF = new RectF(left, top, right, bottom);
        return areaRectF;
    }

    public void setAreaSize(int areaSize) {
        this.mAreaSize = areaSize;
    }

    public Rect toIntRect(RectF rectF) {
        Rect rect = new Rect();
        rect.left = Math.round(rectF.left);
        rect.top = Math.round(rectF.top);
        rect.right = Math.round(rectF.right);
        rect.bottom = Math.round(rectF.bottom);
        return rect;
    }

    private Matrix previewToCameraTransform(boolean mirrorX, int sensorOrientation, RectF previewRect) {
        Matrix transform = new Matrix();
        transform.setScale(mirrorX ? -1.0f : 1.0f, 1.0f);
        transform.postRotate((float)(-sensorOrientation));
        transform.mapRect(previewRect);
        Matrix fill = new Matrix();
        boolean bRet = fill.setRectToRect(previewRect, this.mSensorRectF, Matrix.ScaleToFit.FILL);
        if (!bRet) {
            Logging.e(TAG, "setRectToRect failed");
        }
        transform.setConcat(fill, transform);
        return transform;
    }

    private boolean hasZeroArea(RectF rect) {
        return rect.width() == 0.0f || rect.height() == 0.0f;
    }

    private RectF rectToRectF(Rect rect) {
        return new RectF(rect);
    }
}

