/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture.core;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.view.WindowManager;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AreaFocus {
    private String TAG = "AreaFocus";
    @Nullable
    private Camera mCamera;
    @Nullable
    private Context mContext;
    @Nullable
    private Camera.AutoFocusCallback mAutoFocusCallback;
    private Rect mCurrentRect;
    @Nullable
    private CameraVideoCapturer.AreaFocusCallback mCallback;
    private boolean mIsFocus = true;
    private boolean mSetParam = true;

    AreaFocus(Context context) {
        this.mContext = context;
        this.mAutoFocusCallback = new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                success = success && AreaFocus.this.mSetParam;
                Logging.i(AreaFocus.this.TAG, "Camera AreaFocus success:" + success + " Rect: " + AreaFocus.this.mCurrentRect);
                if (AreaFocus.this.mCallback != null) {
                    if (AreaFocus.this.mIsFocus) {
                        AreaFocus.this.mCallback.focusArea(success ? AreaFocus.this.mCurrentRect : null);
                    } else {
                        AreaFocus.this.mCallback.exposureArea(success ? AreaFocus.this.mCurrentRect : null);
                    }
                }
                try {
                    camera.cancelAutoFocus();
                    camera.autoFocus(null);
                    Camera.Parameters parameters = camera.getParameters();
                    List focusModes = parameters.getSupportedFocusModes();
                    if (focusModes != null && focusModes.contains("continuous-video")) {
                        parameters.setFocusMode("continuous-video");
                        Logging.i(AreaFocus.this.TAG, "set focus mode continuous-video");
                    }
                    AreaFocus.this.mCamera.setParameters(parameters);
                }
                catch (Exception e) {
                    Logging.e(AreaFocus.this.TAG, "Camera AreaFocus reset FOCUS_MODE_CONTINUOUS_VIDEO failed:" + e.getMessage());
                }
            }
        };
    }

    void setCamera(Camera camera) {
        this.mCamera = camera;
    }

    void setFocusCallback(CameraVideoCapturer.AreaFocusCallback callback) {
        this.mCallback = callback;
    }

    void destory() {
        this.mContext = null;
        this.mCamera = null;
        this.mAutoFocusCallback = null;
        this.mCallback = null;
    }

    void focusArea(float x, float y, int size, boolean onlyMetering) {
        if (this.mCamera == null || this.mAutoFocusCallback == null) {
            return;
        }
        try {
            Rect meteringRect = this.calculateTapArea(x, y, 1.5f, size);
            Camera.Parameters parameters = this.mCamera.getParameters();
            this.mCamera.cancelAutoFocus();
            Rect focusRect = this.calculateTapArea(x, y, 1.0f, size);
            parameters.setFocusMode("macro");
            if (parameters.getMaxNumFocusAreas() > 0) {
                ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
                focusAreas.add(new Camera.Area(focusRect, 800));
                parameters.setFocusAreas(focusAreas);
            }
            if (parameters.getMaxNumMeteringAreas() > 0 && onlyMetering) {
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(meteringRect, 800));
                parameters.setMeteringAreas(meteringAreas);
            }
            try {
                this.mSetParam = true;
                this.mIsFocus = !onlyMetering;
                this.mCamera.setParameters(parameters);
            }
            catch (Exception e) {
                this.mSetParam = false;
                Logging.e(this.TAG, "focusArea failed: " + e.getMessage());
            }
            this.mCamera.autoFocus(this.mAutoFocusCallback);
        }
        catch (Exception e) {
            Logging.w(this.TAG, "Camera AreaFocus failed:" + e.getMessage());
        }
    }

    private int getRotation() {
        if (this.mContext == null) {
            return 0;
        }
        return ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
    }

    @Nullable
    private Rect calculateTapArea(float x, float y, float coefficient, int focusAreaSize) {
        if (this.mContext == null) {
            return null;
        }
        int areaSize = Float.valueOf((float)focusAreaSize * coefficient).intValue();
        int centerY = 0;
        int centerX = 0;
        int rotation = this.getRotation();
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        int screenW = wm.getDefaultDisplay().getWidth();
        int screenH = wm.getDefaultDisplay().getHeight();
        this.mCurrentRect = new Rect(Math.round(x - (float)(focusAreaSize / 2)), Math.round(y - (float)(focusAreaSize / 2)), Math.round(x + (float)(focusAreaSize / 2)), Math.round(y + (float)(focusAreaSize / 2)));
        switch (rotation) {
            case 0: 
            case 2: {
                centerY = (int)(x / (float)screenW * 2000.0f - 1000.0f);
                centerX = (int)(y / (float)screenH * 2000.0f - 1000.0f);
                break;
            }
            case 1: {
                centerY = (int)(-x / (float)screenW * 2000.0f + 1000.0f);
                centerX = (int)(-y / (float)screenH * 2000.0f + 1000.0f);
                break;
            }
            case 3: {
                centerY = (int)(-x / (float)screenW * 2000.0f + 1000.0f);
                centerX = (int)(y / (float)screenH * 2000.0f - 1000.0f);
                break;
            }
        }
        int left = this.clamp(centerX - areaSize / 2, -1000, 1000);
        int top = this.clamp(centerY - areaSize / 2, -1000, 1000);
        float right = left + areaSize;
        if (right > 1000.0f) {
            right = 1000.0f;
        } else if (right < -1000.0f) {
            right = -1000.0f;
        }
        float bottom = top + areaSize;
        if (bottom > 1000.0f) {
            bottom = 1000.0f;
        } else if (bottom < -1000.0f) {
            bottom = -1000.0f;
        }
        RectF rectF = new RectF((float)left, (float)top, right, bottom);
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }
}

