/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture.core;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.NV21Buffer;
import com.netease.lava.webrtc.Size;
import com.netease.lava.webrtc.SurfaceTextureHelper;
import com.netease.lava.webrtc.TextureBufferImpl;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.video.device.cameracapture.Camera1Enumerator;
import com.netease.yunxin.lite.video.device.cameracapture.core.AreaFocus;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraCaptureFormat;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraEnumerationUtil;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraFrameRateRange;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraSession;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class Camera1Session
implements CameraSession {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static boolean mCameraHQ = false;
    private static boolean mCameraFpsUp = false;
    private static int mCameraStabilizaionMode = -1;
    private static int mRequestFPS;
    private static final int FOCUS_AREA_SIZE = 200;
    private static final int METERING_AREA_SIZE = 200;
    private static final int FPS_UNIT_FACTOR = 1000;
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Camera camera;
    private final Camera.CameraInfo info;
    private final CameraCaptureFormat captureFormat;
    private final long constructionTimeNs;
    private SessionState state;
    private boolean firstFrameReported;
    private int mZoomValue;
    private int mMaxZoomValue;
    private boolean mFlashModeTorchSupported;
    private boolean mZoomModeSupported;
    private boolean mFocusModeSupported;
    private boolean mExposureModeSupported;
    private boolean mFDModeSupported;
    private boolean isBackCamera;
    private int extraOrientation;
    @Nullable
    private AreaFocus mAreaFocus;
    @Nullable
    private CameraVideoCapturer.AreaFocusCallback mFocusCallback;
    private CameraSession.OrientationCompatConfig orientationCompatConfig;
    private int frameOrientation = -1;

    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, int width, int height, int framerate, boolean cameraHQ, boolean cameraFpsUp, int cameraStabilizationMode, String rotationCompatConfig) {
        CameraCaptureFormat captureFormat;
        Camera camera;
        long constructionTimeNs = System.nanoTime();
        Logging.i(TAG, "Open camera " + cameraId + ", captureToTexture:" + captureToTexture + ", cameraHQ: " + cameraHQ + ", cameraFpsUp:" + cameraFpsUp + ", cameraStabilizationMode: " + cameraStabilizationMode);
        events.onCameraOpening();
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (RuntimeException e) {
            callback.onFailure(CameraSession.FailureType.ERROR, CameraSession.getExceptionDescription(e), CameraSession.DeviceErrorType.CAMERA1_INIT_ERROR);
            return;
        }
        if (camera == null) {
            callback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + cameraId, CameraSession.DeviceErrorType.CAMERA1_NULL_ERROR);
            return;
        }
        try {
            camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException | RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, CameraSession.getExceptionDescription(e), CameraSession.DeviceErrorType.CAMERA1_SURFACE_ERROR);
            return;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        mCameraHQ = cameraHQ;
        mCameraFpsUp = cameraFpsUp;
        mCameraStabilizaionMode = cameraStabilizationMode;
        mRequestFPS = framerate;
        try {
            Camera.Parameters parameters = camera.getParameters();
            captureFormat = Camera1Session.findClosestCaptureFormat(parameters, width, height, framerate);
            Size pictureSize = Camera1Session.findClosestPictureSize(parameters, width, height);
            Camera1Session.updateCameraParameters(camera, parameters, captureFormat, pictureSize, captureToTexture);
            Camera1Session.reportCameraFormats(cameraId, parameters, events);
        }
        catch (RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, CameraSession.getExceptionDescription(e), CameraSession.DeviceErrorType.CAMERA1_UPDATE_PARAM_ERROR);
            return;
        }
        if (!captureToTexture) {
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                camera.addCallbackBuffer(buffer.array());
            }
        }
        try {
            camera.setDisplayOrientation(0);
        }
        catch (RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, CameraSession.getExceptionDescription(e), CameraSession.DeviceErrorType.CAMERA1_SET_DISPLAY_ORIENTATION_ERROR);
            return;
        }
        callback.onDone(new Camera1Session(events, captureToTexture, applicationContext, surfaceTextureHelper, cameraId, camera, info, captureFormat, constructionTimeNs, rotationCompatConfig));
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraCaptureFormat captureFormat, Size pictureSize, boolean captureToTexture) {
        List focusModes = parameters.getSupportedFocusModes();
        if (captureFormat.framerate.max < mRequestFPS * 1000 || mCameraHQ) {
            Logging.i(TAG, "Andorid deprecated API , CameraHQ fps, : " + mRequestFPS);
            parameters.setPreviewFrameRate(mRequestFPS);
        } else {
            parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        }
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        if (!captureToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        if (parameters.isVideoStabilizationSupported() && mCameraStabilizaionMode > 0) {
            parameters.setVideoStabilization(true);
        }
        if (focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    private static void reportCameraFormats(int deviceId, Camera.Parameters parameters, CameraSession.Events events) {
        if (parameters == null || events == null) {
            Logging.i(TAG, "report camera formats failed, paramters illegal.");
            return;
        }
        List fpsRange = parameters.getSupportedPreviewFpsRange();
        List sizes = parameters.getSupportedPreviewSizes();
        if (fpsRange == null || sizes == null) {
            Logging.i(TAG, "Get formats failed.");
            return;
        }
        JSONObject allFormats = new JSONObject();
        try {
            allFormats.put("fps", Camera1Enumerator.convertFramerates(fpsRange));
            allFormats.put("size", Camera1Enumerator.convertSizes(sizes));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Camera.Size size = parameters.getPreviewSize();
        int[] range = new int[2];
        parameters.getPreviewFpsRange(range);
        CameraFrameRateRange captureFrameRateRange = new CameraFrameRateRange(range[0], range[1]);
        Logging.i(TAG, "width : " + size.width + ", height : " + size.height + ", frameRateRange : " + captureFrameRateRange + ", expect: " + mRequestFPS);
        JSONObject selectFormat = new JSONObject();
        try {
            selectFormat.put("w", size.width);
            selectFormat.put("h", size.height);
            selectFormat.put("fps", (Object)captureFrameRateRange);
            selectFormat.put("expect", mRequestFPS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        events.onCameraFormatsInquired(String.valueOf(deviceId), allFormats.toString(), selectFormat.toString());
    }

    private static CameraCaptureFormat findClosestCaptureFormat(Camera.Parameters parameters, int width, int height, int framerate) {
        List<CameraFrameRateRange> supportedFramerates = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.i(TAG, "Available fps ranges: " + supportedFramerates);
        CameraFrameRateRange fpsRange = CameraEnumerationUtil.getClosestSupportedFramerateRange(supportedFramerates, framerate, mCameraFpsUp, false);
        List<Size> supportedSize = Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes());
        Logging.i(TAG, "Available preview sizes: " + supportedSize);
        Size previewSize = CameraEnumerationUtil.getClosestSupportedSize(supportedSize, width, height);
        CameraCaptureFormat captureFormat = new CameraCaptureFormat(previewSize.width, previewSize.height, fpsRange);
        Logging.i(TAG, "Using capture format: " + captureFormat);
        return captureFormat;
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int width, int height) {
        return CameraEnumerationUtil.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), width, height);
    }

    private Camera1Session(CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, Camera camera, Camera.CameraInfo info, CameraCaptureFormat captureFormat, long constructionTimeNs, String rotationCompatConfig) {
        Logging.i(TAG, "Create new camera1 session on cameraid: " + cameraId + ", captureToTexture:" + captureToTexture);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = captureToTexture;
        this.applicationContext = applicationContext;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.camera = camera;
        this.info = info;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = constructionTimeNs;
        this.orientationCompatConfig = CameraSession.parseRotationCompatConfig(rotationCompatConfig, 1);
        this.isBackCamera = info.facing == 0;
        this.extraOrientation = this.isBackCamera ? this.orientationCompatConfig.backExtra : this.orientationCompatConfig.frontExtra;
        surfaceTextureHelper.setTextureSize(captureFormat.width, captureFormat.height);
        this.startCapturing();
    }

    @Override
    public void stop() {
        Logging.i(TAG, "Stop camera1 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long stopStartTime = System.nanoTime();
            this.stopInternal();
            int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
            Logging.i(TAG, "Stop camera1 session use: " + stopTimeMs);
        }
    }

    @Override
    public boolean isCameraZoomSupported() {
        return this.mZoomModeSupported;
    }

    @Override
    public void setZoom(int zoomValue) {
        Logging.i(TAG, "setZoom " + zoomValue);
        if (zoomValue == this.mZoomValue) {
            return;
        }
        this.cameraThreadHandler.post(() -> {
            try {
                Camera.Parameters param = this.getParametersSafe(this.camera);
                if (param == null) {
                    return;
                }
                if (param.isZoomSupported()) {
                    this.mZoomValue = zoomValue;
                    if (this.mZoomValue > this.mMaxZoomValue) {
                        this.mZoomValue = this.mMaxZoomValue;
                    } else if (this.mZoomValue < 0) {
                        this.mZoomValue = 0;
                    }
                    param.setZoom(this.mZoomValue);
                    try {
                        this.camera.setParameters(param);
                    }
                    catch (Exception e) {
                        Logging.w(TAG, "setZoom failed: " + e);
                    }
                } else {
                    Logging.w(TAG, "setZoom failed: not supported");
                }
            }
            catch (Exception e) {
                Logging.w(TAG, "setZoom failed: " + e);
                e.printStackTrace();
            }
        });
    }

    @Override
    public int getCurrentZoom() {
        return this.mZoomValue;
    }

    @Override
    public int getMaxZoom() {
        return this.mMaxZoomValue;
    }

    @Override
    public boolean isCameraTorchSupported() {
        return this.mFlashModeTorchSupported;
    }

    @Override
    public int setFlash(boolean flash) {
        Logging.i(TAG, "setFlash " + flash);
        if (this.mFlashModeTorchSupported) {
            this.cameraThreadHandler.post(() -> {
                Camera.Parameters param = this.getParametersSafe(this.camera);
                if (param == null) {
                    return;
                }
                List flashModes = param.getSupportedFlashModes();
                if (flashModes != null && flashModes.contains("torch")) {
                    param.setFlashMode(flash ? "torch" : "off");
                    try {
                        this.camera.setParameters(param);
                    }
                    catch (Exception e) {
                        Logging.w(TAG, "setFlash failed " + e);
                    }
                } else {
                    Logging.w(TAG, "setFlash failed: not supported torch flash");
                }
            });
            return 0;
        }
        return 2;
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        return this.mExposureModeSupported;
    }

    @Override
    public boolean isCameraFaceDetectModeSupported() {
        return this.mFDModeSupported;
    }

    @Override
    public void setMeteringAreas(float x, float y) {
        Logging.i(TAG, "setMeteringAreas {" + x + "," + y + "}");
        if (this.mAreaFocus == null) {
            this.mAreaFocus = new AreaFocus(this.applicationContext);
            this.mAreaFocus.setCamera(this.camera);
            this.mAreaFocus.setFocusCallback(this.mFocusCallback);
        }
        this.mAreaFocus.focusArea(x, y, 200, true);
    }

    @Override
    public boolean isCameraFocusSupported() {
        return this.mFocusModeSupported;
    }

    @Override
    public void setFocusAreas(float x, float y) {
        Logging.i(TAG, "setFocusAreas {" + x + "," + y + "}");
        if (this.mAreaFocus == null) {
            this.mAreaFocus = new AreaFocus(this.applicationContext);
            this.mAreaFocus.setCamera(this.camera);
            this.mAreaFocus.setFocusCallback(this.mFocusCallback);
        }
        this.mAreaFocus.focusArea(x, y, 200, false);
    }

    @Override
    public void setFocusAndMeteringCallback(CameraVideoCapturer.AreaFocusCallback callback) {
        Logging.i(TAG, "setFocusAndMeteringCallback " + callback);
        this.mFocusCallback = callback;
    }

    @Nullable
    private Camera.Parameters getParametersSafe(Camera camera) {
        Camera.Parameters param = null;
        if (camera != null) {
            try {
                param = camera.getParameters();
            }
            catch (Exception e) {
                Logging.e(TAG, "getParametersSafe failed, " + e.getMessage());
            }
        }
        return param;
    }

    private void initCameraParameters() {
        this.mZoomValue = 0;
        this.mMaxZoomValue = 0;
        this.mFlashModeTorchSupported = false;
        this.mZoomModeSupported = false;
        this.mFocusModeSupported = false;
        this.mExposureModeSupported = false;
        this.mFDModeSupported = false;
        Camera.Parameters parameters = this.getParametersSafe(this.camera);
        if (parameters == null) {
            Logging.e(TAG, "initCameraParameters: getParametersSafe failed");
            return;
        }
        if (parameters.isZoomSupported()) {
            this.mMaxZoomValue = parameters.getMaxZoom();
        }
        this.mZoomModeSupported = parameters.isZoomSupported();
        this.mExposureModeSupported = parameters.getMaxNumMeteringAreas() > 0;
        this.mFocusModeSupported = parameters.getMaxNumFocusAreas() > 0;
        this.mFDModeSupported = parameters.getMaxNumDetectedFaces() > 0;
        List flashModes = parameters.getSupportedFlashModes();
        this.mFlashModeTorchSupported = flashModes != null && flashModes.contains("torch");
    }

    private void startCapturing() {
        Logging.i(TAG, "Start capturing");
        this.checkIsOnCameraThread();
        this.initCameraParameters();
        if (this.mAreaFocus != null) {
            this.mAreaFocus.setCamera(this.camera);
        }
        this.state = SessionState.RUNNING;
        this.camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int error, Camera camera) {
                String errorMessage;
                CameraSession.DeviceErrorType deviceErrorType = CameraSession.DeviceErrorType.CAMERA_UNKNOWN_ERROR;
                if (error == 100) {
                    errorMessage = "Camera server died!";
                    deviceErrorType = CameraSession.DeviceErrorType.CAMERA1_SERVER_DIED_ERROR;
                } else {
                    errorMessage = error == 1 ? "Camera error unknown!" : "Camera error: " + error;
                }
                Logging.e(Camera1Session.TAG, errorMessage);
                Camera1Session.this.stopInternal();
                if (error == 2) {
                    Camera1Session.this.events.onCameraDisconnected(Camera1Session.this);
                } else {
                    Camera1Session.this.events.onCameraError(Camera1Session.this, errorMessage, deviceErrorType.getCode());
                }
            }
        });
        try {
            if (this.captureToTexture) {
                this.listenForTextureFrames();
            } else {
                this.listenForBytebufferFrames();
            }
            this.camera.startPreview();
        }
        catch (RuntimeException e) {
            this.stopInternal();
            this.events.onCameraError(this, e.getMessage(), CameraSession.DeviceErrorType.CAMERA1_SURFACE_ERROR.getCode());
        }
    }

    private void stopInternal() {
        Logging.i(TAG, "Stop internal");
        if (this.mAreaFocus != null) {
            this.mAreaFocus.destory();
            this.mAreaFocus = null;
        }
        this.checkIsOnCameraThread();
        if (this.state == SessionState.STOPPED) {
            Logging.i(TAG, "Camera is already stopped");
            return;
        }
        try {
            this.state = SessionState.STOPPED;
            this.surfaceTextureHelper.stopListening();
            this.camera.stopPreview();
            this.camera.release();
        }
        catch (Exception e) {
            Logging.e(TAG, "Stop camera error: " + e.getMessage());
        }
        this.events.onCameraClosed(this);
        Logging.i(TAG, "Stop done");
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(frame -> {
            this.checkIsOnCameraThread();
            if (this.state != SessionState.RUNNING) {
                Logging.i(TAG, "Texture frame captured but camera is no longer running.");
                return;
            }
            if (!this.firstFrameReported) {
                int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTimeNs);
                this.firstFrameReported = true;
            }
            VideoFrame modifiedFrame = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)frame.getBuffer(), this.info.facing == 1, 0), this.getFrameOrientation(), frame.getTimestampNs());
            modifiedFrame.setIsMirror(this.info.facing == 1);
            modifiedFrame.setDualFrame(false);
            this.events.onFrameCaptured(this, modifiedFrame);
            modifiedFrame.release();
        });
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] data, Camera callbackCamera) {
                Camera1Session.this.checkIsOnCameraThread();
                if (callbackCamera != Camera1Session.this.camera) {
                    Logging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    Logging.i(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!Camera1Session.this.firstFrameReported) {
                    Camera1Session.this.firstFrameReported = true;
                }
                NV21Buffer frameBuffer = new NV21Buffer(data, ((Camera1Session)Camera1Session.this).captureFormat.width, ((Camera1Session)Camera1Session.this).captureFormat.height, () -> Camera1Session.this.cameraThreadHandler.post(() -> {
                    if (Camera1Session.this.state == SessionState.RUNNING) {
                        Camera1Session.this.camera.addCallbackBuffer(data);
                    }
                }));
                VideoFrame frame = new VideoFrame(frameBuffer, Camera1Session.this.getFrameOrientation(), captureTimeNs);
                frame.setDualFrame(false);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, frame);
                frame.release();
            }
        });
    }

    private int getFrameOrientation() {
        int tempFrameOrientation;
        if (this.orientationCompatConfig.frontFixed > -1 && !this.isBackCamera) {
            return this.orientationCompatConfig.frontFixed;
        }
        if (this.orientationCompatConfig.backFixed > -1 && this.isBackCamera) {
            return this.orientationCompatConfig.backFixed;
        }
        int rotation = CameraSession.getDeviceOrientation(ContextUtils.getCurrentContext());
        if (this.isBackCamera) {
            rotation = 360 - rotation;
        }
        if ((tempFrameOrientation = (this.info.orientation + rotation) % 360 + this.extraOrientation) != this.frameOrientation) {
            Logging.w(TAG, "pre_orientation: " + this.frameOrientation + " , new: " + tempFrameOrientation + " , device: " + rotation + " , extra: " + this.extraOrientation + " , facing:" + (this.isBackCamera ? "back" : "front"));
            this.frameOrientation = tempFrameOrientation;
        }
        return tempFrameOrientation;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

