/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture.core;

import android.hardware.camera2.CaptureResult;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraCaptureMetaData;

@RequiresApi(value=21)
final class Camera2CaptureResult {
    private static final String TAG = "Camera2CaptureResult";
    private CaptureResult mCaptureResult;

    Camera2CaptureResult(CaptureResult captureResult) {
        this.mCaptureResult = captureResult;
    }

    public void setCaptureResult(CaptureResult captureResult) {
        this.mCaptureResult = captureResult;
    }

    @NonNull
    public CameraCaptureMetaData.AfMode getAfMode() {
        Integer mode = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AF_MODE);
        if (mode == null) {
            return CameraCaptureMetaData.AfMode.UNKNOWN;
        }
        switch (mode) {
            case 0: 
            case 5: {
                return CameraCaptureMetaData.AfMode.OFF;
            }
            case 1: 
            case 2: {
                return CameraCaptureMetaData.AfMode.ON_MANUAL_AUTO;
            }
            case 3: 
            case 4: {
                return CameraCaptureMetaData.AfMode.ON_CONTINUOUS_AUTO;
            }
        }
        Log.e((String)TAG, (String)("Undefined af mode: " + mode));
        return CameraCaptureMetaData.AfMode.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AfState getAfState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AF_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AfState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AfState.INACTIVE;
            }
            case 1: 
            case 3: 
            case 6: {
                return CameraCaptureMetaData.AfState.SCANNING;
            }
            case 4: {
                return CameraCaptureMetaData.AfState.LOCKED_FOCUSED;
            }
            case 5: {
                return CameraCaptureMetaData.AfState.LOCKED_NOT_FOCUSED;
            }
            case 2: {
                return CameraCaptureMetaData.AfState.PASSIVE_FOCUSED;
            }
        }
        Log.e((String)TAG, (String)("Undefined af state: " + state));
        return CameraCaptureMetaData.AfState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AeState getAeState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AE_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AeState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AeState.INACTIVE;
            }
            case 1: 
            case 5: {
                return CameraCaptureMetaData.AeState.SEARCHING;
            }
            case 4: {
                return CameraCaptureMetaData.AeState.FLASH_REQUIRED;
            }
            case 2: {
                return CameraCaptureMetaData.AeState.CONVERGED;
            }
            case 3: {
                return CameraCaptureMetaData.AeState.LOCKED;
            }
        }
        Log.e((String)TAG, (String)("Undefined ae state: " + state));
        return CameraCaptureMetaData.AeState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AwbState getAwbState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AWB_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AwbState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AwbState.INACTIVE;
            }
            case 1: {
                return CameraCaptureMetaData.AwbState.METERING;
            }
            case 2: {
                return CameraCaptureMetaData.AwbState.CONVERGED;
            }
            case 3: {
                return CameraCaptureMetaData.AwbState.LOCKED;
            }
        }
        Log.e((String)TAG, (String)("Undefined awb state: " + state));
        return CameraCaptureMetaData.AwbState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.FlashState getFlashState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.FLASH_STATE);
        if (state == null) {
            return CameraCaptureMetaData.FlashState.UNKNOWN;
        }
        switch (state) {
            case 0: 
            case 1: {
                return CameraCaptureMetaData.FlashState.NONE;
            }
            case 2: {
                return CameraCaptureMetaData.FlashState.READY;
            }
            case 3: 
            case 4: {
                return CameraCaptureMetaData.FlashState.FIRED;
            }
        }
        Log.e((String)TAG, (String)("Undefined flash state: " + state));
        return CameraCaptureMetaData.FlashState.UNKNOWN;
    }

    @NonNull
    public CaptureResult getCaptureResult() {
        return this.mCaptureResult;
    }
}

