/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Range;
import android.view.Surface;
import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.Size;
import com.netease.lava.webrtc.SurfaceTextureHelper;
import com.netease.lava.webrtc.TextureBufferImpl;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.YuvHelper;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.video.device.cameracapture.Camera2Enumerator;
import com.netease.yunxin.lite.video.device.cameracapture.CoordinateTransformer;
import com.netease.yunxin.lite.video.device.cameracapture.core.Camera2CaptureResult;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraCaptureFormat;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraEnumerationUtil;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraFrameRateRange;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraSession;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@RequiresApi(api=21)
public class Camera2Session
implements CameraSession {
    private static final String TAG = "Camera2Session";
    private final Handler cameraThreadHandler;
    private final CameraSession.CreateSessionCallback callback;
    private final CameraSession.Events events;
    private final Context applicationContext;
    private final CameraManager cameraManager;
    private SurfaceTextureHelper surfaceTextureHelper;
    private final String cameraId;
    private final int width;
    private final int height;
    private final int framerate;
    private final boolean mCameraHQ;
    private final boolean mCameraFpsUp;
    private final CameraStabilizationMode mCameraStabilizationMode;
    private final boolean captureToTexture;
    private static final int ZOOM_GRADE = 100;
    private static final int METERING_AREA_SIZE = 300;
    private static final int FOCUS_AREA_SIZE = 200;
    private ArrayList<Float> mCameraZoomRatios;
    private int mCurZoom;
    private int mMaxZoom;
    private CoordinateTransformer mTransformer = null;
    @Nullable
    private CameraVideoCapturer.AreaFocusCallback mAreaFocusCallback;
    private ImageReader mImageReader = null;
    private CameraCharacteristics cameraCharacteristics;
    private int cameraOrientation;
    private int extraOrientation;
    private boolean isCameraFrontFacing;
    private int fpsUnitFactor;
    private CameraCaptureFormat captureFormat;
    @Nullable
    private CameraDevice cameraDevice;
    @Nullable
    private Surface textureSurface;
    @Nullable
    private Surface imageSurface;
    @Nullable
    private CameraCaptureSession captureSession;
    private CaptureRequest.Builder captureRequestBuilder;
    private CameraCaptureSession.CaptureCallback mCaptureCallback;
    private Camera2CaptureResult mCaptureResult;
    private SessionState state = SessionState.RUNNING;
    private boolean firstFrameReported;
    private final long constructionTimeNs;
    private final CameraSession.OrientationCompatConfig orientationCompatConfig;
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            Image image = null;
            try {
                int stridePixelV;
                image = reader.acquireLatestImage();
                if (image == null) {
                    Logging.e(Camera2Session.TAG, "failed to acquire Image from ImageReader");
                    return;
                }
                int width = image.getWidth();
                int height = image.getHeight();
                Image.Plane[] plane = image.getPlanes();
                if (plane == null || plane.length != 3) {
                    image.close();
                    return;
                }
                int strideY = image.getPlanes()[0].getRowStride();
                int strideU = image.getPlanes()[1].getRowStride();
                int strideV = image.getPlanes()[2].getRowStride();
                int stridePixelU = image.getPlanes()[1].getPixelStride();
                if (stridePixelU != (stridePixelV = image.getPlanes()[2].getPixelStride())) {
                    Logging.e(Camera2Session.TAG, "two chrominance (UV) has different pixel stride U: " + stridePixelU + " V:" + stridePixelV);
                    image.close();
                    return;
                }
                long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                JavaI420Buffer i420Buffer = JavaI420Buffer.allocate(width, height);
                YuvHelper.Android420ToI420(image.getPlanes()[0].getBuffer(), strideY, image.getPlanes()[1].getBuffer(), strideU, image.getPlanes()[2].getBuffer(), strideV, stridePixelU, i420Buffer.getDataY(), i420Buffer.getDataU(), i420Buffer.getDataV(), width, height);
                VideoFrame i420VideoFrame = new VideoFrame(i420Buffer, Camera2Session.this.getFrameOrientation(), captureTimeNs);
                if (Camera2Session.this.events != null) {
                    i420VideoFrame.setDualFrame(false);
                    Camera2Session.this.events.onFrameCaptured(Camera2Session.this, i420VideoFrame);
                }
                image.close();
                i420VideoFrame.release();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (image != null) {
                    image.close();
                }
                return;
            }
        }
    };
    private int frameOrientation = -1;

    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, Context applicationContext, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String cameraId, int width, int height, int framerate, boolean captureToTexture, boolean cameraHQ, boolean cameraFpsUp, int cameraStabilizationMode, String rotationCompatConfig) {
        new Camera2Session(callback, events, applicationContext, cameraManager, surfaceTextureHelper, cameraId, width, height, framerate, captureToTexture, cameraHQ, cameraFpsUp, cameraStabilizationMode, rotationCompatConfig);
    }

    private Camera2Session(CameraSession.CreateSessionCallback callback, CameraSession.Events events, Context applicationContext, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String cameraId, int width, int height, int framerate, boolean captureToTexture, boolean cameraHQ, boolean cameraFpsUp, int cameraStabilizationMode, String rotationCompatConfig) {
        Logging.i(TAG, "Create new camera2 session on camera " + cameraId + ", captureToTexture: " + captureToTexture + ", cameraHQ: " + cameraHQ + ", cameraFpsUp:" + cameraFpsUp);
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = callback;
        this.events = events;
        this.applicationContext = applicationContext;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.width = width;
        this.height = height;
        this.framerate = framerate;
        this.mCameraHQ = cameraHQ;
        this.mCameraFpsUp = cameraFpsUp;
        this.mCameraStabilizationMode = CameraStabilizationMode.fromValue(cameraStabilizationMode);
        this.captureToTexture = captureToTexture;
        this.orientationCompatConfig = CameraSession.parseRotationCompatConfig(rotationCompatConfig, 2);
        this.start();
    }

    private void start() {
        this.checkIsOnCameraThread();
        Logging.i(TAG, "start");
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (CameraAccessException | IllegalArgumentException e) {
            this.reportError("getCameraCharacteristics(): " + CameraSession.getExceptionDescription((Exception)e), CameraSession.DeviceErrorType.CAMERA2_GET_CHA_ERROR);
            return;
        }
        this.cameraOrientation = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.isCameraFrontFacing = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        this.extraOrientation = this.isCameraFrontFacing ? this.orientationCompatConfig.frontExtra : this.orientationCompatConfig.backExtra;
        this.findCaptureFormat();
        this.openCamera();
    }

    private void findCaptureFormat() {
        this.checkIsOnCameraThread();
        Range[] fpsRanges = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(fpsRanges);
        List<CameraFrameRateRange> framerateRanges = Camera2Enumerator.convertFramerates(fpsRanges, this.fpsUnitFactor);
        List<Size> sizes = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        Logging.i(TAG, "Available preview sizes: " + sizes);
        Logging.i(TAG, "Available fps ranges: " + framerateRanges);
        CameraFrameRateRange bestFpsRange = null;
        if (!this.mCameraHQ) {
            bestFpsRange = CameraEnumerationUtil.getClosestSupportedFramerateRange(framerateRanges, this.framerate, this.mCameraFpsUp, true);
        } else {
            for (CameraFrameRateRange range : framerateRanges) {
                if (range.max < this.framerate * this.fpsUnitFactor) continue;
                bestFpsRange = new CameraFrameRateRange(range.min, range.max);
                Logging.i(TAG, "CameraHQ fps:" + bestFpsRange);
                break;
            }
        }
        Size bestSize = CameraEnumerationUtil.getClosestSupportedSize(sizes, this.width, this.height);
        this.captureFormat = new CameraCaptureFormat(bestSize.width, bestSize.height, bestFpsRange);
        Logging.i(TAG, "Using capture format: " + this.captureFormat);
        JSONObject allFormats = new JSONObject();
        try {
            allFormats.put("fps", framerateRanges);
            allFormats.put("size", sizes);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject selectFormat = new JSONObject();
        try {
            selectFormat.put("w", bestSize.width);
            selectFormat.put("h", bestSize.height);
            selectFormat.put("fps", (Object)bestFpsRange);
            selectFormat.put("expect", this.framerate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.events.onCameraFormatsInquired(String.valueOf(this.cameraId), allFormats.toString(), selectFormat.toString());
    }

    @SuppressLint(value={"MissingPermission"})
    private void openCamera() {
        this.checkIsOnCameraThread();
        Logging.i(TAG, "Opening camera " + this.cameraId);
        this.events.onCameraOpening();
        try {
            this.cameraManager.openCamera(this.cameraId, (CameraDevice.StateCallback)new CameraStateCallback(), this.cameraThreadHandler);
            if (this.callback != null) {
                this.callback.onOpening(this);
            }
        }
        catch (CameraAccessException | IllegalStateException | SecurityException e) {
            this.reportError("Failed to open camera: " + CameraSession.getExceptionDescription((Exception)e), CameraSession.DeviceErrorType.CAMERA2_INIT_ERROR);
            return;
        }
    }

    @Override
    public void stop() {
        Logging.i(TAG, "Stop camera2 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long stopStartTime = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
            Logging.i(TAG, "Stop camera2 session cost ms: " + stopTimeMs);
        }
    }

    private void prepareZoomMode() {
        float maxDigitalZoom = ((Float)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        if (maxDigitalZoom > 1.0f) {
            float step = (maxDigitalZoom * 100.0f - 100.0f) / 100.0f;
            this.mCameraZoomRatios = new ArrayList();
            this.mCameraZoomRatios.add(Float.valueOf(100.0f));
            for (int i = 1; i < 99; ++i) {
                this.mCameraZoomRatios.add(Float.valueOf(100.0f + step * (float)i));
            }
            this.mCameraZoomRatios.add(Float.valueOf(maxDigitalZoom * 100.0f));
            this.mMaxZoom = this.mCameraZoomRatios.size() - 1;
        } else {
            this.mCameraZoomRatios = null;
        }
    }

    @Override
    public void setZoom(int zoomValue) {
        if (zoomValue < 0 || zoomValue > this.mMaxZoom || zoomValue == this.mCurZoom) {
            Logging.e(TAG, "bad zoom value!");
            return;
        }
        this.cameraThreadHandler.post(() -> {
            if (this.cameraCharacteristics != null) {
                float zoom = this.mCameraZoomRatios.get(zoomValue).floatValue() / 100.0f;
                Rect sensor_rect = (Rect)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                int hwidth = (int)((double)sensor_rect.width() / (2.0 * (double)zoom));
                int hheight = (int)((double)sensor_rect.height() / (2.0 * (double)zoom));
                int left = sensor_rect.width() / 2 - hwidth;
                int right = sensor_rect.width() / 2 + hwidth;
                int top = sensor_rect.height() / 2 - hheight;
                int bottom = sensor_rect.height() / 2 + hheight;
                Rect scalarCropRegion = new Rect(left, top, right, bottom);
                this.captureRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)scalarCropRegion);
                try {
                    this.captureSession.setRepeatingRequest(this.captureRequestBuilder.build(), this.mCaptureCallback, this.cameraThreadHandler);
                }
                catch (CameraAccessException | IllegalArgumentException | IllegalStateException e) {
                    e.printStackTrace();
                    Logging.e(TAG, "setZoom failed: " + e.getMessage());
                    return;
                }
                this.mCurZoom = zoomValue;
            }
        });
    }

    @Override
    public int getCurrentZoom() {
        return this.mCurZoom;
    }

    @Override
    public int getMaxZoom() {
        return this.mMaxZoom;
    }

    @Override
    public int setFlash(boolean flash) {
        if (!this.isCameraTorchSupported()) {
            return 2;
        }
        boolean isPosted = this.cameraThreadHandler.post(() -> {
            try {
                if (flash) {
                    this.captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                } else {
                    this.captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                }
                this.captureSession.setRepeatingRequest(this.captureRequestBuilder.build(), this.mCaptureCallback, this.cameraThreadHandler);
            }
            catch (CameraAccessException | IllegalArgumentException | IllegalStateException e) {
                e.printStackTrace();
            }
        });
        if (!isPosted) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isCameraZoomSupported() {
        return this.mCameraZoomRatios != null;
    }

    @Override
    public boolean isCameraTorchSupported() {
        try {
            if (this.cameraCharacteristics != null) {
                return (Boolean)this.cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        try {
            if (this.cameraCharacteristics != null) {
                return (Integer)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE) > 0;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isCameraFaceDetectModeSupported() {
        int[] faceDetectModes = (int[])this.cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        int faceCount = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        for (int faceMode : faceDetectModes) {
            Logging.i(TAG, "faceMode: " + faceMode + " face " + faceCount);
            if (faceMode < 1 || faceCount <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isCameraFDSceneModeSupported() {
        int[] sceneModes;
        for (int sceneMode : sceneModes = (int[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_SCENE_MODES)) {
            if (sceneMode != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCameraFocusSupported() {
        try {
            if (this.cameraCharacteristics != null) {
                return (Integer)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF) > 0;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public void setFocusAndMeteringCallback(CameraVideoCapturer.AreaFocusCallback callback) {
        this.mAreaFocusCallback = callback;
    }

    @Override
    public void setMeteringAreas(float x, float y) {
        if (this.mTransformer == null) {
            this.mTransformer = new CoordinateTransformer(this.cameraCharacteristics, this.applicationContext);
        }
        this.mTransformer.setAreaSize(300);
        RectF areaRectF = this.mTransformer.getAreaRect(x, y);
        Rect cameraRect = this.mTransformer.toCameraSpace(areaRectF);
        Logging.i(TAG, "setMeteringAreas areaRectF  " + areaRectF + " cameraRect " + cameraRect);
        MeteringRectangle materingArea = new MeteringRectangle(cameraRect, 1000);
        if (this.mAreaFocusCallback != null) {
            this.mAreaFocusCallback.exposureArea(this.mTransformer.toIntRect(areaRectF));
        }
        this.cameraThreadHandler.post(() -> {
            try {
                this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{materingArea});
                this.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
                this.captureSession.setRepeatingRequest(this.captureRequestBuilder.build(), this.mCaptureCallback, this.cameraThreadHandler);
            }
            catch (CameraAccessException | IllegalArgumentException | IllegalStateException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void setFocusAreas(float x, float y) {
        if (this.mTransformer == null) {
            this.mTransformer = new CoordinateTransformer(this.cameraCharacteristics, this.applicationContext);
        }
        this.mTransformer.setAreaSize(200);
        RectF areaRectF = this.mTransformer.getAreaRect(x, y);
        Rect cameraRect = this.mTransformer.toCameraSpace(areaRectF);
        Logging.i(TAG, "setFocusAreas areaRectF  " + areaRectF + " cameraRect " + cameraRect);
        MeteringRectangle focusArea = new MeteringRectangle(cameraRect, 1000);
        if (this.mAreaFocusCallback != null) {
            this.mAreaFocusCallback.focusArea(this.mTransformer.toIntRect(areaRectF));
        }
        this.cameraThreadHandler.post(() -> {
            try {
                this.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                this.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{focusArea});
                this.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                this.captureSession.setRepeatingRequest(this.captureRequestBuilder.build(), this.mCaptureCallback, this.cameraThreadHandler);
                this.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                this.captureSession.capture(this.captureRequestBuilder.build(), null, this.cameraThreadHandler);
            }
            catch (CameraAccessException | IllegalArgumentException | IllegalStateException e) {
                e.printStackTrace();
            }
        });
    }

    private void stopInternal() {
        Logging.i(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.stopListening();
            this.surfaceTextureHelper = null;
        }
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.imageSurface != null) {
            this.imageSurface.release();
            this.imageSurface = null;
        }
        if (this.textureSurface != null) {
            this.textureSurface.release();
            this.textureSurface = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        Logging.i(TAG, "Stop done");
    }

    private void reportError(String error, CameraSession.DeviceErrorType deviceErrorType) {
        this.checkIsOnCameraThread();
        boolean startFailure = this.captureSession == null && this.state != SessionState.STOPPED;
        Logging.e(TAG, "Error: " + error + ", startFailure:" + startFailure);
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (startFailure) {
            this.callback.onFailure(CameraSession.FailureType.ERROR, error, deviceErrorType);
        } else {
            this.events.onCameraError(this, error, deviceErrorType.getCode());
        }
    }

    private int getFrameOrientation() {
        int tempFrameOrientation;
        if (this.orientationCompatConfig.frontFixed > -1 && this.isCameraFrontFacing) {
            return this.orientationCompatConfig.frontFixed;
        }
        if (this.orientationCompatConfig.backFixed > -1 && !this.isCameraFrontFacing) {
            return this.orientationCompatConfig.backFixed;
        }
        int rotation = CameraSession.getDeviceOrientation(ContextUtils.getCurrentContext());
        if (!this.isCameraFrontFacing) {
            rotation = 360 - rotation;
        }
        if ((tempFrameOrientation = (this.cameraOrientation + rotation) % 360 + this.extraOrientation) != this.frameOrientation) {
            Logging.w(TAG, "pre_orientation: " + this.frameOrientation + " , new: " + tempFrameOrientation + " , camera: " + this.cameraOrientation + " , device: " + rotation + " , extra: " + this.extraOrientation + " , facing:" + (this.isCameraFrontFacing ? "front" : "back"));
            this.frameOrientation = tempFrameOrientation;
        }
        return tempFrameOrientation;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureCallback() {
        }

        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            Logging.i(Camera2Session.TAG, "Capture failed: " + failure);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            super.onCaptureCompleted(session, request, result);
        }
    }

    @RequiresApi(api=21)
    private class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionCallback() {
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            Camera2Session.this.checkIsOnCameraThread();
            session.close();
            Camera2Session.this.reportError("Failed to configure capture session.", CameraSession.DeviceErrorType.CAMERA2_CONFIGURE_SESSION_ERROR);
        }

        public void onConfigured(CameraCaptureSession session) {
            Camera2Session.this.checkIsOnCameraThread();
            if (Camera2Session.this.cameraDevice == null) {
                Logging.w(Camera2Session.TAG, "onConfigured, but cameraDevice released");
                return;
            }
            Logging.i(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.this.captureSession = session;
            Camera2Session.this.mCaptureCallback = new CameraCaptureCallback();
            try {
                Camera2Session.this.captureRequestBuilder = Camera2Session.this.cameraDevice.createCaptureRequest(3);
                Camera2Session.this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor)));
                switch (Camera2Session.this.mCameraStabilizationMode) {
                    case STABILIZATION_UNDEFINED: {
                        Logging.i(Camera2Session.TAG, "Compat camera2 Stabilization mode: STABILIZATION_UNDEFINED");
                        this.openOpticalStabilizationMode(Camera2Session.this.captureRequestBuilder);
                        break;
                    }
                    case STABILIZATION_ALL_OFF: {
                        Logging.i(Camera2Session.TAG, "Compat camera2 Stabilization mode: STABILIZATION_ALL_OFF");
                        break;
                    }
                    case STABILIZATION_OPTICAL: {
                        Logging.i(Camera2Session.TAG, "Compat camera2 Stabilization mode: STABILIZATION_OPTICAL");
                        this.openOpticalStabilizationMode(Camera2Session.this.captureRequestBuilder);
                        break;
                    }
                    case STABILIZATION_SOFTWARE: {
                        Logging.i(Camera2Session.TAG, "Compat camera2 Stabilization mode: STABILIZATION_SOFTWARE");
                        this.openVideoStabilizationMode(Camera2Session.this.captureRequestBuilder);
                        break;
                    }
                    case STABILIZATION_ALL_ON: {
                        Logging.i(Camera2Session.TAG, "Compat camera2 Stabilization mode: STABILIZATION_ALL_ON");
                        this.chooseStabilizationMode(Camera2Session.this.captureRequestBuilder);
                        break;
                    }
                }
                this.chooseExposureMode(Camera2Session.this.captureRequestBuilder);
                this.chooseFocusMode(Camera2Session.this.captureRequestBuilder);
                this.chooseWhiteBalanceMode(Camera2Session.this.captureRequestBuilder);
                this.chooseFDMode(Camera2Session.this.captureRequestBuilder);
                Camera2Session.this.prepareZoomMode();
                if (Camera2Session.this.textureSurface != null) {
                    Camera2Session.this.captureRequestBuilder.addTarget(Camera2Session.this.textureSurface);
                }
                if (Camera2Session.this.imageSurface != null) {
                    Camera2Session.this.captureRequestBuilder.addTarget(Camera2Session.this.imageSurface);
                }
                session.setRepeatingRequest(Camera2Session.this.captureRequestBuilder.build(), Camera2Session.this.mCaptureCallback, Camera2Session.this.cameraThreadHandler);
            }
            catch (Exception e) {
                Camera2Session.this.reportError("Failed to start capture request. " + CameraSession.getExceptionDescription(e), CameraSession.DeviceErrorType.CAMERA2_START_CAP_ERROR);
                return;
            }
            Camera2Session.this.surfaceTextureHelper.startListening(frame -> {
                Camera2Session.this.checkIsOnCameraThread();
                if (Camera2Session.this.state != SessionState.RUNNING) {
                    Logging.i(Camera2Session.TAG, "Texture frame captured but camera is no longer running.");
                    return;
                }
                if (!Camera2Session.this.firstFrameReported) {
                    Camera2Session.this.firstFrameReported = true;
                }
                VideoFrame modifiedFrame = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)frame.getBuffer(), Camera2Session.this.isCameraFrontFacing, -Camera2Session.this.cameraOrientation), Camera2Session.this.getFrameOrientation(), frame.getTimestampNs());
                modifiedFrame.setIsMirror(Camera2Session.this.isCameraFrontFacing);
                modifiedFrame.setDualFrame(false);
                Camera2Session.this.events.onFrameCaptured(Camera2Session.this, modifiedFrame);
                modifiedFrame.release();
            });
            Logging.i(Camera2Session.TAG, "Camera device successfully started.");
            Camera2Session.this.callback.onDone(Camera2Session.this);
        }

        private void chooseStabilizationMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableVideoStabilization;
            int[] availableOpticalStabilization = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (availableOpticalStabilization != null) {
                for (int mode : availableOpticalStabilization) {
                    if (mode != 1) continue;
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.i(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            if ((availableVideoStabilization = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES)) != null) {
                for (int mode : availableVideoStabilization) {
                    if (mode != 1) continue;
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                    Logging.i(Camera2Session.TAG, "Using video stabilization.");
                    return;
                }
            }
            Logging.i(Camera2Session.TAG, "Stabilization not available.");
        }

        private void openOpticalStabilizationMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableOpticalStabilization = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (availableOpticalStabilization != null) {
                for (int mode : availableOpticalStabilization) {
                    if (mode != 1) continue;
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.i(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            Logging.i(Camera2Session.TAG, "Optical Stabilization not available.");
        }

        private void openVideoStabilizationMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableVideoStabilization = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
            if (availableVideoStabilization != null) {
                for (int mode : availableVideoStabilization) {
                    if (mode != 1) continue;
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                    Logging.i(Camera2Session.TAG, "Using video stabilization.");
                    return;
                }
            }
            Logging.i(Camera2Session.TAG, "Video Stabilization not available.");
        }

        private void chooseExposureMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableExposureModes;
            for (int mode : availableExposureModes = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES)) {
                if (mode != 1) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                captureRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                Logging.i(Camera2Session.TAG, "Using Exposure  auto with no flash control");
                return;
            }
            Logging.i(Camera2Session.TAG, "Auto-exposure is not available.");
        }

        private void chooseFocusMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableFocusModes;
            for (int mode : availableFocusModes = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
                if (mode != 3) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.i(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.i(Camera2Session.TAG, "Auto-focus is not available.");
        }

        private void chooseWhiteBalanceMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableWhiteBalanceModes;
            for (int mode : availableWhiteBalanceModes = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES)) {
                if (mode != 1) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
                captureRequestBuilder.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)false);
                Logging.i(Camera2Session.TAG, "Using white balance auto-mode.");
                return;
            }
            Logging.i(Camera2Session.TAG, "Auto-White-Balance is not available.");
        }

        private void chooseFDMode(CaptureRequest.Builder captureRequestBuilder) {
            if (Camera2Session.this.isCameraFDSceneModeSupported()) {
                captureRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)2);
                captureRequestBuilder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)1);
            }
        }
    }

    private class CameraStateCallback
    extends CameraDevice.StateCallback {
        private CameraStateCallback() {
        }

        private String getErrorDescription(int errorCode) {
            switch (errorCode) {
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 1: {
                    return "Camera device is in use already.";
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
            }
            return "Unknown camera error: " + errorCode;
        }

        public void onDisconnected(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            boolean startFailure = Camera2Session.this.captureSession == null && Camera2Session.this.state != SessionState.STOPPED;
            Camera2Session.this.state = SessionState.STOPPED;
            Camera2Session.this.stopInternal();
            if (startFailure) {
                Camera2Session.this.callback.onFailure(CameraSession.FailureType.DISCONNECTED, "Camera disconnected / evicted.", CameraSession.DeviceErrorType.CAMERA_UNKNOWN_ERROR);
            } else {
                Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
            }
        }

        public void onError(CameraDevice camera, int errorCode) {
            Camera2Session.this.checkIsOnCameraThread();
            Camera2Session.this.reportError(this.getErrorDescription(errorCode), CameraSession.DeviceErrorType.CAMERA2_INIT_ERROR);
        }

        public void onOpened(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            if (Camera2Session.this.state == SessionState.STOPPED) {
                Logging.w(Camera2Session.TAG, "onOpened, Camera has error,do not continue ");
                return;
            }
            Logging.i(Camera2Session.TAG, "Camera opened.");
            Camera2Session.this.cameraDevice = camera;
            ArrayList<Surface> surfaces = new ArrayList<Surface>();
            if (Camera2Session.this.captureToTexture) {
                Camera2Session.this.surfaceTextureHelper.setTextureSize(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height);
                Camera2Session.this.textureSurface = new Surface(Camera2Session.this.surfaceTextureHelper.getSurfaceTexture());
                surfaces.add(Camera2Session.this.textureSurface);
            } else {
                Camera2Session.this.mImageReader = ImageReader.newInstance((int)((Camera2Session)Camera2Session.this).captureFormat.width, (int)((Camera2Session)Camera2Session.this).captureFormat.height, (int)35, (int)2);
                Camera2Session.this.mImageReader.setOnImageAvailableListener(Camera2Session.this.mOnImageAvailableListener, Camera2Session.this.cameraThreadHandler);
                Camera2Session.this.imageSurface = Camera2Session.this.mImageReader.getSurface();
                surfaces.add(Camera2Session.this.imageSurface);
            }
            try {
                camera.createCaptureSession(Arrays.asList(surfaces.toArray(new Surface[surfaces.size()])), (CameraCaptureSession.StateCallback)new CaptureSessionCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException | IllegalArgumentException | IllegalStateException e) {
                Camera2Session.this.reportError("Failed to create capture session. " + CameraSession.getExceptionDescription((Exception)e), CameraSession.DeviceErrorType.CAMERA2_CREATE_SESSION_ERROR);
                return;
            }
        }

        public void onClosed(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.i(Camera2Session.TAG, "Camera device closed.");
            Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }
    }

    public static enum CameraStabilizationMode {
        STABILIZATION_UNDEFINED(-1),
        STABILIZATION_ALL_OFF(0),
        STABILIZATION_OPTICAL(1),
        STABILIZATION_SOFTWARE(2),
        STABILIZATION_ALL_ON(3);

        private final int value;

        private CameraStabilizationMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CameraStabilizationMode fromValue(int value) {
            for (CameraStabilizationMode mode : CameraStabilizationMode.values()) {
                if (mode.getValue() != value) continue;
                return mode;
            }
            return STABILIZATION_UNDEFINED;
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

