/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture.core;

import android.graphics.ImageFormat;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraFrameRateRange;

public class CameraCaptureFormat {
    public final int width;
    public final int height;
    public final CameraFrameRateRange framerate;
    public final int imageFormat = 17;

    public CameraCaptureFormat(int width, int height, int minFramerate, int maxFramerate) {
        this.width = width;
        this.height = height;
        this.framerate = new CameraFrameRateRange(minFramerate, maxFramerate);
    }

    public CameraCaptureFormat(int width, int height, CameraFrameRateRange framerate) {
        this.width = width;
        this.height = height;
        this.framerate = framerate;
    }

    public int frameSize() {
        return CameraCaptureFormat.frameSize(this.width, this.height, 17);
    }

    public static int frameSize(int width, int height, int imageFormat) {
        if (imageFormat != 17) {
            throw new UnsupportedOperationException("Don't know how to calculate the frame size of non-NV21 image formats.");
        }
        return width * height * ImageFormat.getBitsPerPixel((int)imageFormat) / 8;
    }

    public String toString() {
        return this.width + "x" + this.height + "@" + this.framerate;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CameraCaptureFormat)) {
            return false;
        }
        CameraCaptureFormat otherFormat = (CameraCaptureFormat)other;
        return this.width == otherFormat.width && this.height == otherFormat.height && this.framerate.equals(otherFormat.framerate);
    }

    public int hashCode() {
        return 1 + (this.width * 65497 + this.height) * 251 + this.framerate.hashCode();
    }

    @Keep
    @CalledByNative
    public int getWidth() {
        return this.width;
    }

    @Keep
    @CalledByNative
    public int getHeight() {
        return this.height;
    }
}

