/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture.core;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.netease.lava.webrtc.ForegroundMonitor;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.SurfaceTextureHelper;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.yunxin.lite.video.device.cameracapture.core.Camera1Session;
import com.netease.yunxin.lite.video.device.cameracapture.core.Camera2Session;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraEnumerator;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraSession;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import com.netease.yunxin.lite.video.device.cameracapture.core.CapturerObserver;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public abstract class CameraCapturer
implements CameraVideoCapturer {
    private static final String TAG = "CameraCapturer";
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private static final int OPEN_CAMERA_TIMEOUT = 5000;
    private static final int CLOSE_CAMERA_TIMEOUT = 3000;
    protected boolean captureToTexture;
    protected boolean cameraHQ;
    protected boolean cameraFpsUp;
    protected int cameraStabilizationMode;
    protected int cameraId;
    private final CameraEnumerator cameraEnumerator;
    @Nullable
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private final Handler uiThreadHandler;
    private AtomicBoolean mShouldReopen;
    private boolean mIsForeground;
    protected String rotationCompatConfig;
    @Nullable
    private final CameraSession.CreateSessionCallback createSessionCallback = new CameraSession.CreateSessionCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOpening(CameraSession session) {
            CameraCapturer.this.checkIsOnCameraThread();
            Logging.i(CameraCapturer.TAG, "Opened session. Switch state: " + (Object)((Object)CameraCapturer.this.switchState));
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.currentSession = session;
                CameraCapturer.this.stateLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDone(CameraSession session) {
            CameraCapturer.this.checkIsOnCameraThread();
            boolean isCamera2 = session instanceof Camera2Session;
            Logging.i(CameraCapturer.TAG, "Create session done. Switch state: " + (Object)((Object)CameraCapturer.this.switchState) + " isCamera2: " + isCamera2);
            CameraCapturer.this.uiThreadHandler.removeCallbacks(CameraCapturer.this.openCameraTimeoutRunnable);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.capturerObserver.onCapturerStarted(true);
                CameraCapturer.this.sessionOpening = false;
                CameraCapturer.this.currentSession = session;
                CameraCapturer.this.cameraStatistics = new CameraVideoCapturer.CameraStatistics(CameraCapturer.this.surfaceHelper, CameraCapturer.this.eventsHandler);
                CameraCapturer.this.firstFrameObserved = false;
                CameraCapturer.this.stateLock.notifyAll();
                if (CameraCapturer.this.openAttemptsRemaining < 3) {
                    Logging.i(CameraCapturer.TAG, "reopen , try num : " + (3 - CameraCapturer.this.openAttemptsRemaining));
                    if (CameraCapturer.this.eventsHandler != null) {
                        CameraCapturer.this.eventsHandler.onCameraReOpen(3 - CameraCapturer.this.openAttemptsRemaining);
                    }
                }
                if (CameraCapturer.this.switchState == SwitchState.IN_PROGRESS) {
                    CameraCapturer.this.switchState = SwitchState.IDLE;
                    if (CameraCapturer.this.switchEventsHandler != null) {
                        CameraCapturer.this.switchEventsHandler.onCameraSwitchDone(CameraCapturer.this.cameraName);
                        CameraCapturer.this.switchEventsHandler = null;
                    }
                } else if (CameraCapturer.this.switchState == SwitchState.PENDING) {
                    CameraCapturer.this.switchState = SwitchState.IDLE;
                    CameraCapturer.this.switchCameraInternal(CameraCapturer.this.switchEventsHandler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(CameraSession.FailureType failureType, String error, CameraSession.DeviceErrorType deviceErrorType) {
            CameraCapturer.this.checkIsOnCameraThread();
            CameraCapturer.this.uiThreadHandler.removeCallbacks(CameraCapturer.this.openCameraTimeoutRunnable);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.capturerObserver.onCapturerStarted(false);
                CameraCapturer.this.openAttemptsRemaining--;
                Logging.w(CameraCapturer.TAG, "onFailure\uff0copenAttemptsRemaining: " + CameraCapturer.this.openAttemptsRemaining);
                if (CameraCapturer.this.openAttemptsRemaining <= 0) {
                    Logging.w(CameraCapturer.TAG, "Opening camera failed, passing: " + error);
                    CameraCapturer.this.sessionOpening = false;
                    CameraCapturer.this.stateLock.notifyAll();
                    if (CameraCapturer.this.switchState != SwitchState.IDLE) {
                        if (CameraCapturer.this.switchEventsHandler != null) {
                            CameraCapturer.this.switchEventsHandler.onCameraSwitchError(error);
                            CameraCapturer.this.switchEventsHandler = null;
                        }
                        CameraCapturer.this.switchState = SwitchState.IDLE;
                    }
                    if (failureType == CameraSession.FailureType.DISCONNECTED) {
                        CameraCapturer.this.eventsHandler.onCameraDisconnected(true);
                    } else if (CameraCapturer.this.fallbackAttemptsRemaining > 0) {
                        CameraCapturer.this.fallbackAttemptsRemaining--;
                        CameraCapturer.this.fallbackToCamera1(500);
                    } else {
                        CameraCapturer.this.eventsHandler.onCameraError(error, deviceErrorType.getCode(), true);
                    }
                } else {
                    Logging.w(CameraCapturer.TAG, "Opening camera failed, retry: " + error);
                    CameraCapturer.this.createSessionInternal(500);
                }
            }
        }
    };
    @Nullable
    private final CameraSession.Events cameraSessionEventsHandler = new CameraSession.Events(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraOpening() {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.currentSession != null) {
                    Logging.w(CameraCapturer.TAG, "onCameraOpening while session was open.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraOpening(CameraCapturer.this.cameraName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraError(CameraSession session, String error, int deviceErrorType) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (session != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraError from another session: " + error);
                    return;
                }
                CameraCapturer.this.sessionOpening = false;
                CameraCapturer.this.stateLock.notifyAll();
                if (CameraCapturer.this.mShouldReopen.get()) {
                    CameraCapturer.this.stopCapture();
                    CameraCapturer.this.eventsHandler.onCameraError(error, deviceErrorType, true);
                    CameraCapturer.this.mShouldReopen.set(false);
                } else if (!CameraCapturer.this.mIsForeground) {
                    CameraCapturer.this.mShouldReopen.set(true);
                    CameraCapturer.this.stopCapture();
                    CameraCapturer.this.eventsHandler.onCameraError(error, deviceErrorType, false);
                } else {
                    CameraCapturer.this.stopCapture();
                    CameraCapturer.this.eventsHandler.onCameraError(error, deviceErrorType, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraDisconnected(CameraSession session) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (session != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraDisconnected from another session.");
                    return;
                }
                if (CameraCapturer.this.mShouldReopen.get()) {
                    CameraCapturer.this.stopCapture();
                    CameraCapturer.this.eventsHandler.onCameraDisconnected(true);
                    CameraCapturer.this.mShouldReopen.set(false);
                } else {
                    CameraCapturer.this.mShouldReopen.set(true);
                    CameraCapturer.this.eventsHandler.onCameraDisconnected(false);
                    CameraCapturer.this.stopCapture();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraClosed(CameraSession session) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (session != CameraCapturer.this.currentSession && CameraCapturer.this.currentSession != null) {
                    Logging.i(CameraCapturer.TAG, "onCameraClosed from another session.");
                    return;
                }
                if (!CameraCapturer.this.mShouldReopen.get()) {
                    CameraCapturer.this.eventsHandler.onCameraClosed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameCaptured(CameraSession session, VideoFrame frame) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (session != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onFrameCaptured from another session.");
                    return;
                }
                if (!CameraCapturer.this.firstFrameObserved) {
                    CameraCapturer.this.eventsHandler.onFirstFrameAvailable();
                    CameraCapturer.this.firstFrameObserved = true;
                    CameraCapturer.this.mShouldReopen.set(false);
                }
                CameraCapturer.this.cameraStatistics.addFrame();
                CameraCapturer.this.capturerObserver.onFrameCaptured(frame);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraFormatsInquired(String deviceId, String formats, String selectFormat) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.eventsHandler != null) {
                    CameraCapturer.this.eventsHandler.onCameraFormatsInrequired(CameraCapturer.this.cameraName, deviceId, formats, selectFormat);
                }
            }
        }
    };
    private final Runnable openCameraTimeoutRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.sessionOpening = false;
                CameraCapturer.this.stateLock.notifyAll();
                CameraCapturer.this.eventsHandler.onCameraError("Camera failed to start within timeout.", CameraSession.DeviceErrorType.CAMERA_TIMEOUT_ERROR.getCode(), true);
            }
        }
    };
    @Nullable
    private Handler cameraThreadHandler;
    private Context applicationContext;
    private CapturerObserver capturerObserver;
    @Nullable
    private SurfaceTextureHelper surfaceHelper;
    private final Object stateLock = new Object();
    private boolean sessionOpening;
    @Nullable
    private CameraSession currentSession;
    private String cameraName;
    private int width;
    private int height;
    private int framerate;
    private int openAttemptsRemaining;
    private int fallbackAttemptsRemaining = 1;
    private SwitchState switchState = SwitchState.IDLE;
    @Nullable
    private CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    @Nullable
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private boolean firstFrameObserved;
    private ForegroundMonitor.Observer foregroundOb = new ForegroundMonitor.Observer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onForegroundChanged(boolean isForeground) {
            CameraCapturer.this.mIsForeground = isForeground;
            if (!isForeground) {
                Logging.w(CameraCapturer.TAG, "The app go to back, so ignore.");
                return;
            }
            if (CameraCapturer.this.mShouldReopen.get()) {
                Logging.w(CameraCapturer.TAG, "The app goes back to the foreground and tries to reopen the camera");
                Object object = CameraCapturer.this.stateLock;
                synchronized (object) {
                    if (CameraCapturer.this.sessionOpening || CameraCapturer.this.currentSession != null) {
                        Logging.w(CameraCapturer.TAG, "Session already open");
                        return;
                    }
                    CameraCapturer.this.sessionOpening = true;
                    CameraCapturer.this.openAttemptsRemaining = 3;
                    CameraCapturer.this.createSessionInternal(0);
                }
            }
        }
    };

    public CameraCapturer(String cameraName, @Nullable CameraVideoCapturer.CameraEventsHandler eventsHandler, CameraEnumerator cameraEnumerator, String rotationCompatConfig) {
        if (eventsHandler == null) {
            eventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

                @Override
                public void onCameraError(String errorDescription, int deviceErrorType, boolean callback) {
                }

                @Override
                public void onCameraDisconnected(boolean callback) {
                }

                @Override
                public void onCameraFreezed(String errorDescription) {
                }

                @Override
                public void onCameraOpening(String cameraName) {
                }

                @Override
                public void onFirstFrameAvailable() {
                }

                @Override
                public void onCameraClosed() {
                }

                @Override
                public void onCameraReOpen(int tryNum) {
                }

                @Override
                public void onCameraFormatsInrequired(String deviceName, String deviceId, String formats, String selectFormat) {
                }
            };
        }
        this.eventsHandler = eventsHandler;
        this.cameraEnumerator = cameraEnumerator;
        this.cameraName = cameraName;
        this.mIsForeground = false;
        this.mShouldReopen = new AtomicBoolean(false);
        this.rotationCompatConfig = rotationCompatConfig;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        String[] deviceNames = cameraEnumerator.getDeviceNames();
        if (deviceNames.length == 0) {
            throw new RuntimeException("No cameras attached.");
        }
        if (!Arrays.asList(deviceNames).contains(this.cameraName)) {
            throw new IllegalArgumentException("Camera name " + this.cameraName + " does not match any known camera device.");
        }
    }

    @Override
    public void initialize(@Nullable SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        this.applicationContext = applicationContext;
        this.capturerObserver = capturerObserver;
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(int width, int height, int framerate) {
        Logging.i(TAG, "startCapture: " + width + "x" + height + "@" + framerate);
        if (this.applicationContext == null) {
            throw new RuntimeException("CameraCapturer must be initialized before calling startCapture.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.sessionOpening || this.currentSession != null) {
                Logging.w(TAG, "Session already open");
                return;
            }
            this.width = width;
            this.height = height;
            this.framerate = framerate;
            this.sessionOpening = true;
            this.openAttemptsRemaining = 3;
            this.createSessionInternal(0);
            ForegroundMonitor.getInstance().addObserver(this.foregroundOb);
        }
    }

    private void fallbackToCamera1(int delayMs) {
        boolean result = this.cameraThreadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Logging.w(CameraCapturer.TAG, "fallback To Camera1, cameraID:" + CameraCapturer.this.cameraId);
                Camera1Session.create(CameraCapturer.this.createSessionCallback, CameraCapturer.this.cameraSessionEventsHandler, CameraCapturer.this.captureToTexture, CameraCapturer.this.applicationContext, CameraCapturer.this.surfaceHelper, CameraCapturer.this.cameraId, CameraCapturer.this.width, CameraCapturer.this.height, CameraCapturer.this.framerate, CameraCapturer.this.cameraHQ, CameraCapturer.this.cameraFpsUp, CameraCapturer.this.cameraStabilizationMode, CameraCapturer.this.rotationCompatConfig);
            }
        }, (long)delayMs);
        if (result) {
            this.uiThreadHandler.postDelayed(this.openCameraTimeoutRunnable, (long)(delayMs + 5000));
        }
    }

    private void createSessionInternal(int delayMs) {
        if (this.cameraThreadHandler == null) {
            Logging.e(TAG, "createSessionInternal failed , handler is null");
            this.sessionOpening = false;
            this.stateLock.notifyAll();
            return;
        }
        boolean result = this.cameraThreadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CameraCapturer.this.createCameraSession(CameraCapturer.this.createSessionCallback, CameraCapturer.this.cameraSessionEventsHandler, CameraCapturer.this.applicationContext, CameraCapturer.this.surfaceHelper, CameraCapturer.this.cameraName, CameraCapturer.this.width, CameraCapturer.this.height, CameraCapturer.this.framerate, CameraCapturer.this.rotationCompatConfig);
            }
        }, (long)delayMs);
        if (result) {
            this.uiThreadHandler.postDelayed(this.openCameraTimeoutRunnable, (long)(delayMs + 5000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        Logging.i(TAG, "Stop capture");
        Object object = this.stateLock;
        synchronized (object) {
            while (this.sessionOpening) {
                Logging.i(TAG, "Stop capture: Waiting for session to open");
                try {
                    this.stateLock.wait(3000L);
                }
                catch (InterruptedException e) {
                    Logging.w(TAG, "Stop capture interrupted while waiting for the session to open.");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.currentSession != null) {
                Logging.i(TAG, "Stop capture: Nulling session");
                final CameraSession oldSession = this.currentSession;
                this.cameraThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        oldSession.stop();
                    }
                });
                this.currentSession = null;
                this.capturerObserver.onCapturerStopped();
            } else {
                Logging.i(TAG, "Stop capture: No session open");
            }
            if (this.cameraStatistics != null) {
                this.cameraStatistics.release();
                this.cameraStatistics = null;
            }
        }
        Logging.i(TAG, "Stop capture done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCaptureFormat(int width, int height, int framerate) {
        Logging.i(TAG, "changeCaptureFormat: " + width + "x" + height + "@" + framerate);
        Object object = this.stateLock;
        synchronized (object) {
            this.stopCapture();
            this.startCapture(width, height, framerate);
        }
    }

    @Override
    public void dispose() {
        Logging.i(TAG, "dispose");
        ForegroundMonitor.getInstance().removeObserver(this.foregroundOb);
        this.stopCapture();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCameraZoomSupported() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                return this.currentSession.isCameraZoomSupported();
            }
        }
        Logging.w(TAG, "isCameraZoomSupported return false camera is not started");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZoom(int zoomValue) {
        Logging.i(TAG, "setZoom " + zoomValue);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                this.currentSession.setZoom(zoomValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentZoom() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                return this.currentSession.getCurrentZoom();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxZoom() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                return this.currentSession.getMaxZoom();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCameraTorchSupported() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                return this.currentSession.isCameraTorchSupported();
            }
        }
        Logging.w(TAG, "isCameraTorchSupported return false camera is not started");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFlash(boolean flash) {
        Logging.i(TAG, "setFlash " + flash);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                return this.currentSession.setFlash(flash);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCameraExposurePositionSupported() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                return this.currentSession.isCameraExposurePositionSupported();
            }
        }
        Logging.w(TAG, "isCameraExposurePositionSupported return false camera is not started");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMeteringAreas(float x, float y) {
        Logging.i(TAG, "setMeteringAreas {" + x + "," + y + "}");
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                this.currentSession.setMeteringAreas(x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCameraFocusSupported() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                return this.currentSession.isCameraFocusSupported();
            }
        }
        Logging.w(TAG, "isCameraFocusSupported return false camera is not started");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusAreas(float x, float y) {
        Logging.i(TAG, "setFocusAreas {" + x + "," + y + "}");
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                this.currentSession.setFocusAreas(x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusAndMeteringCallback(CameraVideoCapturer.AreaFocusCallback callback) {
        Logging.i(TAG, "setFocusAndMeteringCallback " + callback);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isCameraReady()) {
                this.currentSession.setFocusAndMeteringCallback(callback);
            }
        }
    }

    private boolean isCameraReady() {
        if (this.sessionOpening || this.currentSession == null) {
            Logging.w(TAG, "Session is not ready");
            return false;
        }
        return true;
    }

    public void printStackTrace() {
        StackTraceElement[] cameraStackTrace;
        Thread cameraThread = null;
        if (this.cameraThreadHandler != null) {
            cameraThread = this.cameraThreadHandler.getLooper().getThread();
        }
        if (cameraThread != null && (cameraStackTrace = cameraThread.getStackTrace()).length > 0) {
            Logging.i(TAG, "CameraCapturer stack trace:");
            for (StackTraceElement traceElem : cameraStackTrace) {
                Logging.i(TAG, traceElem.toString());
            }
        }
    }

    private void reportCameraSwitchError(String error, @Nullable CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        Logging.e(TAG, error);
        if (switchEventsHandler != null) {
            switchEventsHandler.onCameraSwitchError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraInternal(@Nullable CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        Logging.i(TAG, "switchCamera internal");
        String[] deviceNames = this.cameraEnumerator.getDeviceNames();
        if (deviceNames.length < 2) {
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.switchState != SwitchState.IDLE) {
                this.reportCameraSwitchError("Camera switch already in progress.", switchEventsHandler);
                return;
            }
            if (!this.sessionOpening && this.currentSession == null) {
                this.reportCameraSwitchError("switchCamera: camera is not running.", switchEventsHandler);
                return;
            }
            this.switchEventsHandler = switchEventsHandler;
            if (this.sessionOpening) {
                this.switchState = SwitchState.PENDING;
                return;
            }
            this.switchState = SwitchState.IN_PROGRESS;
            Logging.i(TAG, "switchCamera: Stopping session");
            this.cameraStatistics.release();
            this.cameraStatistics = null;
            final CameraSession oldSession = this.currentSession;
            this.cameraThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    oldSession.stop();
                }
            });
            this.currentSession = null;
            int cameraNameIndex = Arrays.asList(deviceNames).indexOf(this.cameraName);
            this.cameraName = deviceNames[(cameraNameIndex + 1) % deviceNames.length];
            this.sessionOpening = true;
            this.openAttemptsRemaining = 1;
            this.createSessionInternal(0);
        }
        Logging.i(TAG, "switchCamera done");
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            Logging.e(TAG, "Check is on camera thread failed.");
            throw new RuntimeException("Not on camera thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCameraName() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.cameraName;
        }
    }

    protected abstract void createCameraSession(CameraSession.CreateSessionCallback var1, CameraSession.Events var2, Context var3, SurfaceTextureHelper var4, String var5, int var6, int var7, int var8, String var9);

    static enum SwitchState {
        IDLE,
        PENDING,
        IN_PROGRESS;

    }
}

