/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture.core;

import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.Size;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraFrameRateRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraEnumerationUtil {
    private static final String TAG = "CameraEnumerationAndroid";
    public static final ArrayList<Size> COMMON_RESOLUTIONS = new ArrayList<Size>(Arrays.asList(new Size(160, 120), new Size(240, 160), new Size(320, 240), new Size(400, 240), new Size(480, 320), new Size(640, 360), new Size(640, 480), new Size(768, 480), new Size(854, 480), new Size(800, 600), new Size(960, 540), new Size(960, 640), new Size(1024, 576), new Size(1024, 600), new Size(1280, 720), new Size(1280, 1024), new Size(1920, 1080), new Size(1920, 1440), new Size(2560, 1440), new Size(3840, 2160)));

    public static CameraFrameRateRange getClosestSupportedFramerateRangeWebRTC(List<CameraFrameRateRange> supportedFramerates, final int requestedFps) {
        return Collections.min(supportedFramerates, new ClosestComparator<CameraFrameRateRange>(){
            private static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            private static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            private static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            private static final int MIN_FPS_THRESHOLD = 8000;
            private static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            private static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;

            private int progressivePenalty(int value, int threshold, int lowWeight, int highWeight) {
                return value < threshold ? value * lowWeight : threshold * lowWeight + (value - threshold) * highWeight;
            }

            @Override
            int diff(CameraFrameRateRange range) {
                int minFpsError = this.progressivePenalty(range.min, 8000, 1, 4);
                int maxFpsError = this.progressivePenalty(Math.abs(requestedFps * 1000 - range.max), 5000, 1, 3);
                return minFpsError + maxFpsError;
            }
        });
    }

    public static CameraFrameRateRange getClosestSupportedFramerateRangeG1(List<CameraFrameRateRange> supportedFramerates, int requestedFps, boolean keepRequestedFps) {
        Logging.i(TAG, "requestedFps:" + requestedFps);
        Logging.i(TAG, "keepRequestedFps:" + keepRequestedFps);
        int less = (requestedFps *= 1000) * 100;
        CameraFrameRateRange minFramerateRange = null;
        for (CameraFrameRateRange framerateRange : supportedFramerates) {
            int curless;
            int tmp = Math.abs(requestedFps - framerateRange.min);
            int tmp2 = Math.abs(requestedFps - framerateRange.max);
            if (keepRequestedFps && requestedFps <= framerateRange.max) {
                tmp2 -= 100000;
            }
            if ((curless = tmp + tmp2) >= less) continue;
            minFramerateRange = framerateRange;
            less = curless;
        }
        Logging.i(TAG, "minFramerateRange.min:" + minFramerateRange.min);
        Logging.i(TAG, "minFramerateRange.max:" + minFramerateRange.max);
        return minFramerateRange;
    }

    public static CameraFrameRateRange getClosestSupportedFramerateRange(List<CameraFrameRateRange> framerateRangeList, int requestedFps, boolean fpsPreferUpBound, boolean keepRequestedFps) {
        CameraFrameRateRange framerateRange = fpsPreferUpBound ? CameraEnumerationUtil.getClosestSupportedFramerateRangeWebRTC(framerateRangeList, requestedFps) : CameraEnumerationUtil.getClosestSupportedFramerateRangeG1(framerateRangeList, requestedFps, keepRequestedFps);
        return framerateRange;
    }

    public static Size getClosestSupportedSize(List<Size> supportedSizes, final int requestedWidth, final int requestedHeight) {
        return Collections.min(supportedSizes, new ClosestComparator<Size>(){

            @Override
            int diff(Size size) {
                return Math.abs(requestedWidth - size.width) + Math.abs(requestedHeight - size.height);
            }
        });
    }

    private static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        @Override
        public int compare(T t1, T t2) {
            return this.diff(t1) - this.diff(t2);
        }
    }
}

