/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.cameracapture.core;

import android.content.Context;
import android.graphics.Matrix;
import android.text.TextUtils;
import android.view.WindowManager;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.TextureBufferImpl;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.yunxin.lite.video.device.cameracapture.core.CameraVideoCapturer;
import org.json.JSONObject;

public interface CameraSession {
    public static final boolean dualFrame = false;
    public static final boolean enableFD = false;

    public void stop();

    public boolean isCameraZoomSupported();

    public void setZoom(int var1);

    public int getCurrentZoom();

    public int getMaxZoom();

    public boolean isCameraTorchSupported();

    public int setFlash(boolean var1);

    public boolean isCameraExposurePositionSupported();

    public void setMeteringAreas(float var1, float var2);

    public boolean isCameraFocusSupported();

    public boolean isCameraFaceDetectModeSupported();

    public void setFocusAreas(float var1, float var2);

    public void setFocusAndMeteringCallback(CameraVideoCapturer.AreaFocusCallback var1);

    public static int getDeviceOrientation(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static VideoFrame.TextureBuffer createTextureBufferWithModifiedTransformMatrix(TextureBufferImpl buffer, boolean mirror, int rotation) {
        Matrix transformMatrix = new Matrix();
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (mirror) {
            transformMatrix.preScale(-1.0f, 1.0f);
        }
        transformMatrix.preRotate((float)rotation);
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return buffer.applyTransformMatrix(transformMatrix, buffer.getWidth(), buffer.getHeight());
    }

    public static String getExceptionDescription(Exception e) {
        if (e == null) {
            return "";
        }
        return "{ class : " + e.getClass().toString() + ", messge : " + e.getMessage() + " }";
    }

    public static OrientationCompatConfig parseRotationCompatConfig(String rotationCompatConfig, int cameraType) {
        OrientationCompatConfig config = new OrientationCompatConfig();
        String frontFixedKey = "front_fixed_" + cameraType;
        String backFixedKey = "back_fixed_" + cameraType;
        String frontExtraKey = "front_extra_" + cameraType;
        String backExtraKey = "back_extra_" + cameraType;
        if (!TextUtils.isEmpty((CharSequence)rotationCompatConfig)) {
            try {
                JSONObject object = new JSONObject(rotationCompatConfig);
                config.frontFixed = object.optInt(frontFixedKey, -1);
                config.backFixed = object.optInt(backFixedKey, -1);
                if (config.frontFixed % 90 != 0) {
                    config.frontFixed = -1;
                }
                if (config.backFixed % 90 != 0) {
                    config.backFixed = -1;
                }
                config.frontExtra = object.optInt(frontExtraKey, 0);
                config.backExtra = object.optInt(backExtraKey, 0);
                if (config.frontExtra % 90 != 0) {
                    config.frontExtra = 0;
                }
                if (config.backExtra % 90 != 0) {
                    config.backExtra = 0;
                }
                Logging.i("CameraSession", "cameraType: " + cameraType + " ,  " + config);
            }
            catch (Exception e) {
                Logging.e("CameraSession", "parseRotationConfig error: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return config;
    }

    public static interface Events {
        public void onCameraOpening();

        public void onCameraError(CameraSession var1, String var2, int var3);

        public void onCameraDisconnected(CameraSession var1);

        public void onCameraClosed(CameraSession var1);

        public void onFrameCaptured(CameraSession var1, VideoFrame var2);

        public void onCameraFormatsInquired(String var1, String var2, String var3);
    }

    public static interface CreateSessionCallback {
        public void onOpening(CameraSession var1);

        public void onDone(CameraSession var1);

        public void onFailure(FailureType var1, String var2, DeviceErrorType var3);
    }

    public static class OrientationCompatConfig {
        public int frontFixed = -1;
        public int backFixed = -1;
        public int frontExtra = 0;
        public int backExtra = 0;

        public String toString() {
            return "OrientationCompatConfig{frontFixed=" + this.frontFixed + ", backFixed=" + this.backFixed + ", frontExtra=" + this.frontExtra + ", backExtra=" + this.backExtra + '}';
        }
    }

    public static enum DeviceErrorType {
        CAMERA1_SERVER_DIED_ERROR(100),
        CAMERA_UNKNOWN_ERROR(101),
        CAMERA1_INIT_ERROR(102),
        CAMERA1_NULL_ERROR(103),
        CAMERA1_SURFACE_ERROR(104),
        CAMERA1_UPDATE_PARAM_ERROR(105),
        CAMERA_TIMEOUT_ERROR(106),
        CAMERA1_SET_DISPLAY_ORIENTATION_ERROR(107),
        CAMERA2_INIT_ERROR(120),
        CAMERA2_CREATE_SESSION_ERROR(121),
        CAMERA2_CONFIGURE_SESSION_ERROR(122),
        CAMERA2_START_CAP_ERROR(123),
        CAMERA2_GET_CHA_ERROR(124);

        private int code;

        private DeviceErrorType(int codenum) {
            this.code = codenum;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static interface FlashStats {
        public static final int SUCCESS = 0;
        public static final int FAILURE = 1;
        public static final int NOTSUPPORT = 2;
    }

    public static enum FailureType {
        ERROR,
        DISCONNECTED;

    }
}

