/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.device.screencapture;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.WindowManager;
import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.JniCommon;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.Size;
import com.netease.lava.webrtc.SurfaceTextureHelper;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.VideoSink;
import com.netease.lava.webrtc.YuvHelper;
import com.netease.lava.webrtc.device.HardwareLevel;
import com.netease.yunxin.lite.util.ThreadUtils;
import com.netease.yunxin.lite.util.VideoUtils;
import com.netease.yunxin.lite.video.device.cameracapture.core.CapturerObserver;
import com.netease.yunxin.lite.video.device.cameracapture.core.VideoCapturer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

@TargetApi(value=21)
public class ScreenCapturerAndroid
implements VideoCapturer,
VideoSink {
    private static final String TAG = "ScreenCapturerAndroid";
    private static final int DISPLAY_FLAGS = 3;
    private final MediaProjection.Callback mediaProjectionCallback;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private Context applicationContext;
    @Nullable
    private CapturerObserver capturerObserver;
    @Nullable
    VirtualDisplay virtualDisplay;
    @Nullable
    private MediaProjection mediaProjection;
    VirtualDisplay.Callback virtualDisplayCallback = new VirtualDisplay.Callback(){

        public void onPaused() {
            Logging.i(ScreenCapturerAndroid.TAG, "VirtualDisplay onPaused!");
        }

        public void onResumed() {
            Logging.i(ScreenCapturerAndroid.TAG, "VirtualDisplay onResumed!");
        }

        public void onStopped() {
            Logging.i(ScreenCapturerAndroid.TAG, "VirtualDisplay onStopped!");
        }
    };
    private int orientationFramesCount;
    private int width;
    private int height;
    private int cacheWidth;
    private int cacheHeight;
    private int screenWidth;
    private int screenHeight;
    private int densityDpi;
    private final Object orientationLock = new Object();
    private int tmpOrientation;
    private long numCapturedFrames;
    private boolean isDisposed = false;
    OrientationEventListener mOrientationListener;
    private int ignoredFPS;
    private KeepAliveStatistics statistics = new KeepAliveStatistics();
    private ByteBuffer mCacheBuffer;
    private int cacheRotation;
    private long cacheTimeStamp;
    private static final Object mCacheSync = new Object();
    private volatile boolean mStarted = false;
    private volatile boolean isScreenCaptureFreezed = false;
    private static final int SCREEN_KEEP_ALIVE_PERIOD_MS = 500;
    private static final int SCREEN_SEND_CACHE_FRAME_MS = 2000;
    private static final int SCREEN_SEND_CACHE_FRAM_THRESHOLD = 2;
    private static final int ORIENTATION_FRAMES_COUNT_THRESHOLD = 3;
    private static final int SCREEN_CACHE_FRAME_COUNT = 5;
    protected static final long NANOS_PER_MS = 1000000L;
    public static ScreenCapturerIntentCallback intentCallback;
    private final Runnable fpsMonitor = new Runnable(){
        private int freezePeriodCount;
        private int deliverCachedBufferCount = 0;

        @Override
        public void run() {
            int cameraFramesCount = ScreenCapturerAndroid.this.statistics.getAndResetFrameCount();
            if (cameraFramesCount == 0) {
                ++this.freezePeriodCount;
                if (500 * this.freezePeriodCount > 2000) {
                    if (ScreenCapturerAndroid.this.mStarted && HardwareLevel.level() > 1) {
                        Logging.i(ScreenCapturerAndroid.TAG, "Screen Capture freeze ,sending Cached frame. width: " + ScreenCapturerAndroid.this.width + " height: " + ScreenCapturerAndroid.this.height + " orientationFramesCount: " + ScreenCapturerAndroid.this.orientationFramesCount + " deliverCachedBufferCount: " + this.deliverCachedBufferCount);
                        ScreenCapturerAndroid.this.deliverCachedBuffer(500 * this.freezePeriodCount);
                    }
                    ++this.deliverCachedBufferCount;
                    if (ScreenCapturerAndroid.this.mStarted && this.deliverCachedBufferCount > 2 && ScreenCapturerAndroid.this.orientationFramesCount < 3) {
                        this.deliverCachedBufferCount = 0;
                        ScreenCapturerAndroid.this.isScreenCaptureFreezed = true;
                        Logging.w(ScreenCapturerAndroid.TAG, "Screen Capture freeze . Try to recreate!");
                        ScreenCapturerAndroid.this.changeCaptureFormat(ScreenCapturerAndroid.this.width, ScreenCapturerAndroid.this.height, ScreenCapturerAndroid.this.ignoredFPS);
                        ScreenCapturerAndroid.this.isScreenCaptureFreezed = false;
                    }
                }
            } else {
                this.deliverCachedBufferCount = 0;
                this.freezePeriodCount = 0;
            }
            ThreadUtils.runOnUiThreadDelay(this, 500L);
        }
    };

    public static void setIntentCallback(ScreenCapturerIntentCallback callback) {
        intentCallback = callback;
    }

    public ScreenCapturerAndroid(Intent mediaProjectionPermissionResultData, MediaProjection.Callback mediaProjectionCallback) {
        this.mediaProjectionCallback = mediaProjectionCallback;
    }

    @Override
    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        this.checkNotDisposed();
        if (capturerObserver == null) {
            throw new RuntimeException("capturerObserver not set.");
        }
        this.capturerObserver = capturerObserver;
        if (surfaceTextureHelper == null) {
            throw new RuntimeException("surfaceTextureHelper not set.");
        }
        this.surfaceTextureHelper = surfaceTextureHelper;
        if (applicationContext == null) {
            throw new RuntimeException("applicationContext not set.");
        }
        this.applicationContext = applicationContext;
    }

    @Override
    public synchronized void startCapture(int width, int height, int ignoredFramerate) {
        Logging.i(TAG, "startCapture");
        this.checkNotDisposed();
        this.ignoredFPS = ignoredFramerate;
        DisplayMetrics displayMetrics = this.getDisplayMetrics();
        this.bestScreenCaptureConfig(displayMetrics, width, height);
        this.surfaceTextureHelper.startListening(this);
        ThreadUtils.runOnUiThreadDelay(this.fpsMonitor, 500L);
        try {
            this.mediaProjection = intentCallback.onScreenCapturerNeedIntent();
            if (this.mediaProjection == null) {
                return;
            }
            this.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
            this.createVirtualDisplay();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.orientationFramesCount = 0;
        this.capturerObserver.onCapturerStarted(true);
        this.listenOrientationChange();
        this.mStarted = true;
        this.isScreenCaptureFreezed = false;
    }

    @Override
    public synchronized void stopCapture() {
        Logging.i(TAG, "stopCapture");
        this.checkNotDisposed();
        this.mStarted = false;
        ThreadUtils.getUiThreadHandler().removeCallbacks(this.fpsMonitor);
        com.netease.lava.webrtc.ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                if (ScreenCapturerAndroid.this.surfaceTextureHelper != null) {
                    ScreenCapturerAndroid.this.surfaceTextureHelper.stopListening();
                    ScreenCapturerAndroid.this.surfaceTextureHelper = null;
                }
                if (ScreenCapturerAndroid.this.capturerObserver != null) {
                    ScreenCapturerAndroid.this.capturerObserver.onCapturerStopped();
                    ScreenCapturerAndroid.this.capturerObserver = null;
                }
                try {
                    if (ScreenCapturerAndroid.this.virtualDisplay != null) {
                        ScreenCapturerAndroid.this.virtualDisplay.release();
                        ScreenCapturerAndroid.this.virtualDisplay = null;
                    }
                    if (ScreenCapturerAndroid.this.mediaProjection != null) {
                        intentCallback.stopScreenCapture();
                        ScreenCapturerAndroid.this.mediaProjection.unregisterCallback(ScreenCapturerAndroid.this.mediaProjectionCallback);
                        ScreenCapturerAndroid.this.mediaProjection = null;
                    }
                    if (ScreenCapturerAndroid.this.mOrientationListener != null) {
                        ScreenCapturerAndroid.this.mOrientationListener.disable();
                        ScreenCapturerAndroid.this.mOrientationListener = null;
                    }
                    if (ScreenCapturerAndroid.this.mCacheBuffer != null) {
                        JniCommon.nativeFreeByteBuffer(ScreenCapturerAndroid.this.mCacheBuffer);
                        ScreenCapturerAndroid.this.mCacheBuffer = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
    }

    @Override
    public synchronized void changeCaptureFormat(int width, int height, int ignoredFramerate) {
        this.checkNotDisposed();
        this.ignoredFPS = ignoredFramerate;
        DisplayMetrics displayMetrics = this.getDisplayMetrics();
        this.bestScreenCaptureConfig(displayMetrics, width, height);
        com.netease.lava.webrtc.ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                try {
                    if (Build.VERSION.SDK_INT >= 34 && !ScreenCapturerAndroid.this.isScreenCaptureFreezed) {
                        ScreenCapturerAndroid.this.resizeVirtualDisplay();
                    } else {
                        ScreenCapturerAndroid.this.virtualDisplay.release();
                        ScreenCapturerAndroid.this.createVirtualDisplay();
                    }
                }
                catch (RuntimeException e) {
                    Logging.e(ScreenCapturerAndroid.TAG, "Exception happened on virtualDisplay!");
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        if (!this.mStarted) {
            return;
        }
        Object object = this.orientationLock;
        synchronized (object) {
            int tmpWidth = frame.getBuffer().getWidth();
            int tmpHeight = frame.getBuffer().getHeight();
            if (this.tmpOrientation == 1 && tmpWidth > tmpHeight) {
                Logging.w(TAG, " orientation: " + this.tmpOrientation + " width: " + tmpWidth + " height: " + tmpHeight);
                return;
            }
            if (this.tmpOrientation == 2 && tmpWidth < tmpHeight) {
                Logging.w(TAG, " orientation: " + this.tmpOrientation + " width: " + tmpWidth + " height: " + tmpHeight);
                return;
            }
            if (this.orientationFramesCount <= 3) {
                ++this.orientationFramesCount;
            }
        }
        ++this.numCapturedFrames;
        this.statistics.addFrame();
        if (this.numCapturedFrames % 5L == 0L && HardwareLevel.level() > 1) {
            this.cacheFrameBuffer(frame);
        }
        this.capturerObserver.onFrameCaptured(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFrameBuffer(VideoFrame frame) {
        if (frame == null) {
            Logging.e(TAG, "input frame is null!");
            return;
        }
        Object object = mCacheSync;
        synchronized (object) {
            int length = frame.getBuffer().getWidth() * frame.getBuffer().getHeight() * 3 / 2;
            if (this.mCacheBuffer != null && this.mCacheBuffer.capacity() < length) {
                Logging.i(TAG, "Reallocate byteBuffer from " + this.mCacheBuffer.capacity() + " to " + length);
                JniCommon.nativeFreeByteBuffer(this.mCacheBuffer);
                this.mCacheBuffer = JniCommon.nativeAllocateByteBuffer(length);
            } else if (this.mCacheBuffer == null) {
                Logging.i(TAG, "allocate byteBuffer: " + length);
                this.mCacheBuffer = JniCommon.nativeAllocateByteBuffer(length);
            }
            this.cacheRotation = frame.getRotation();
            this.cacheTimeStamp = frame.getTimestampNs();
            this.cacheWidth = frame.getBuffer().getWidth();
            this.cacheHeight = frame.getBuffer().getHeight();
            VideoFrame.I420Buffer i420Buffer = frame.getBuffer().toI420();
            this.mCacheBuffer.clear();
            YuvHelper.I420Copy(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), this.mCacheBuffer, frame.getBuffer().getWidth(), frame.getBuffer().getHeight());
            i420Buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverCachedBuffer(long timeStamp) {
        if (this.mCacheBuffer == null) {
            Logging.e(TAG, "Cached buffer is null!");
            return;
        }
        Object object = mCacheSync;
        synchronized (object) {
            int chromaHeight = (this.cacheHeight + 1) / 2;
            int strideUV = (this.cacheWidth + 1) / 2;
            int yPos = 0;
            int uPos = yPos + this.cacheWidth * this.cacheHeight;
            int vPos = uPos + strideUV * chromaHeight;
            this.mCacheBuffer.position(yPos);
            this.mCacheBuffer.limit(uPos);
            ByteBuffer dataY = this.mCacheBuffer.slice();
            this.mCacheBuffer.position(uPos);
            this.mCacheBuffer.limit(vPos);
            ByteBuffer dataU = this.mCacheBuffer.slice();
            this.mCacheBuffer.position(vPos);
            this.mCacheBuffer.limit(vPos + strideUV * chromaHeight);
            ByteBuffer dataV = this.mCacheBuffer.slice();
            JavaI420Buffer buffer = JavaI420Buffer.wrap(this.cacheWidth, this.cacheHeight, dataY, this.cacheWidth, dataU, strideUV, dataV, strideUV, () -> Logging.d(TAG, "trying to release cached screen buffer,cached buffer should be release when stopCapture!"));
            this.cacheTimeStamp += timeStamp * 1000000L;
            VideoFrame videoFrame = new VideoFrame(buffer, this.cacheRotation, this.cacheTimeStamp);
            this.capturerObserver.onFrameCaptured(videoFrame);
        }
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }

    private void createVirtualDisplay() {
        this.surfaceTextureHelper.setTextureSize(this.width, this.height);
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("NERTC_ScreenCapture", this.width, this.height, this.densityDpi, 3, new Surface(this.surfaceTextureHelper.getSurfaceTexture()), this.virtualDisplayCallback, this.surfaceTextureHelper.getHandler());
    }

    private void resizeVirtualDisplay() {
        if (this.virtualDisplay == null || this.surfaceTextureHelper == null) {
            return;
        }
        this.surfaceTextureHelper.setTextureSize(this.width, this.height);
        this.virtualDisplay.resize(this.width, this.height, this.densityDpi);
        this.virtualDisplay.setSurface(new Surface(this.surfaceTextureHelper.getSurfaceTexture()));
    }

    private DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.applicationContext.getSystemService("window");
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        return displayMetrics;
    }

    private void checkNotDisposed() {
        if (this.isDisposed) {
            throw new RuntimeException("capturer is disposed.");
        }
    }

    private void bestScreenCaptureConfig(DisplayMetrics displayMetrics, int requestW, int requestH) {
        if (displayMetrics == null) {
            return;
        }
        this.screenWidth = displayMetrics.widthPixels;
        this.screenHeight = displayMetrics.heightPixels;
        this.densityDpi = displayMetrics.densityDpi;
        Size bestSize = VideoUtils.scaleSizeWithAlignment(this.screenWidth, this.screenHeight, requestW, requestH);
        this.width = bestSize.width;
        this.height = bestSize.height;
        Logging.i(TAG, " best screen Capture config  W: " + this.width + " H: " + this.height + " Screen: dpi " + this.densityDpi + " W: " + this.screenWidth + " H: " + this.screenHeight + " requestW: " + requestW + " requestH: " + requestH);
    }

    private void listenOrientationChange() {
        com.netease.lava.webrtc.ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                ScreenCapturerAndroid.this.mOrientationListener = new OrientationEventListener(ScreenCapturerAndroid.this.applicationContext, 3){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onOrientationChanged(int rotation) {
                        int orientation = ((ScreenCapturerAndroid)ScreenCapturerAndroid.this).applicationContext.getResources().getConfiguration().orientation;
                        Object object = ScreenCapturerAndroid.this.orientationLock;
                        synchronized (object) {
                            if (ScreenCapturerAndroid.this.tmpOrientation == orientation) {
                                return;
                            }
                            ScreenCapturerAndroid.this.tmpOrientation = orientation;
                            ScreenCapturerAndroid.this.orientationFramesCount = 0;
                        }
                        switch (orientation) {
                            case 1: {
                                if (ScreenCapturerAndroid.this.width <= ScreenCapturerAndroid.this.height) break;
                                ScreenCapturerAndroid.this.changeCaptureFormat(ScreenCapturerAndroid.this.width, ScreenCapturerAndroid.this.height, ScreenCapturerAndroid.this.ignoredFPS);
                                break;
                            }
                            case 2: {
                                if (ScreenCapturerAndroid.this.width >= ScreenCapturerAndroid.this.height) break;
                                ScreenCapturerAndroid.this.changeCaptureFormat(ScreenCapturerAndroid.this.width, ScreenCapturerAndroid.this.height, ScreenCapturerAndroid.this.ignoredFPS);
                                break;
                            }
                            default: {
                                Logging.w(ScreenCapturerAndroid.TAG, " orientation " + orientation);
                            }
                        }
                    }
                };
                ScreenCapturerAndroid.this.mOrientationListener.enable();
            }
        });
    }

    private static class KeepAliveStatistics {
        private int frameCount = 0;

        private KeepAliveStatistics() {
        }

        void addFrame() {
            ++this.frameCount;
        }

        int getAndResetFrameCount() {
            int count = this.frameCount;
            this.frameCount = 0;
            return count;
        }
    }

    public static interface ScreenCapturerIntentCallback {
        public MediaProjection onScreenCapturerNeedIntent();

        public void stopScreenCapture();
    }
}

