/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.render;

import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.RendererCommon;
import com.netease.yunxin.lite.annotation.Keep;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
class LiteRendererEvents
implements RendererCommon.RendererEvents {
    private final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();
    private long mNativeHandler;

    @CalledByNative
    private LiteRendererEvents(long nativeHandler) {
        this.mNativeHandler = nativeHandler;
    }

    @CalledByNative
    private void release() {
        this.mLock.writeLock().lock();
        this.mNativeHandler = 0L;
        this.mLock.writeLock().unlock();
    }

    @Override
    public void onFirstFrameRendered() {
        this.mLock.readLock().lock();
        this.onFirstFrameRendered(this.mNativeHandler);
        this.mLock.readLock().unlock();
    }

    @Override
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        this.mLock.readLock().lock();
        this.onFrameResolutionChanged(this.mNativeHandler, videoWidth, videoHeight, rotation);
        this.mLock.readLock().unlock();
    }

    @Override
    public void onReceivedFps(int fps) {
        this.mLock.readLock().lock();
        this.onReceivedFps(this.mNativeHandler, fps);
        this.mLock.readLock().unlock();
    }

    @Override
    public void onRendererFps(int fps) {
        this.mLock.readLock().lock();
        this.onRendererFps(this.mNativeHandler, fps);
        this.mLock.readLock().unlock();
    }

    @Override
    public void onRenderError(String msg) {
        this.mLock.readLock().lock();
        this.onRenderError(this.mNativeHandler, msg);
        this.mLock.readLock().unlock();
    }

    private native void onFirstFrameRendered(long var1);

    private native void onFrameResolutionChanged(long var1, int var3, int var4, int var5);

    private native void onReceivedFps(long var1, int var3);

    private native void onRendererFps(long var1, int var3);

    private native void onRenderError(long var1, String var3);
}

