/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.render;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.netease.lava.api.IVideoRender;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.RendererCommon;
import com.netease.lava.webrtc.SurfaceViewRenderer;
import com.netease.yunxin.lite.util.ThreadUtils;
import com.netease.yunxin.lite.video.VideoViewActionListener;
import com.netease.yunxin.lite.video.watermark.LiteCanvasWatermarkConfig;
import com.netease.yunxin.lite.video.watermark.LiteImageWatermarkConfig;
import com.netease.yunxin.lite.video.watermark.LiteTextWatermarkConfig;
import com.netease.yunxin.lite.video.watermark.LiteTimestampWatermarkConfig;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class LiteSurfaceView
extends SurfaceViewRenderer
implements IVideoRender {
    private static final String TAG = "LiteSurfaceView";
    private static final Handler sMainThreadHandler = new Handler(Looper.getMainLooper());
    private int mInitializedCount = 0;
    private ViewGroup mParent = (ViewGroup)this.getParent();
    private LiteCanvasWatermarkConfig mWatermarkConfig;
    private TextView mTimeStampView;
    private Runnable mTimeStampRunnable;
    private ArrayList<TextView> mTextViewArray;
    private ArrayList<Runnable> mImageRunnableArray;
    private ArrayList<ImageView> mImageViewArray;

    public LiteSurfaceView(Context context) {
        super(context);
    }

    public LiteSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void setScalingType(IVideoRender.ScalingType type) {
        RendererCommon.ScalingType webrtcType;
        Logging.i(TAG, this.hashCodeToHex() + "setScalingType: " + (Object)((Object)type));
        switch (type) {
            case SCALE_ASPECT_FILL: {
                webrtcType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                break;
            }
            case SCALE_ASPECT_BALANCED: {
                webrtcType = RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
                break;
            }
            default: {
                webrtcType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
            }
        }
        super.setScalingType(webrtcType);
    }

    @Override
    public void setVideoBufferType(IVideoRender.VideoBufferType bufferType) {
    }

    @Override
    public IVideoRender.VideoBufferType getVideoBufferType() {
        return IVideoRender.VideoBufferType.VIDEO_BUFFER_TYPE_RAW_DATA;
    }

    @Override
    public void setExternalRender(boolean enable) {
    }

    @Override
    public boolean isExternalRender() {
        return false;
    }

    @CalledByNative
    public void setScalingType(int type) {
        Logging.i(TAG, "(0x" + Integer.toHexString(this.hashCode()) + ")setScalingType: " + type);
        switch (type) {
            case 0: {
                super.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
                break;
            }
            case 1: {
                super.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FILL);
                break;
            }
            case 2: {
                super.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_BALANCED);
            }
        }
    }

    @Override
    @CalledByNative
    public void setMirror(boolean mirror) {
        Logging.i(TAG, this.hashCodeToHex() + "setMirror: " + mirror);
        super.setMirror(mirror);
    }

    @Override
    @CalledByNative
    public boolean isReleased() {
        return super.isReleased();
    }

    @Override
    public boolean isMirror() {
        return false;
    }

    @Override
    public void setViewActionListener(VideoViewActionListener viewActionListener, int type) {
    }

    @Override
    @CalledByNative
    public int getRenderTime() {
        return super.getRenderTime();
    }

    @Override
    @CalledByNative
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            sMainThreadHandler.post(() -> this.init(sharedContext, rendererEvents));
            return;
        }
        ++this.mInitializedCount;
        Logging.i(TAG, this.hashCodeToHex() + ", init, sharedContext:" + sharedContext + ", initialized count:" + this.mInitializedCount);
        try {
            super.init(sharedContext, rendererEvents);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.w(TAG, this.hashCodeToHex() + ", init, caught illegalStateException:" + illegalStateException);
            illegalStateException.printStackTrace();
        }
        catch (Exception exception) {
            Logging.w(TAG, this.hashCodeToHex() + ", init, caught exception:" + exception);
            exception.printStackTrace();
        }
    }

    @Override
    @CalledByNative
    public void release() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            sMainThreadHandler.post(this::release);
            return;
        }
        --this.mInitializedCount;
        Logging.i(TAG, this.hashCodeToHex() + "release, initialized count:" + this.mInitializedCount);
        if (this.mInitializedCount <= 0) {
            this.mInitializedCount = 0;
            Logging.i(TAG, this.hashCodeToHex() + "call release");
            super.release();
            this.clearAllWatermarks();
        }
    }

    @CalledByNative
    public void setWatermarkConfig(LiteCanvasWatermarkConfig watermarkConfig) {
        ThreadUtils.getUiThreadHandler().post(() -> {
            if (this.mParent == null) {
                this.mParent = (ViewGroup)this.getParent();
            }
            this.mWatermarkConfig = watermarkConfig;
            this.clearAllWatermarks();
            if (this.mWatermarkConfig != null) {
                if (this.mWatermarkConfig.imageWatermarks != null) {
                    this.addImageWatermarks(this.mWatermarkConfig.imageWatermarks);
                }
                if (this.mWatermarkConfig.textWatermarks != null) {
                    this.addTextWatermarks(this.mWatermarkConfig.textWatermarks);
                }
                if (this.mWatermarkConfig.timestampWatermark != null) {
                    this.addTimeStampWatermark();
                }
            }
        });
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void addTextWatermarks(LiteTextWatermarkConfig[] textWatermarks) {
        this.clearTextWatermarks();
        this.mTextViewArray = new ArrayList();
        for (LiteTextWatermarkConfig watermark : textWatermarks) {
            if (watermark == null) continue;
            TextView textView = new TextView(this.getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 3;
            layoutParams.leftMargin = watermark.offsetX;
            layoutParams.topMargin = watermark.offsetY;
            if (watermark.wmWidth > 0 && watermark.wmHeight > 0) {
                layoutParams.width = watermark.wmWidth;
                layoutParams.height = watermark.wmHeight;
                textView.setBackgroundColor(watermark.wmColor);
            }
            textView.setTextSize((float)watermark.fontSize);
            textView.setTextColor(watermark.fontColor);
            textView.setText((CharSequence)watermark.content);
            this.mParent.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
            this.mTextViewArray.add(textView);
        }
    }

    private void clearTextWatermarks() {
        if (this.mTextViewArray != null && !this.mTextViewArray.isEmpty()) {
            for (TextView textView : this.mTextViewArray) {
                this.mParent.removeView((View)textView);
            }
        }
        this.mTextViewArray = null;
    }

    private void addTimeStampWatermark() {
        this.clearTimeStampWatermark();
        this.mTimeStampRunnable = new WatermarkTimeStampRunnable();
        ThreadUtils.getUiThreadHandler().post(this.mTimeStampRunnable);
    }

    private void clearTimeStampWatermark() {
        if (this.mTimeStampRunnable != null) {
            ThreadUtils.getUiThreadHandler().removeCallbacks(this.mTimeStampRunnable);
            this.mTimeStampRunnable = null;
        }
        if (this.mTimeStampView != null) {
            this.mParent.removeView((View)this.mTimeStampView);
            this.mTimeStampView = null;
        }
    }

    private void addImageWatermarks(LiteImageWatermarkConfig[] imageWatermarks) {
        this.clearImageWatermarks();
        if (imageWatermarks != null) {
            this.mImageViewArray = new ArrayList();
            this.mImageRunnableArray = new ArrayList();
            for (LiteImageWatermarkConfig config : imageWatermarks) {
                if (config == null || config.images == null || config.images.length <= 0) continue;
                if (config.images.length > 1) {
                    if (config.fps > 0) {
                        WatermarkImageRunnable runnable = new WatermarkImageRunnable(config);
                        this.mImageRunnableArray.add(runnable);
                        ThreadUtils.getUiThreadHandler().post((Runnable)runnable);
                        continue;
                    }
                    this.mParent.addView((View)this.createImageView(config));
                    continue;
                }
                this.mParent.addView((View)this.createImageView(config));
            }
        }
    }

    @SuppressLint(value={"RtlHardcoded"})
    private ImageView createImageView(LiteImageWatermarkConfig config) {
        ImageView imageView = new ImageView(this.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        if (config.imageWidth > 0 && config.imageHeight > 0) {
            layoutParams.width = config.imageWidth;
            layoutParams.height = config.imageHeight;
        }
        layoutParams.gravity = 3;
        layoutParams.leftMargin = config.offsetX;
        layoutParams.topMargin = config.offsetY;
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setImageBitmap(config.images[config.images.length - 1]);
        imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mImageViewArray.add(imageView);
        return imageView;
    }

    private void clearImageWatermarks() {
        if (this.mImageRunnableArray != null && !this.mImageRunnableArray.isEmpty()) {
            for (Runnable runnable : this.mImageRunnableArray) {
                ThreadUtils.getUiThreadHandler().removeCallbacks(runnable);
            }
            this.mImageRunnableArray = null;
        }
        if (this.mImageViewArray != null && !this.mImageViewArray.isEmpty()) {
            for (ImageView imageView : this.mImageViewArray) {
                this.mParent.removeView((View)imageView);
            }
            this.mImageViewArray = null;
        }
    }

    private void clearAllWatermarks() {
        this.clearTextWatermarks();
        this.clearTimeStampWatermark();
        this.clearImageWatermarks();
    }

    private String hashCodeToHex() {
        ViewParent parent = this.getParent();
        if (parent == null) {
            return String.format("(0x%08x)", this.hashCode());
        }
        return String.format("(0x%08x)", this.hashCode()) + String.format("(p: %s)", Integer.toHexString(parent.hashCode()));
    }

    private class WatermarkImageRunnable
    implements Runnable {
        private final LiteImageWatermarkConfig mConfig;
        private ImageView mImageView;
        private int mIndex = 0;

        WatermarkImageRunnable(LiteImageWatermarkConfig config) {
            this.mConfig = config;
        }

        @Override
        public void run() {
            if (this.mConfig != null && this.mConfig.images != null) {
                if (this.mImageView == null) {
                    this.mImageView = LiteSurfaceView.this.createImageView(this.mConfig);
                    LiteSurfaceView.this.mParent.addView((View)this.mImageView);
                }
                this.mImageView.setImageBitmap(this.mConfig.images[this.mIndex]);
                ++this.mIndex;
                if (this.mIndex >= this.mConfig.images.length) {
                    if (this.mConfig.loop) {
                        this.mIndex = 0;
                        ThreadUtils.getUiThreadHandler().postDelayed((Runnable)this, (long)(1000 / this.mConfig.fps));
                    } else {
                        this.mImageView.setVisibility(8);
                    }
                } else {
                    ThreadUtils.getUiThreadHandler().postDelayed((Runnable)this, (long)(1000 / this.mConfig.fps));
                }
            }
        }
    }

    private class WatermarkTimeStampRunnable
    implements Runnable {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);

        private WatermarkTimeStampRunnable() {
        }

        @Override
        @SuppressLint(value={"RtlHardcoded"})
        public void run() {
            if (LiteSurfaceView.this.mWatermarkConfig != null && ((LiteSurfaceView)LiteSurfaceView.this).mWatermarkConfig.timestampWatermark != null) {
                if (LiteSurfaceView.this.mTimeStampView == null) {
                    LiteSurfaceView.this.mTimeStampView = new TextView(LiteSurfaceView.this.mParent.getContext());
                    FrameLayout.LayoutParams timeStampLayoutParams = new FrameLayout.LayoutParams(-2, -2);
                    LiteTimestampWatermarkConfig timestampWatermarks = ((LiteSurfaceView)LiteSurfaceView.this).mWatermarkConfig.timestampWatermark;
                    timeStampLayoutParams.gravity = 3;
                    LiteSurfaceView.this.mTimeStampView.setTextSize((float)timestampWatermarks.fontSize);
                    LiteSurfaceView.this.mTimeStampView.setTextColor(timestampWatermarks.fontColor);
                    timeStampLayoutParams.leftMargin = timestampWatermarks.offsetX;
                    timeStampLayoutParams.topMargin = timestampWatermarks.offsetY;
                    if (timestampWatermarks.wmWidth > 0 && timestampWatermarks.wmHeight > 0) {
                        timeStampLayoutParams.width = timestampWatermarks.wmWidth;
                        timeStampLayoutParams.height = timestampWatermarks.wmHeight;
                        LiteSurfaceView.this.mTimeStampView.setBackgroundColor(timestampWatermarks.wmColor);
                    }
                    LiteSurfaceView.this.mParent.addView((View)LiteSurfaceView.this.mTimeStampView, (ViewGroup.LayoutParams)timeStampLayoutParams);
                }
                String timeStamp = this.simpleDateFormat.format(Calendar.getInstance().getTime());
                LiteSurfaceView.this.mTimeStampView.setText((CharSequence)timeStamp);
                ThreadUtils.getUiThreadHandler().postDelayed((Runnable)this, 1000L);
            }
        }
    }
}

