/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.render;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.ViewParent;
import com.netease.lava.api.IVideoRender;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.RendererCommon;
import com.netease.yunxin.lite.video.VideoViewActionListener;
import com.netease.yunxin.lite.video.render.TextureViewRenderer;

public class LiteTextureView
extends TextureViewRenderer
implements IVideoRender {
    private static final String TAG = "LiteTextureView";
    private static final Handler sMainThreadHandler = new Handler(Looper.getMainLooper());
    private int mInitializedCount = 0;

    public LiteTextureView(Context context) {
        super(context);
    }

    public LiteTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void setScalingType(IVideoRender.ScalingType type) {
        RendererCommon.ScalingType webrtcType;
        Logging.i(TAG, this.hashCodeToHex() + "setScalingType: " + (Object)((Object)type));
        switch (type) {
            case SCALE_ASPECT_FILL: {
                webrtcType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                break;
            }
            case SCALE_ASPECT_BALANCED: {
                webrtcType = RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
                break;
            }
            default: {
                webrtcType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
            }
        }
        super.setScalingType(webrtcType);
    }

    @Override
    public void setVideoBufferType(IVideoRender.VideoBufferType bufferType) {
    }

    @Override
    public IVideoRender.VideoBufferType getVideoBufferType() {
        return IVideoRender.VideoBufferType.VIDEO_BUFFER_TYPE_RAW_DATA;
    }

    @Override
    public void setExternalRender(boolean enable) {
    }

    @Override
    public boolean isExternalRender() {
        return false;
    }

    @CalledByNative
    public void setScalingType(int type) {
        Logging.i(TAG, "(0x" + Integer.toHexString(this.hashCode()) + ")setScalingType: " + type);
        switch (type) {
            case 0: {
                super.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
                break;
            }
            case 1: {
                super.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FILL);
                break;
            }
            case 2: {
                super.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_BALANCED);
            }
        }
    }

    @Override
    @CalledByNative
    public void setMirror(boolean mirror) {
        Logging.i(TAG, this.hashCodeToHex() + "setMirror: " + mirror);
        super.setMirror(mirror);
    }

    @Override
    @CalledByNative
    public boolean isReleased() {
        return super.isReleased();
    }

    @Override
    public boolean isMirror() {
        return false;
    }

    @Override
    public void setViewActionListener(VideoViewActionListener viewActionListener, int type) {
    }

    @Override
    @CalledByNative
    public int getRenderTime() {
        return super.getRenderTime();
    }

    @Override
    @CalledByNative
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            sMainThreadHandler.post(() -> this.init(sharedContext, rendererEvents));
            return;
        }
        ++this.mInitializedCount;
        Logging.i(TAG, this.hashCodeToHex() + ", init, sharedContext:" + sharedContext + ", initialized count:" + this.mInitializedCount);
        try {
            super.init(sharedContext, rendererEvents);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.w(TAG, this.hashCodeToHex() + ", init, caught illegalStateException:" + illegalStateException);
            illegalStateException.printStackTrace();
        }
        catch (Exception exception) {
            Logging.w(TAG, this.hashCodeToHex() + ", init, caught exception:" + exception);
            exception.printStackTrace();
        }
    }

    @Override
    @CalledByNative
    public void release() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            sMainThreadHandler.post(this::release);
            return;
        }
        --this.mInitializedCount;
        Logging.i(TAG, this.hashCodeToHex() + "release, initialized count:" + this.mInitializedCount);
        if (this.mInitializedCount <= 0) {
            this.mInitializedCount = 0;
            Logging.i(TAG, this.hashCodeToHex() + "call release");
            super.release();
        }
    }

    private String hashCodeToHex() {
        ViewParent parent = this.getParent();
        if (parent == null) {
            return String.format("(0x%08x)", this.hashCode());
        }
        return String.format("(0x%08x)", this.hashCode()) + String.format("(p: %s)", Integer.toHexString(parent.hashCode()));
    }
}

