/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.video.render;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.TextureView;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.EglRenderer;
import com.netease.lava.webrtc.GlRectDrawer;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.RendererCommon;
import com.netease.lava.webrtc.SurfaceEglRenderer;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.VideoSink;
import java.util.concurrent.CountDownLatch;

public class TextureViewRenderer
extends TextureView
implements TextureView.SurfaceTextureListener,
VideoSink,
RendererCommon.RendererEvents {
    private static final String TAG = "TextureViewRenderer";
    private String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private SurfaceEglRenderer eglRenderer;
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private volatile boolean hadReleased = true;

    public TextureViewRenderer(Context context) {
        super(context);
        this.setup();
    }

    public TextureViewRenderer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    private void setup() {
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.setSurfaceTextureListener(this);
    }

    public void setLogName(String name) {
        this.resourceName = "uid: " + name + " :";
        if (this.eglRenderer != null) {
            this.eglRenderer.setName(this.resourceName);
        }
    }

    public void setReportFpsInterval(long millisecond) {
        if (this.eglRenderer != null) {
            this.eglRenderer.setReportFpsInterval(millisecond);
        }
    }

    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        this.init(sharedContext, rendererEvents, EglBase.CONFIG_PLAIN_3, new GlRectDrawer());
    }

    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(sharedContext, this, configAttributes, drawer);
        this.hadReleased = false;
    }

    public void release() {
        this.hadReleased = true;
        this.eglRenderer.release();
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        this.eglRenderer.addFrameListener(listener, scale, drawerParam);
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale) {
        this.eglRenderer.addFrameListener(listener, scale);
    }

    public void removeFrameListener(EglRenderer.FrameListener listener) {
        this.eglRenderer.removeFrameListener(listener);
    }

    public void setMirror(boolean mirror) {
        this.eglRenderer.setMirror(mirror);
    }

    public int getRenderTime() {
        return this.eglRenderer.getRenderTime();
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType);
        this.requestLayout();
    }

    public void setScalingType(RendererCommon.ScalingType scalingTypeMatchOrientation, RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingTypeMatchOrientation, scalingTypeMismatchOrientation);
        this.requestLayout();
    }

    @Override
    public void onFrame(VideoFrame frame) {
        if (!this.hadReleased) {
            this.eglRenderer.onFrame(frame);
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        ThreadUtils.checkIsOnMainThread();
        Point size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.setMeasuredDimension(size.x, size.y);
        this.logD("onMeasure(). New size: " + size.x + "x" + size.y);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(surface);
        this.logD("onSurfaceTextureAvailable:  size: " + width + "x" + height);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        this.logD("onSurfaceTextureSizeChanged:  size: " + width + "x" + height);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.logD("surfaceDestroyed");
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch completionLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(completionLatch::countDown);
        ThreadUtils.awaitUninterruptibly(completionLatch);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId());
        }
        catch (Resources.NotFoundException e) {
            return "";
        }
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    @Override
    public void onFirstFrameRendered() {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFirstFrameRendered();
        }
    }

    public boolean isReleased() {
        return this.hadReleased;
    }

    @Override
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
        }
        int rotatedWidth = rotation == 0 || rotation == 180 ? videoWidth : videoHeight;
        int rotatedHeight = rotation == 0 || rotation == 180 ? videoHeight : videoWidth;
        this.postOrRun(() -> {
            this.rotatedFrameWidth = rotatedWidth;
            this.rotatedFrameHeight = rotatedHeight;
            this.requestLayout();
        });
    }

    @Override
    public void onReceivedFps(int fps) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onReceivedFps(fps);
        }
    }

    @Override
    public void onRendererFps(int fps) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onRendererFps(fps);
        }
    }

    @Override
    public void onRenderError(String msg) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onRenderError(msg);
        }
    }

    private void postOrRun(Runnable r) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r.run();
        } else {
            this.post(r);
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.resourceName + string);
    }
}

