/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import com.netflix.config.sources.AbstractDynamoDbConfigurationSource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDbConfigurationSource
extends AbstractDynamoDbConfigurationSource<Object>
implements PolledConfigurationSource {
    private static final Logger log = LoggerFactory.getLogger(DynamoDbConfigurationSource.class);

    public DynamoDbConfigurationSource() {
    }

    public DynamoDbConfigurationSource(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
    }

    public DynamoDbConfigurationSource(AWSCredentials credentials) {
        super(credentials);
    }

    public DynamoDbConfigurationSource(AWSCredentials credentials, ClientConfiguration clientConfiguration) {
        super(credentials, clientConfiguration);
    }

    public DynamoDbConfigurationSource(AWSCredentialsProvider credentialsProvider) {
        super(credentialsProvider);
    }

    public DynamoDbConfigurationSource(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(credentialsProvider, clientConfiguration);
    }

    public DynamoDbConfigurationSource(AmazonDynamoDB dbClient) {
        super(dbClient);
    }

    @Override
    protected synchronized Map<String, Object> loadPropertiesFromTable(String table) {
        ScanResult result;
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        Map lastKeysEvaluated = null;
        do {
            ScanRequest scanRequest = new ScanRequest().withTableName(table).withExclusiveStartKey(lastKeysEvaluated);
            result = this.dbScanWithThroughputBackOff(scanRequest);
            for (Map item : result.getItems()) {
                propertyMap.put(((AttributeValue)item.get(this.keyAttributeName.get())).getS(), ((AttributeValue)item.get(this.valueAttributeName.get())).getS());
            }
        } while ((lastKeysEvaluated = result.getLastEvaluatedKey()) != null);
        return propertyMap;
    }

    public PollResult poll(boolean initial, Object checkPoint) throws Exception {
        String table = this.tableName.get();
        Map<String, Object> map = this.loadPropertiesFromTable(table);
        log.info("Successfully polled Dynamo for a new configuration based on table:" + table);
        return PollResult.createFull(map);
    }
}

