/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import com.netflix.config.PropertyWithDeploymentContext;
import com.netflix.config.sources.DynamoDbDeploymentContextTableCache;
import java.util.HashMap;

public class DynamoDbDeploymentContextConfigurationSource
implements PolledConfigurationSource {
    private final DynamoDbDeploymentContextTableCache tableCache;
    private final DeploymentContext.ContextKey contextKey;
    private final DeploymentContext deploymentContext = ConfigurationManager.getDeploymentContext();

    public DynamoDbDeploymentContextConfigurationSource(DynamoDbDeploymentContextTableCache tableCache, DeploymentContext.ContextKey contextKey) {
        this.tableCache = tableCache;
        this.contextKey = contextKey;
    }

    public PollResult poll(boolean initial, Object checkPoint) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        for (PropertyWithDeploymentContext prop : this.tableCache.getProperties()) {
            if (prop.getContextKey() == this.contextKey && prop.getContextValue() == null) {
                map.put(prop.getPropertyName(), prop.getPropertyValue());
                continue;
            }
            if (prop.getContextKey() != this.contextKey || !prop.getContextValue().equalsIgnoreCase(this.deploymentContext.getValue(this.contextKey))) continue;
            map.put(prop.getPropertyName(), prop.getPropertyValue());
        }
        return PollResult.createFull(map);
    }
}

