/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamoDbConfigurationSource<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDynamoDbConfigurationSource.class);
    static final String tablePropertyName = "com.netflix.config.dynamo.tableName";
    static final String keyAttributePropertyName = "com.netflix.config.dynamo.keyAttributeName";
    static final String valueAttributePropertyName = "com.netflix.config.dynamo.valueAttributeName";
    static final String endpointPropertyName = "com.netflix.config.dynamo.endpoint";
    static final String pollingMaxBackOffMsPropertyName = "com.netflix.config.dynamo.maxPollingBackOffMs";
    static final String pollingMinBackOffMsPropertyName = "com.netflix.config.dynamo.maxPollingBackOffMs";
    static final String maxRetryCountPropertyName = "com.netflix.config.dynamo.maxRetryCount";
    static final String defaultTable = "archaiusProperties";
    static final String defaultKeyAttribute = "key";
    static final String defaultValueAttribute = "value";
    static final String defaultEndpoint = "dynamodb.us-east-1.amazonaws.com";
    static final Long defaultMaxBackOffMs = 5000L;
    static final Long defaultMinBackOffMs = 500L;
    static final Long defaultMaxRetryCount = 100L;
    protected DynamicStringProperty tableName = DynamicPropertyFactory.getInstance().getStringProperty("com.netflix.config.dynamo.tableName", "archaiusProperties");
    protected DynamicStringProperty keyAttributeName = DynamicPropertyFactory.getInstance().getStringProperty("com.netflix.config.dynamo.keyAttributeName", "key");
    protected DynamicStringProperty valueAttributeName = DynamicPropertyFactory.getInstance().getStringProperty("com.netflix.config.dynamo.valueAttributeName", "value");
    protected DynamicStringProperty endpointName = DynamicPropertyFactory.getInstance().getStringProperty("com.netflix.config.dynamo.endpoint", "dynamodb.us-east-1.amazonaws.com");
    protected DynamicLongProperty maxBackOffMs = DynamicPropertyFactory.getInstance().getLongProperty("com.netflix.config.dynamo.maxPollingBackOffMs", defaultMaxBackOffMs.longValue());
    protected DynamicLongProperty minBackOffMs = DynamicPropertyFactory.getInstance().getLongProperty("com.netflix.config.dynamo.maxPollingBackOffMs", defaultMinBackOffMs.longValue());
    protected DynamicLongProperty maxRetryCount = DynamicPropertyFactory.getInstance().getLongProperty("com.netflix.config.dynamo.maxRetryCount", defaultMaxRetryCount.longValue());
    protected AmazonDynamoDB dbClient;

    public AbstractDynamoDbConfigurationSource() {
        this((AmazonDynamoDB)new AmazonDynamoDBClient());
    }

    public AbstractDynamoDbConfigurationSource(ClientConfiguration clientConfiguration) {
        this((AmazonDynamoDB)new AmazonDynamoDBClient(clientConfiguration));
    }

    public AbstractDynamoDbConfigurationSource(AWSCredentials credentials) {
        this((AmazonDynamoDB)new AmazonDynamoDBClient(credentials));
    }

    public AbstractDynamoDbConfigurationSource(AWSCredentials credentials, ClientConfiguration clientConfiguration) {
        this((AmazonDynamoDB)new AmazonDynamoDBClient(credentials, clientConfiguration));
    }

    public AbstractDynamoDbConfigurationSource(AWSCredentialsProvider credentialsProvider) {
        this((AmazonDynamoDB)new AmazonDynamoDBClient(credentialsProvider));
    }

    public AbstractDynamoDbConfigurationSource(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this((AmazonDynamoDB)new AmazonDynamoDBClient(credentialsProvider, clientConfiguration));
    }

    public AbstractDynamoDbConfigurationSource(AmazonDynamoDB dbClient) {
        this.dbClient = dbClient;
    }

    protected ScanResult dbScanWithThroughputBackOff(ScanRequest scanRequest) {
        Long currentBackOffMs = this.minBackOffMs.get();
        Long retryCount = 0L;
        while (true) {
            try {
                return this.dbClient.scan(scanRequest);
            }
            catch (ProvisionedThroughputExceededException e) {
                currentBackOffMs = Math.min(currentBackOffMs * 2L, this.maxBackOffMs.get());
                log.error(String.format("Failed to poll Dynamo due to ProvisionedThroughputExceededException. Backing off for %d ms.", currentBackOffMs));
                if (retryCount > this.maxRetryCount.get()) {
                    throw e;
                }
                Long l = retryCount;
                Long l2 = retryCount = Long.valueOf(retryCount + 1L);
                try {
                    Thread.sleep(currentBackOffMs);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    protected abstract Map<String, T> loadPropertiesFromTable(String var1);

    public void validateDb() {
        String table = this.tableName.get();
        this.loadPropertiesFromTable(table);
        log.info("Successfully polled Dynamo for a new configuration based on table:" + table);
    }

    private void setEndpoint() {
        String endpoint = this.endpointName.get();
        this.dbClient.setEndpoint(endpoint);
        log.info("Set Dynamo endpoint:" + endpoint);
    }
}

