/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class S3ConfigurationSource
implements PolledConfigurationSource {
    private final AmazonS3 client;
    private final String bucketName;
    private final String key;

    public S3ConfigurationSource(AWSCredentialsProvider credentialsProvider, String bucketName, String key) {
        this((AmazonS3)new AmazonS3Client(credentialsProvider), bucketName, key);
    }

    public S3ConfigurationSource(AmazonS3 client, String bucketName, String key) {
        this.client = client;
        this.bucketName = bucketName;
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollResult poll(boolean initial, Object checkPoint) throws IOException, AmazonServiceException {
        GetObjectRequest s3request = new GetObjectRequest(this.bucketName, this.key);
        try (InputStream is = null;){
            S3Object result = this.client.getObject(s3request);
            is = result.getObjectContent();
            Map<String, Object> resultMap = this.inputStreamToMap(is);
            PollResult pollResult = PollResult.createFull(resultMap);
            return pollResult;
        }
    }

    protected Map<String, Object> inputStreamToMap(InputStream is) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Properties props = new Properties();
        props.load(is);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }
}

