/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.bridge;

import com.netflix.config.DeploymentContext;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StaticDeploymentContext
implements DeploymentContext {
    private static volatile DeploymentContext delegate;

    @Inject
    public static void initialize(DeploymentContext context) {
        delegate = context;
    }

    public static void reset() {
        delegate = null;
    }

    public String getDeploymentEnvironment() {
        return this.getValue(DeploymentContext.ContextKey.environment);
    }

    public void setDeploymentEnvironment(String env) {
        delegate.setDeploymentEnvironment(env);
    }

    public String getDeploymentDatacenter() {
        return this.getValue(DeploymentContext.ContextKey.datacenter);
    }

    public void setDeploymentDatacenter(String deployedAt) {
        delegate.setDeploymentDatacenter(deployedAt);
    }

    public String getApplicationId() {
        return this.getValue(DeploymentContext.ContextKey.appId);
    }

    public void setApplicationId(String appId) {
        delegate.setApplicationId(appId);
    }

    public String getDeploymentServerId() {
        return this.getValue(DeploymentContext.ContextKey.serverId);
    }

    public void setDeploymentServerId(String serverId) {
        delegate.setDeploymentServerId(serverId);
    }

    public String getDeploymentStack() {
        return this.getValue(DeploymentContext.ContextKey.stack);
    }

    public void setDeploymentStack(String stack) {
        delegate.setDeploymentStack(stack);
    }

    public String getDeploymentRegion() {
        return this.getValue(DeploymentContext.ContextKey.region);
    }

    public void setDeploymentRegion(String region) {
        delegate.setDeploymentRegion(region);
    }

    public String getValue(DeploymentContext.ContextKey key) {
        if (delegate == null) {
            System.out.println("Configuration not yet initialized.  Returning 'null' for " + key);
            return null;
        }
        return delegate.getValue(key);
    }

    public void setValue(DeploymentContext.ContextKey key, String value) {
        delegate.setValue(key, value);
    }
}

