/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.bridge;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.api.inject.RuntimeLayer;
import com.netflix.config.DeploymentContext;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConfigBasedDeploymentContext
implements DeploymentContext {
    private final Config config;
    private final SettableConfig override;

    @Inject
    public ConfigBasedDeploymentContext(Config config, @RuntimeLayer SettableConfig override) {
        this.config = config;
        this.override = override;
    }

    public String getDeploymentEnvironment() {
        return this.config.getString(DeploymentContext.ContextKey.environment.getKey(), "");
    }

    public void setDeploymentEnvironment(String env) {
        this.override.setProperty(DeploymentContext.ContextKey.environment.getKey(), (Object)env);
    }

    public String getDeploymentDatacenter() {
        return this.config.getString(DeploymentContext.ContextKey.datacenter.getKey(), "");
    }

    public void setDeploymentDatacenter(String deployedAt) {
        this.override.setProperty(DeploymentContext.ContextKey.datacenter.getKey(), (Object)deployedAt);
    }

    public String getApplicationId() {
        return this.config.getString(DeploymentContext.ContextKey.appId.getKey(), "");
    }

    public void setApplicationId(String appId) {
        this.override.setProperty(DeploymentContext.ContextKey.appId.getKey(), (Object)appId);
    }

    public void setDeploymentServerId(String serverId) {
        this.override.setProperty(DeploymentContext.ContextKey.serverId.getKey(), (Object)serverId);
    }

    public String getDeploymentServerId() {
        return this.config.getString(DeploymentContext.ContextKey.serverId.getKey(), "");
    }

    public String getDeploymentStack() {
        return this.config.getString(DeploymentContext.ContextKey.stack.getKey(), "");
    }

    public String getValue(DeploymentContext.ContextKey key) {
        return this.config.getString(key.getKey(), "");
    }

    public void setValue(DeploymentContext.ContextKey key, String value) {
        this.override.setProperty(key.getKey(), (Object)value);
    }

    public void setDeploymentStack(String stack) {
        this.override.setProperty(DeploymentContext.ContextKey.stack.getKey(), (Object)stack);
    }

    public String getDeploymentRegion() {
        return this.config.getString(DeploymentContext.ContextKey.region.getKey(), "");
    }

    public void setDeploymentRegion(String region) {
        this.override.setProperty(DeploymentContext.ContextKey.region.getKey(), (Object)region);
    }
}

