/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.bridge;

import com.netflix.archaius.bridge.AbstractConfigurationBridge;
import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.PropertyListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;

@Singleton
public class StaticAbstractConfiguration
extends AbstractConfiguration
implements AggregatedConfiguration,
DynamicPropertySupport {
    private static volatile AbstractConfigurationBridge delegate;
    private static ConcurrentLinkedQueue<PropertyListener> pendingListeners;
    private static StaticAbstractConfiguration staticConfig;

    public StaticAbstractConfiguration() {
        staticConfig = this;
    }

    @Inject
    public static void initialize(AbstractConfigurationBridge config) {
        PropertyListener listener;
        delegate = config;
        ConfigurationManager.getConfigInstance();
        if (staticConfig == null) {
            UnsupportedOperationException cause = new UnsupportedOperationException("**** Remove static reference to ConfigurationManager or FastProperty in this call stack ****");
            cause.setStackTrace(ConfigurationManager.getStaticInitializationSource());
            throw new IllegalStateException("Archaius2 bridge not usable because ConfigurationManager was initialized too early.  See stack trace below.", cause);
        }
        AbstractConfiguration actualConfig = ConfigurationManager.getConfigInstance();
        if (!actualConfig.equals((Object)staticConfig)) {
            throw new IllegalStateException("Not using expected bridge!!! " + actualConfig.getClass() + " instead of " + ((Object)((Object)staticConfig)).getClass());
        }
        DynamicPropertyFactory.initWithConfigurationSource((AbstractConfiguration)staticConfig);
        while (null != (listener = pendingListeners.poll())) {
            delegate.addConfigurationListener(listener);
        }
    }

    public static void reset() {
        delegate = null;
    }

    public boolean isEmpty() {
        if (delegate == null) {
            System.err.println("[isEmpty()] StaticAbstractConfiguration not initialized yet.");
            return true;
        }
        return delegate.isEmpty();
    }

    public boolean containsKey(String key) {
        if (delegate == null) {
            System.err.println("[containsKey(" + key + ")] StaticAbstractConfiguration not initialized yet.");
            return false;
        }
        return delegate.containsKey(key);
    }

    public String getString(String key, String defaultValue) {
        if (delegate == null) {
            System.out.println("[getString(" + key + ", " + defaultValue + ")] StaticAbstractConfiguration not initialized yet.");
            return defaultValue;
        }
        return delegate.getString(key, defaultValue);
    }

    public Object getProperty(String key) {
        if (delegate == null) {
            System.out.println("[getProperty(" + key + ")] StaticAbstractConfiguration not initialized yet.");
            return null;
        }
        return delegate.getProperty(key);
    }

    public Iterator<String> getKeys() {
        if (delegate == null) {
            throw new RuntimeException("[getKeys()] StaticAbstractConfiguration not initialized yet.");
        }
        return delegate.getKeys();
    }

    public void addConfiguration(AbstractConfiguration config) {
        delegate.addConfiguration(config);
    }

    public void addConfiguration(AbstractConfiguration config, String name) {
        delegate.addConfiguration(config, name);
    }

    public Set<String> getConfigurationNames() {
        return delegate.getConfigurationNames();
    }

    public List<String> getConfigurationNameList() {
        return delegate.getConfigurationNameList();
    }

    public Configuration getConfiguration(String name) {
        return delegate.getConfiguration(name);
    }

    public int getNumberOfConfigurations() {
        return delegate.getNumberOfConfigurations();
    }

    public Configuration getConfiguration(int index) {
        return delegate.getConfiguration(index);
    }

    public List<AbstractConfiguration> getConfigurations() {
        return delegate.getConfigurations();
    }

    public Configuration removeConfiguration(String name) {
        return delegate.removeConfiguration(name);
    }

    public boolean removeConfiguration(Configuration config) {
        return delegate.removeConfiguration(config);
    }

    public Configuration removeConfigurationAt(int index) {
        return delegate.removeConfigurationAt(index);
    }

    protected void addPropertyDirect(String key, Object value) {
        delegate.addPropertyDirect(key, value);
    }

    protected void clearPropertyDirect(String key) {
        delegate.clearProperty(key);
    }

    public void addConfigurationListener(PropertyListener expandedPropertyListener) {
        if (delegate == null) {
            pendingListeners.add(expandedPropertyListener);
        } else {
            delegate.addConfigurationListener(expandedPropertyListener);
        }
    }

    static {
        pendingListeners = new ConcurrentLinkedQueue();
    }
}

