/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.bridge;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.api.inject.LibrariesLayer;
import com.netflix.archaius.api.inject.RuntimeLayer;
import com.netflix.archaius.bridge.ConfigToCommonsAdapter;
import com.netflix.archaius.commons.CommonsToConfig;
import com.netflix.archaius.config.DefaultConfigListener;
import com.netflix.archaius.exceptions.ConfigAlreadyExistsException;
import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.PropertyListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;

@Singleton
class AbstractConfigurationBridge
extends AbstractConfiguration
implements AggregatedConfiguration,
DynamicPropertySupport {
    private final Config config;
    private final SettableConfig settable;
    private final CompositeConfig libraries;
    private final AtomicInteger libNameCounter = new AtomicInteger();

    @Inject
    public AbstractConfigurationBridge(final Config config, @LibrariesLayer CompositeConfig libraries, @RuntimeLayer SettableConfig settable) {
        AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
        this.config = config;
        this.settable = settable;
        this.libraries = libraries;
        this.config.addListener(new ConfigListener(){

            public void onConfigAdded(Config child) {
                this.onConfigUpdated(config);
            }

            public void onConfigRemoved(Config child) {
                this.onConfigUpdated(config);
            }

            public void onConfigUpdated(Config config2) {
                AbstractConfigurationBridge.this.fireEvent(11, null, null, true);
                AbstractConfigurationBridge.this.fireEvent(11, null, null, false);
            }

            public void onError(Throwable error, Config config2) {
            }
        });
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public String getString(String key, String defaultValue) {
        return this.config.getString(key, defaultValue);
    }

    public Object getProperty(String key) {
        return this.config.getRawProperty(key);
    }

    public Iterator<String> getKeys() {
        return this.config.getKeys();
    }

    protected void addPropertyDirect(String key, Object value) {
        this.settable.setProperty(key, value);
    }

    protected void clearPropertyDirect(String key) {
        this.settable.clearProperty(key);
    }

    public void addConfiguration(AbstractConfiguration config) {
        this.addConfiguration(config, "Config-" + this.libNameCounter.incrementAndGet());
    }

    public void addConfiguration(AbstractConfiguration config, String name) {
        try {
            this.libraries.addConfig(name, (Config)new CommonsToConfig(config));
        }
        catch (ConfigAlreadyExistsException configAlreadyExistsException) {
        }
        catch (ConfigException e) {
            throw new RuntimeException("Unable to add configuration " + name, e);
        }
    }

    public Set<String> getConfigurationNames() {
        return Sets.newHashSet((Iterable)this.libraries.getConfigNames());
    }

    public List<String> getConfigurationNameList() {
        return Lists.newArrayList((Iterable)this.libraries.getConfigNames());
    }

    public Configuration getConfiguration(String name) {
        return new ConfigToCommonsAdapter(this.libraries.getConfig(name));
    }

    public int getNumberOfConfigurations() {
        return this.libraries.getConfigNames().size();
    }

    public Configuration getConfiguration(int index) {
        throw new UnsupportedOperationException();
    }

    public List<AbstractConfiguration> getConfigurations() {
        throw new UnsupportedOperationException();
    }

    public Configuration removeConfiguration(String name) {
        this.libraries.removeConfig(name);
        return null;
    }

    public boolean removeConfiguration(Configuration config) {
        throw new UnsupportedOperationException();
    }

    public Configuration removeConfigurationAt(int index) {
        throw new UnsupportedOperationException();
    }

    public void addConfigurationListener(final PropertyListener expandedPropertyListener) {
        this.config.addListener((ConfigListener)new DefaultConfigListener(){

            public void onConfigAdded(Config config) {
                expandedPropertyListener.configSourceLoaded((Object)config);
            }

            public void onConfigRemoved(Config config) {
                expandedPropertyListener.configSourceLoaded((Object)config);
            }

            public void onConfigUpdated(Config config) {
                expandedPropertyListener.configSourceLoaded((Object)config);
            }
        });
    }
}

