/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.bridge;

import com.netflix.archaius.bridge.AbstractConfigurationBridge;
import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.PropertyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;

@Singleton
public class StaticAbstractConfiguration
extends AbstractConfiguration
implements AggregatedConfiguration,
DynamicPropertySupport {
    private static volatile AbstractConfigurationBridge delegate;
    private static final StaticAbstractConfiguration INSTANCE;
    private final PropertyListener forwardingPropertyListener;
    private final ConfigurationListener forwardingConfigurationListener;
    private final CopyOnWriteArrayList<PropertyListener> propertyListeners = new CopyOnWriteArrayList();

    @Inject
    public static synchronized void initialize(DeploymentContext context, AbstractConfigurationBridge config) {
        StaticAbstractConfiguration.reset();
        delegate = config;
        AbstractConfiguration actualConfig = ConfigurationManager.getConfigInstance();
        if (!actualConfig.equals((Object)INSTANCE)) {
            UnsupportedOperationException cause = new UnsupportedOperationException("**** Remove static reference to ConfigurationManager or FastProperty in this call stack ****");
            cause.setStackTrace(ConfigurationManager.getStaticInitializationSource());
            throw new IllegalStateException("Not using expected bridge!!! " + actualConfig.getClass() + " instead of " + StaticAbstractConfiguration.class, cause);
        }
        DynamicPropertyFactory.initWithConfigurationSource((AbstractConfiguration)INSTANCE);
        config.addConfigurationListener(StaticAbstractConfiguration.INSTANCE.forwardingConfigurationListener);
        config.addConfigurationListener(StaticAbstractConfiguration.INSTANCE.forwardingPropertyListener);
    }

    public static AbstractConfiguration getInstance() {
        return INSTANCE;
    }

    public static synchronized void reset() {
        if (delegate != null) {
            delegate.removeConfigurationListener(StaticAbstractConfiguration.INSTANCE.forwardingConfigurationListener);
        }
        delegate = null;
    }

    public StaticAbstractConfiguration() {
        this.forwardingPropertyListener = new PropertyListener(){

            public void configSourceLoaded(Object source) {
                StaticAbstractConfiguration.this.propertyListeners.forEach(listener -> listener.configSourceLoaded(source));
            }

            public void addProperty(Object source, String name, Object value, boolean beforeUpdate) {
                StaticAbstractConfiguration.this.propertyListeners.forEach(listener -> listener.addProperty(source, name, value, beforeUpdate));
            }

            public void setProperty(Object source, String name, Object value, boolean beforeUpdate) {
                StaticAbstractConfiguration.this.propertyListeners.forEach(listener -> listener.setProperty(source, name, value, beforeUpdate));
            }

            public void clearProperty(Object source, String name, Object value, boolean beforeUpdate) {
                StaticAbstractConfiguration.this.propertyListeners.forEach(listener -> listener.clearProperty(source, name, value, beforeUpdate));
            }

            public void clear(Object source, boolean beforeUpdate) {
                StaticAbstractConfiguration.this.propertyListeners.forEach(listener -> listener.clear(source, beforeUpdate));
            }
        };
        this.forwardingConfigurationListener = new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                StaticAbstractConfiguration.this.fireEvent(event.getType(), event.getPropertyName(), event.getPropertyValue(), event.isBeforeUpdate());
            }
        };
    }

    public boolean isEmpty() {
        if (delegate == null) {
            System.err.println("[isEmpty()] StaticAbstractConfiguration not initialized yet.");
            return true;
        }
        return delegate.isEmpty();
    }

    public boolean containsKey(String key) {
        if (delegate == null) {
            System.err.println("[containsKey(" + key + ")] StaticAbstractConfiguration not initialized yet.");
            return false;
        }
        return delegate.containsKey(key);
    }

    public String getString(String key, String defaultValue) {
        if (delegate == null) {
            System.out.println("[getString(" + key + ", " + defaultValue + ")] StaticAbstractConfiguration not initialized yet.");
            return defaultValue;
        }
        return delegate.getString(key, defaultValue);
    }

    public Object getProperty(String key) {
        if (delegate == null) {
            System.out.println("[getProperty(" + key + ")] StaticAbstractConfiguration not initialized yet.");
            return null;
        }
        return delegate.getProperty(key);
    }

    public Iterator<String> getKeys() {
        if (delegate == null) {
            throw new RuntimeException("[getKeys()] StaticAbstractConfiguration not initialized yet.");
        }
        return delegate.getKeys();
    }

    public void addConfiguration(AbstractConfiguration config) {
        delegate.addConfiguration(config);
    }

    public void addConfiguration(AbstractConfiguration config, String name) {
        delegate.addConfiguration(config, name);
    }

    public Set<String> getConfigurationNames() {
        return delegate.getConfigurationNames();
    }

    public List<String> getConfigurationNameList() {
        return delegate.getConfigurationNameList();
    }

    public Configuration getConfiguration(String name) {
        return delegate.getConfiguration(name);
    }

    public int getNumberOfConfigurations() {
        return delegate.getNumberOfConfigurations();
    }

    public Configuration getConfiguration(int index) {
        return delegate.getConfiguration(index);
    }

    public List<AbstractConfiguration> getConfigurations() {
        return delegate.getConfigurations();
    }

    public Configuration removeConfiguration(String name) {
        return delegate.removeConfiguration(name);
    }

    public boolean removeConfiguration(Configuration config) {
        return delegate.removeConfiguration(config);
    }

    public Configuration removeConfigurationAt(int index) {
        return delegate.removeConfigurationAt(index);
    }

    protected void addPropertyDirect(String key, Object value) {
        delegate.addPropertyDirect(key, value);
    }

    protected void clearPropertyDirect(String key) {
        delegate.clearProperty(key);
    }

    public Collection<ConfigurationListener> getConfigurationListeners() {
        ArrayList<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>(super.getConfigurationListeners());
        Optional.ofNullable(delegate).ifPresent(d -> listeners.addAll(d.getConfigurationListeners()));
        return listeners;
    }

    public void addConfigurationListener(PropertyListener expandedPropertyListener) {
        this.propertyListeners.add(expandedPropertyListener);
    }

    static {
        INSTANCE = new StaticAbstractConfiguration();
    }
}

