/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.bridge;

import com.netflix.config.DeploymentContext;
import javax.inject.Inject;

public final class StaticDeploymentContext
implements DeploymentContext {
    private static final StaticDeploymentContext INSTANCE = new StaticDeploymentContext();
    private static volatile DeploymentContext delegate;

    @Inject
    public static void initialize(DeploymentContext context) {
        delegate = context;
    }

    public static void reset() {
        delegate = null;
    }

    public static DeploymentContext getInstance() {
        return INSTANCE;
    }

    public String getDeploymentEnvironment() {
        return this.getValue(DeploymentContext.ContextKey.environment);
    }

    public void setDeploymentEnvironment(String env) {
        delegate.setDeploymentEnvironment(env);
    }

    public String getDeploymentDatacenter() {
        return this.getValue(DeploymentContext.ContextKey.datacenter);
    }

    public void setDeploymentDatacenter(String deployedAt) {
        delegate.setDeploymentDatacenter(deployedAt);
    }

    public String getApplicationId() {
        return this.getValue(DeploymentContext.ContextKey.appId);
    }

    public void setApplicationId(String appId) {
        this.setValue(DeploymentContext.ContextKey.appId, appId);
    }

    public String getDeploymentServerId() {
        return this.getValue(DeploymentContext.ContextKey.serverId);
    }

    public void setDeploymentServerId(String serverId) {
        this.setValue(DeploymentContext.ContextKey.serverId, serverId);
    }

    public String getDeploymentStack() {
        return this.getValue(DeploymentContext.ContextKey.stack);
    }

    public String getValue(DeploymentContext.ContextKey key) {
        if (delegate == null) {
            System.out.println("Configuration not yet initialized.  Returning 'null' for " + key);
            return null;
        }
        return delegate.getValue(key);
    }

    public void setValue(DeploymentContext.ContextKey key, String value) {
        delegate.setValue(key, value);
    }

    public void setDeploymentStack(String stack) {
        this.setValue(DeploymentContext.ContextKey.stack, stack);
    }

    public String getDeploymentRegion() {
        return this.getValue(DeploymentContext.ContextKey.region);
    }

    public void setDeploymentRegion(String region) {
        this.setValue(DeploymentContext.ContextKey.region, region);
    }
}

