/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.netflix.archaius.CascadeStrategy;
import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigLoader;
import com.netflix.archaius.ConfigMapper;
import com.netflix.archaius.IoCContainer;
import com.netflix.archaius.annotations.Configuration;
import com.netflix.archaius.annotations.ConfigurationSource;
import com.netflix.archaius.config.CompositeConfig;
import com.netflix.archaius.exceptions.ConfigException;
import com.netflix.archaius.inject.LibrariesLayer;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationInjectingListener
implements TypeListener,
IoCContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationInjectingListener.class);
    @Inject
    @LibrariesLayer
    private CompositeConfig librariesConfig;
    @Inject
    private Config rootConfig;
    @Inject
    private Injector injector;
    @Inject
    private ConfigMapper mapper;
    @Inject
    private ConfigLoader loader;
    @Inject
    private CascadeStrategy defaultStrategy;

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> encounter) {
        Configuration configAnnot;
        Class clazz = typeLiteral.getRawType();
        ConfigurationSource source = clazz.getAnnotation(ConfigurationSource.class);
        if (source != null) {
            encounter.register(new InjectionListener<I>(){

                public void afterInjection(I injectee) {
                    CascadeStrategy strategy;
                    ConfigurationSource source = injectee.getClass().getAnnotation(ConfigurationSource.class);
                    CascadeStrategy cascadeStrategy = strategy = source.cascading() != ConfigurationSource.NullCascadeStrategy.class ? (CascadeStrategy)ConfigurationInjectingListener.this.injector.getInstance(source.cascading()) : ConfigurationInjectingListener.this.defaultStrategy;
                    if (source != null) {
                        for (String resourceName : source.value()) {
                            try {
                                ConfigurationInjectingListener.this.librariesConfig.addConfig(resourceName, ConfigurationInjectingListener.this.loader.newLoader().withCascadeStrategy(strategy).load(resourceName));
                            }
                            catch (ConfigException e) {
                                throw new ProvisionException("Unable to load configuration for " + resourceName + " at source " + injectee.getClass(), (Throwable)e);
                            }
                        }
                    }
                }
            });
        }
        if ((configAnnot = clazz.getAnnotation(Configuration.class)) != null) {
            encounter.register(new InjectionListener<I>(){

                public void afterInjection(I injectee) {
                    try {
                        ConfigurationInjectingListener.this.mapper.mapConfig(injectee, ConfigurationInjectingListener.this.rootConfig, (IoCContainer)ConfigurationInjectingListener.this);
                    }
                    catch (Exception e) {
                        throw new ProvisionException("Unable to bind configuration to " + injectee.getClass(), (Throwable)e);
                    }
                }
            });
        }
    }

    public <T> T getInstance(String name, Class<T> type) {
        return (T)this.injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
    }
}

