/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Providers;
import com.netflix.archaius.CascadeStrategy;
import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigLoader;
import com.netflix.archaius.ConfigReader;
import com.netflix.archaius.Decoder;
import com.netflix.archaius.DefaultConfigLoader;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.PropertyFactory;
import com.netflix.archaius.ProxyFactory;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.config.CompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.SettableConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.archaius.exceptions.ConfigException;
import com.netflix.archaius.guice.ConfigSeeder;
import com.netflix.archaius.guice.ConfigurationInjectingListener;
import com.netflix.archaius.guice.RootLayer;
import com.netflix.archaius.inject.ApplicationLayer;
import com.netflix.archaius.inject.LibrariesLayer;
import com.netflix.archaius.inject.RemoteLayer;
import com.netflix.archaius.inject.RuntimeLayer;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import com.netflix.archaius.loaders.PropertiesConfigReader;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

public final class ArchaiusModule
extends AbstractModule {
    private static final String DEFAULT_CONFIG_NAME = "application";
    private static final String RUNTIME_LAYER_NAME = "RUNTIME";
    private static final String REMOTE_LAYER_NAME = "REMOTE";
    private static final String SYSTEM_LAYER_NAME = "SYSTEM";
    private static final String ENVIRONMENT_LAYER_NAME = "ENVIRONMENT";
    private static final String APPLICATION_LAYER_NAME = "APPLICATION";
    private static final String LIBRARIES_LAYER_NAME = "LIBRARIES";

    public static <T> AbstractModule forProxy(final Class<T> proxy) {
        return new AbstractModule(){

            protected void configure() {
                ConfigProvider provider = new ConfigProvider(proxy);
                this.requestInjection(provider);
                this.bind(proxy).toProvider(Providers.guicify(provider));
            }
        };
    }

    protected final void configure() {
        ConfigurationInjectingListener listener = new ConfigurationInjectingListener();
        this.requestInjection(listener);
        this.bindListener(Matchers.any(), listener);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigReader.class).addBinding().to(PropertiesConfigReader.class);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigSeeder.class, RuntimeLayer.class);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigSeeder.class, RemoteLayer.class);
        this.binder().disableCircularProxies();
    }

    @Provides
    @Singleton
    @ApplicationLayer
    final String getConfigName() {
        return DEFAULT_CONFIG_NAME;
    }

    @Provides
    @Singleton
    @RuntimeLayer
    final SettableConfig getSettableConfig() {
        return new DefaultSettableConfig();
    }

    @Provides
    @Singleton
    @ApplicationLayer
    final CascadeStrategy getApplicationCascadeStrategy() {
        return new NoCascadeStrategy();
    }

    @Provides
    @Singleton
    @ApplicationLayer
    Config getApplicationLayer(CompositeConfig config) {
        return config;
    }

    @Provides
    @Singleton
    @ApplicationLayer
    CompositeConfig getApplicationLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    final ConfigLoader getLoader(@RootLayer Config config, CascadeStrategy defaultStrategy, Set<ConfigReader> readers) {
        return DefaultConfigLoader.builder().withConfigReader(readers).withDefaultCascadingStrategy(defaultStrategy).withFailOnFirst(false).withStrLookup(ConfigStrLookup.from((Config)config)).build();
    }

    @Provides
    @Singleton
    @LibrariesLayer
    final CompositeConfig getLibrariesLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    @RemoteLayer
    final CompositeConfig getOverrideLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    @RemoteLayer
    final Config getOverrideLayer(@RemoteLayer CompositeConfig config) {
        return config;
    }

    @Provides
    @Singleton
    final CascadeStrategy getCascadeStrategy(@ApplicationLayer CascadeStrategy strategy) {
        return strategy;
    }

    @Provides
    @Singleton
    final Decoder getDecoder() {
        return DefaultDecoder.INSTANCE;
    }

    @Provides
    @Singleton
    @RootLayer
    final Config getInternalConfig(@RuntimeLayer SettableConfig settableLayer, @RemoteLayer Config overrideLayer, @ApplicationLayer Config applicationLayer, @LibrariesLayer CompositeConfig librariesLayer) throws ConfigException {
        return CompositeConfig.builder().withConfig(RUNTIME_LAYER_NAME, (Config)settableLayer).withConfig(REMOTE_LAYER_NAME, overrideLayer).withConfig(SYSTEM_LAYER_NAME, (Config)SystemConfig.INSTANCE).withConfig(ENVIRONMENT_LAYER_NAME, (Config)EnvironmentConfig.INSTANCE).withConfig(APPLICATION_LAYER_NAME, applicationLayer).withConfig(LIBRARIES_LAYER_NAME, (Config)librariesLayer).build();
    }

    @Provides
    @Singleton
    final Config getConfig(@RootLayer Config config, @ApplicationLayer CompositeConfig applicationLayer, @ApplicationLayer String appName, @RemoteLayer CompositeConfig overrideLayer, @RuntimeLayer SettableConfig runtimeLayer, ConfigLoader loader, @RuntimeLayer Set<ConfigSeeder> runtimeConfigResolvers, @RemoteLayer Set<ConfigSeeder> remoteConfigResolvers) throws Exception {
        Config appConfig = loader.newLoader().load(appName);
        if (appConfig != null) {
            applicationLayer.addConfig(appName, appConfig);
        }
        for (ConfigSeeder provider : runtimeConfigResolvers) {
            runtimeLayer.setProperties(provider.get(config));
        }
        for (ConfigSeeder provider : remoteConfigResolvers) {
            overrideLayer.addConfig("remote", provider.get(config));
        }
        return config;
    }

    @Provides
    @Singleton
    final PropertyFactory getPropertyFactory(Config root) {
        return DefaultPropertyFactory.from((Config)root);
    }

    public static class ConfigProvider<T>
    implements Provider<T> {
        private Class<T> type;
        @Inject
        ProxyFactory proxy;
        @Inject
        PropertyFactory factory;

        public ConfigProvider(Class<T> type) {
            this.type = type;
        }

        public T get() {
            return (T)this.proxy.newProxy(this.type, this.factory);
        }
    }
}

