/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Providers;
import com.netflix.archaius.CascadeStrategy;
import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigLoader;
import com.netflix.archaius.ConfigReader;
import com.netflix.archaius.Decoder;
import com.netflix.archaius.DefaultConfigLoader;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.PropertyFactory;
import com.netflix.archaius.ProxyFactory;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.config.CompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.SettableConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.archaius.exceptions.ConfigAlreadyExistsException;
import com.netflix.archaius.exceptions.ConfigException;
import com.netflix.archaius.guice.ConfigSeeder;
import com.netflix.archaius.guice.ConfigurationInjectingListener;
import com.netflix.archaius.guice.RootLayer;
import com.netflix.archaius.inject.ApplicationLayer;
import com.netflix.archaius.inject.LibrariesLayer;
import com.netflix.archaius.inject.RemoteLayer;
import com.netflix.archaius.inject.RuntimeLayer;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import com.netflix.archaius.readers.PropertiesConfigReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;

public final class ArchaiusModule
extends AbstractModule {
    private static final String DEFAULT_CONFIG_NAME = "application";
    private static final String RUNTIME_LAYER_NAME = "RUNTIME";
    private static final String REMOTE_LAYER_NAME = "REMOTE";
    private static final String SYSTEM_LAYER_NAME = "SYSTEM";
    private static final String ENVIRONMENT_LAYER_NAME = "ENVIRONMENT";
    private static final String APPLICATION_LAYER_NAME = "APPLICATION";
    private static final String LIBRARIES_LAYER_NAME = "LIBRARIES";

    public static <T> AbstractModule forProxy(final Class<T> proxy) {
        return new AbstractModule(){

            protected void configure() {
                ConfigProvider provider = new ConfigProvider(proxy);
                this.requestInjection(provider);
                this.bind(proxy).toProvider(Providers.guicify(provider));
            }
        };
    }

    protected void configure() {
        this.bindListener(Matchers.any(), new ConfigurationInjectingListener());
        Multibinder.newSetBinder((Binder)this.binder(), ConfigReader.class).addBinding().to(PropertiesConfigReader.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigSeeder.class, RuntimeLayer.class);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigSeeder.class, RemoteLayer.class);
        this.binder().disableCircularProxies();
    }

    @Provides
    @Singleton
    @ApplicationLayer
    String getConfigName() {
        return DEFAULT_CONFIG_NAME;
    }

    @Provides
    @Singleton
    @RuntimeLayer
    SettableConfig getSettableConfig() {
        return new DefaultSettableConfig();
    }

    @Provides
    @Singleton
    @ApplicationLayer
    Config getApplicationLayer(CompositeConfig config) {
        return config;
    }

    @Provides
    @Singleton
    @ApplicationLayer
    CompositeConfig getApplicationLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    ConfigLoader getLoader(@RootLayer Config config, CascadeStrategy defaultStrategy, Set<ConfigReader> readers) {
        return DefaultConfigLoader.builder().withConfigReader(readers).withDefaultCascadingStrategy(defaultStrategy).withFailOnFirst(false).withStrLookup(ConfigStrLookup.from((Config)config)).build();
    }

    @Provides
    @Singleton
    @LibrariesLayer
    CompositeConfig getLibrariesLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    @RemoteLayer
    CompositeConfig getOverrideLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    @RemoteLayer
    Config getOverrideLayer(@RemoteLayer CompositeConfig config) {
        return config;
    }

    @Provides
    @Singleton
    CascadeStrategy getCascadeStrategy() {
        return new NoCascadeStrategy();
    }

    @Provides
    @Singleton
    Decoder getDecoder() {
        return DefaultDecoder.INSTANCE;
    }

    @Provides
    @Singleton
    @RootLayer
    Config getInternalConfig(@RuntimeLayer SettableConfig settableLayer, @RemoteLayer Config overrideLayer, @ApplicationLayer CompositeConfig applicationLayer, @LibrariesLayer CompositeConfig librariesLayer) throws ConfigException {
        return CompositeConfig.builder().withConfig(RUNTIME_LAYER_NAME, (Config)settableLayer).withConfig(REMOTE_LAYER_NAME, overrideLayer).withConfig(SYSTEM_LAYER_NAME, (Config)SystemConfig.INSTANCE).withConfig(ENVIRONMENT_LAYER_NAME, (Config)EnvironmentConfig.INSTANCE).withConfig(APPLICATION_LAYER_NAME, (Config)applicationLayer).withConfig(LIBRARIES_LAYER_NAME, (Config)librariesLayer).build();
    }

    @Provides
    @Singleton
    public Config getConfig(@RootLayer Config config, @ApplicationLayer CompositeConfig applicationLayer, @ApplicationLayer String configName, @RemoteLayer CompositeConfig overrideLayer, @RuntimeLayer SettableConfig runtimeLayer, ConfigLoader loader, CascadeStrategy cascadeStrategy, @RuntimeLayer Set<ConfigSeeder> runtimeConfigResolvers, @RemoteLayer Set<ConfigSeeder> remoteConfigResolvers) throws Exception {
        LinkedHashMap loadedConfigs = loader.newLoader().withCascadeStrategy((CascadeStrategy)new NoCascadeStrategy()).load(configName);
        if (loadedConfigs != null) {
            applicationLayer.addConfigs(loadedConfigs);
        }
        for (ConfigSeeder configSeeder : runtimeConfigResolvers) {
            runtimeLayer.setProperties(configSeeder.get(config));
        }
        for (ConfigSeeder configSeeder : remoteConfigResolvers) {
            overrideLayer.addConfig("remote", configSeeder.get(config));
        }
        loadedConfigs = loader.newLoader().withCascadeStrategy(cascadeStrategy).load(configName);
        if (loadedConfigs != null) {
            applicationLayer.removeConfig(configName);
            for (Map.Entry entry : loadedConfigs.entrySet()) {
                try {
                    applicationLayer.addConfig((String)entry.getKey(), (Config)entry.getValue());
                }
                catch (ConfigAlreadyExistsException e) {}
            }
        }
        return config;
    }

    @Provides
    @Singleton
    PropertyFactory getPropertyFactory(Config root) {
        return DefaultPropertyFactory.from((Config)root);
    }

    public static class ConfigProvider<T>
    implements Provider<T> {
        private Class<T> type;
        @Inject
        ProxyFactory proxy;
        @Inject
        PropertyFactory factory;

        public ConfigProvider(Class<T> type) {
            this.type = type;
        }

        public T get() {
            return (T)this.proxy.newProxy(this.type, this.factory);
        }
    }
}

