/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.Inject;
import com.netflix.archaius.CascadeStrategy;
import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigListener;
import com.netflix.archaius.Decoder;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.guice.ArchaiusConfiguration;
import com.netflix.archaius.guice.ConfigSeeder;
import com.netflix.archaius.inject.ApplicationLayer;
import com.netflix.archaius.inject.ApplicationOverrideLayer;
import com.netflix.archaius.inject.LibrariesLayer;
import com.netflix.archaius.inject.RemoteLayer;
import com.netflix.archaius.inject.RuntimeLayer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class OptionalArchaiusConfiguration
implements ArchaiusConfiguration {
    @Inject(optional=true)
    @RuntimeLayer
    Set<ConfigSeeder> runtimeLayerSeeders;
    @Inject(optional=true)
    @RemoteLayer
    Set<ConfigSeeder> remoteLayerSeeders;
    @Inject(optional=true)
    Set<ConfigListener> configListeners;
    @Inject(optional=true)
    @ApplicationLayer
    String configurationName;
    @Inject(optional=true)
    CascadeStrategy cascadeStrategy;
    @Inject(optional=true)
    Decoder decoder;
    @Inject(optional=true)
    @LibrariesLayer
    Map<String, Config> libraryOverrides;
    @Inject(optional=true)
    @ApplicationOverrideLayer
    Config applicationOverrideLayer;

    @Override
    public Set<ConfigSeeder> getRuntimeLayerSeeders() {
        return this.runtimeLayerSeeders != null ? this.runtimeLayerSeeders : Collections.emptySet();
    }

    @Override
    public Set<ConfigSeeder> getRemoteLayerSeeders() {
        return this.remoteLayerSeeders != null ? this.remoteLayerSeeders : Collections.emptySet();
    }

    @Override
    public String getConfigName() {
        return this.configurationName != null ? this.configurationName : "application";
    }

    @Override
    public CascadeStrategy getCascadeStrategy() {
        return this.cascadeStrategy != null ? this.cascadeStrategy : NoCascadeStrategy.INSTANCE;
    }

    @Override
    public Decoder getDecoder() {
        return this.decoder != null ? this.decoder : DefaultDecoder.INSTANCE;
    }

    @Override
    public Set<ConfigListener> getConfigListeners() {
        return this.configListeners != null ? this.configListeners : Collections.emptySet();
    }

    @Override
    public Map<String, Config> getLibraryOverrides() {
        return this.libraryOverrides != null ? this.libraryOverrides : Collections.emptyMap();
    }

    @Override
    public Config getApplicationOverride() {
        return this.applicationOverrideLayer;
    }
}

