/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigListener;
import com.netflix.archaius.ConfigLoader;
import com.netflix.archaius.ConfigProxyFactory;
import com.netflix.archaius.ConfigReader;
import com.netflix.archaius.DefaultConfigLoader;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.PropertyFactory;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.config.CompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.SettableConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.archaius.exceptions.ConfigException;
import com.netflix.archaius.guice.ArchaiusConfiguration;
import com.netflix.archaius.guice.ConfigSeeder;
import com.netflix.archaius.guice.ConfigurationInjectingListener;
import com.netflix.archaius.guice.OptionalArchaiusConfiguration;
import com.netflix.archaius.guice.RootLayer;
import com.netflix.archaius.inject.ApplicationLayer;
import com.netflix.archaius.inject.DefaultsLayer;
import com.netflix.archaius.inject.LibrariesLayer;
import com.netflix.archaius.inject.RemoteLayer;
import com.netflix.archaius.inject.RuntimeLayer;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import com.netflix.archaius.readers.PropertiesConfigReader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class ArchaiusModule
extends AbstractModule {
    private static final String RUNTIME_LAYER_NAME = "RUNTIME";
    private static final String REMOTE_LAYER_NAME = "REMOTE";
    private static final String SYSTEM_LAYER_NAME = "SYSTEM";
    private static final String ENVIRONMENT_LAYER_NAME = "ENVIRONMENT";
    private static final String APPLICATION_OVERRIDE_LAYER_NAME = "APPLICATION_OVERRIDE";
    private static final String APPLICATION_LAYER_NAME = "APPLICATION";
    private static final String LIBRARIES_LAYER_NAME = "LIBRARIES";
    private static final String DEFAULTS_LAYER_NAME = "DEFAULTS";
    private static final AtomicInteger idCounter = new AtomicInteger();

    protected void configure() {
        this.bindListener(Matchers.any(), new ConfigurationInjectingListener());
        Multibinder.newSetBinder((Binder)this.binder(), ConfigReader.class).addBinding().to(PropertiesConfigReader.class).in(Scopes.SINGLETON);
        this.bind(ArchaiusConfiguration.class).to(OptionalArchaiusConfiguration.class);
    }

    @Provides
    @Singleton
    @RuntimeLayer
    SettableConfig getSettableConfig() {
        return new DefaultSettableConfig();
    }

    @Provides
    @Singleton
    @DefaultsLayer
    SettableConfig getDefaultsConfig() {
        return new DefaultSettableConfig();
    }

    @Provides
    @Singleton
    @ApplicationLayer
    CompositeConfig getApplicationLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    @LibrariesLayer
    CompositeConfig getLibrariesLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    @RemoteLayer
    CompositeConfig getRemoteLayer() {
        return new CompositeConfig();
    }

    @Provides
    @Singleton
    @RemoteLayer
    Config getRemoteLayer(@RemoteLayer CompositeConfig config) {
        return config;
    }

    @Provides
    @Singleton
    ConfigLoader getLoader(@RootLayer Config config, ArchaiusConfiguration archaiusConfiguration, Set<ConfigReader> readers) {
        return DefaultConfigLoader.builder().withConfigReader(readers).withDefaultCascadingStrategy(archaiusConfiguration.getCascadeStrategy()).withFailOnFirst(false).withStrLookup(ConfigStrLookup.from((Config)config)).build();
    }

    @Provides
    @Singleton
    @RootLayer
    Config getInternalConfig(ArchaiusConfiguration archaiusConfiguration, @RuntimeLayer SettableConfig settableLayer, @RemoteLayer Config overrideLayer, @ApplicationLayer CompositeConfig applicationLayer, @LibrariesLayer CompositeConfig librariesLayer, @DefaultsLayer SettableConfig defaultsLayer) throws ConfigException {
        CompositeConfig.Builder builder = CompositeConfig.builder().withConfig(RUNTIME_LAYER_NAME, (Config)settableLayer).withConfig(REMOTE_LAYER_NAME, overrideLayer).withConfig(SYSTEM_LAYER_NAME, (Config)SystemConfig.INSTANCE).withConfig(ENVIRONMENT_LAYER_NAME, (Config)EnvironmentConfig.INSTANCE);
        if (archaiusConfiguration.getApplicationOverride() != null) {
            builder.withConfig(APPLICATION_OVERRIDE_LAYER_NAME, archaiusConfiguration.getApplicationOverride());
        }
        builder.withConfig(APPLICATION_LAYER_NAME, (Config)applicationLayer).withConfig(LIBRARIES_LAYER_NAME, (Config)librariesLayer).withConfig(DEFAULTS_LAYER_NAME, (Config)defaultsLayer);
        return builder.build();
    }

    @Provides
    @Singleton
    public Config getConfig(ArchaiusConfiguration archaiusConfiguration, @RootLayer Config config, @ApplicationLayer CompositeConfig applicationLayer, @RemoteLayer CompositeConfig remoteLayer, @RuntimeLayer SettableConfig runtimeLayer, @DefaultsLayer SettableConfig defaultsLayer, ConfigLoader loader) throws Exception {
        CompositeConfig compositeConfig = loader.newLoader().withCascadeStrategy(NoCascadeStrategy.INSTANCE).load(archaiusConfiguration.getConfigName());
        if (compositeConfig != null) {
            applicationLayer.replaceConfig(APPLICATION_LAYER_NAME, (Config)compositeConfig);
        }
        for (ConfigSeeder provider : archaiusConfiguration.getDefaultsLayerSeeders()) {
            defaultsLayer.setProperties(provider.get(config));
        }
        for (ConfigSeeder provider : archaiusConfiguration.getRuntimeLayerSeeders()) {
            runtimeLayer.setProperties(provider.get(config));
        }
        compositeConfig = loader.newLoader().withCascadeStrategy(archaiusConfiguration.getCascadeStrategy()).load(archaiusConfiguration.getConfigName());
        if (compositeConfig != null) {
            applicationLayer.replaceConfig(APPLICATION_LAYER_NAME, (Config)compositeConfig);
        }
        for (ConfigSeeder provider : archaiusConfiguration.getRemoteLayerSeeders()) {
            remoteLayer.addConfig("remote" + idCounter.incrementAndGet(), provider.get(config));
        }
        for (ConfigListener listener : archaiusConfiguration.getConfigListeners()) {
            config.addListener(listener);
        }
        return config;
    }

    @Provides
    @Singleton
    PropertyFactory getPropertyFactory(Config root) {
        return DefaultPropertyFactory.from((Config)root);
    }

    @Provides
    @Singleton
    ConfigProxyFactory getProxyFactory(ArchaiusConfiguration config, PropertyFactory factory) {
        return new ConfigProxyFactory(config.getDecoder(), factory);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean equals(Object obj) {
        return ArchaiusModule.class.equals(obj.getClass());
    }

    public int hashCode() {
        return ArchaiusModule.class.hashCode();
    }
}

