/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.netflix.archaius.CascadeStrategy;
import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigLoader;
import com.netflix.archaius.ConfigMapper;
import com.netflix.archaius.IoCContainer;
import com.netflix.archaius.annotations.Configuration;
import com.netflix.archaius.annotations.ConfigurationSource;
import com.netflix.archaius.config.CompositeConfig;
import com.netflix.archaius.exceptions.ConfigException;
import com.netflix.archaius.guice.ArchaiusConfiguration;
import com.netflix.archaius.inject.LibrariesLayer;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationInjectingListener
implements TypeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationInjectingListener.class);
    private ConfigMapper mapper = new ConfigMapper(true);

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> encounter) {
        Configuration configAnnot;
        Class clazz = typeLiteral.getRawType();
        ConfigurationSource source = clazz.getAnnotation(ConfigurationSource.class);
        if (source != null) {
            Provider holder = encounter.getProvider(Holder.class);
            encounter.register(new InjectionListener<I>((javax.inject.Provider)holder){
                final /* synthetic */ javax.inject.Provider val$holder;
                {
                    this.val$holder = provider;
                }

                public void afterInjection(I injectee) {
                    CascadeStrategy strategy;
                    ConfigurationSource source = injectee.getClass().getAnnotation(ConfigurationSource.class);
                    CascadeStrategy cascadeStrategy = strategy = source.cascading() != ConfigurationSource.NullCascadeStrategy.class ? (CascadeStrategy)((Holder)this.val$holder.get()).injector.getInstance(source.cascading()) : ((Holder)this.val$holder.get()).archaiusConfiguration.getCascadeStrategy();
                    if (source != null) {
                        for (String resourceName : source.value()) {
                            LOG.debug("Trying to loading configuration resource {}", (Object)resourceName);
                            try {
                                Config override = ((Holder)this.val$holder.get()).archaiusConfiguration.getLibraryOverrides().get(resourceName);
                                CompositeConfig loadedConfig = ((Holder)this.val$holder.get()).loader.newLoader().withCascadeStrategy(strategy).withOverrides(override).load(resourceName);
                                ((Holder)this.val$holder.get()).libraries.addConfig(resourceName, (Config)loadedConfig);
                            }
                            catch (ConfigException e) {
                                throw new ProvisionException("Unable to load configuration for " + resourceName + " at source " + injectee.getClass(), (Throwable)e);
                            }
                        }
                    }
                }
            });
        }
        if ((configAnnot = clazz.getAnnotation(Configuration.class)) != null) {
            Provider holder = encounter.getProvider(Holder.class);
            encounter.register(new InjectionListener<I>((javax.inject.Provider)holder){
                final /* synthetic */ javax.inject.Provider val$holder;
                {
                    this.val$holder = provider;
                }

                public void afterInjection(I injectee) {
                    try {
                        ConfigurationInjectingListener.this.mapper.mapConfig(injectee, ((Holder)this.val$holder.get()).config, new IoCContainer(){

                            public <T> T getInstance(String name, Class<T> type) {
                                return (T)((Holder)val$holder.get()).injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new ProvisionException("Unable to bind configuration to " + injectee.getClass(), (Throwable)e);
                    }
                }
            });
        }
    }

    static class Holder {
        @Inject
        private Config config;
        @Inject
        private Injector injector;
        @Inject
        private ConfigLoader loader;
        @Inject
        @LibrariesLayer
        private CompositeConfig libraries;
        @Inject
        private ArchaiusConfiguration archaiusConfiguration;

        Holder() {
        }
    }
}

