/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.netflix.archaius.ConfigProxyFactory;
import com.netflix.archaius.DefaultConfigLoader;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.CascadeStrategy;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigLoader;
import com.netflix.archaius.api.ConfigReader;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.api.inject.LibrariesLayer;
import com.netflix.archaius.api.inject.RemoteLayer;
import com.netflix.archaius.api.inject.RuntimeLayer;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.archaius.guice.ConfigurationInjectingListener;
import com.netflix.archaius.guice.Raw;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import com.netflix.archaius.readers.PropertiesConfigReader;
import java.util.Properties;
import java.util.Set;

public final class ArchaiusModule
extends AbstractModule {
    private static final String DEFAULT_CONFIG_NAME = "application";
    private static final String RUNTIME_LAYER_NAME = "RUNTIME";
    private static final String REMOTE_LAYER_NAME = "REMOTE";
    private static final String SYSTEM_LAYER_NAME = "SYSTEM";
    private static final String ENVIRONMENT_LAYER_NAME = "ENVIRONMENT";
    private static final String APPLICATION_LAYER_NAME = "APPLICATION";
    private static final String LIBRARIES_LAYER_NAME = "LIBRARIES";
    private String configName = "application";
    private Class<? extends CascadeStrategy> cascadeStrategy = NoCascadeStrategy.class;
    private final SettableConfig runtimeLayer = new DefaultSettableConfig();
    private final CompositeConfig remoteLayer;
    private final CompositeConfig applicationLayer = new DefaultCompositeConfig();
    private final CompositeConfig librariesLayer = new DefaultCompositeConfig();
    private final CompositeConfig rawConfig;
    private int uniqueNameCounter = 0;

    public ArchaiusModule() {
        this.remoteLayer = new DefaultCompositeConfig();
        try {
            this.rawConfig = DefaultCompositeConfig.builder().withConfig(RUNTIME_LAYER_NAME, (Config)this.runtimeLayer).withConfig(REMOTE_LAYER_NAME, (Config)this.remoteLayer).withConfig(SYSTEM_LAYER_NAME, (Config)SystemConfig.INSTANCE).withConfig(ENVIRONMENT_LAYER_NAME, (Config)EnvironmentConfig.INSTANCE).withConfig(APPLICATION_LAYER_NAME, (Config)this.applicationLayer).withConfig(LIBRARIES_LAYER_NAME, (Config)this.librariesLayer).build();
        }
        catch (ConfigException e) {
            throw new ProvisionException("Error creating raw configuration", (Throwable)e);
        }
    }

    public ArchaiusModule withConfigName(String value) {
        this.configName = value;
        return this;
    }

    public ArchaiusModule withApplicationOverrides(Properties prop) {
        return this.withApplicationOverrides((Config)MapConfig.from((Properties)prop));
    }

    public ArchaiusModule withApplicationOverrides(Config config) {
        try {
            ++this.uniqueNameCounter;
            this.applicationLayer.addConfig("override-" + this.uniqueNameCounter, config);
        }
        catch (ConfigException e) {
            throw new ProvisionException("Failed to add application overrides", (Throwable)e);
        }
        return this;
    }

    public ArchaiusModule withCascadeStrategy(Class<? extends CascadeStrategy> cascadeStrategy) {
        this.cascadeStrategy = cascadeStrategy;
        return this;
    }

    protected void configure() {
        this.bindListener(Matchers.any(), new ConfigurationInjectingListener());
        this.bind(CascadeStrategy.class).to(this.cascadeStrategy);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigReader.class).addBinding().to(PropertiesConfigReader.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @RuntimeLayer
    SettableConfig getSettableConfig() {
        return this.runtimeLayer;
    }

    @Provides
    @Singleton
    @LibrariesLayer
    CompositeConfig getLibrariesLayer() {
        return this.librariesLayer;
    }

    @Provides
    @Singleton
    @Raw
    Config getRawConfig() {
        return this.rawConfig;
    }

    @Provides
    @Singleton
    Config getConfig(ConfigLoader loader, OptionalRemoteLayer optionalRemoteLayer) throws Exception {
        this.applicationLayer.addConfig(this.configName, (Config)loader.newLoader().load(this.configName));
        if (null != optionalRemoteLayer.remoteLayer) {
            this.remoteLayer.addConfig("remote", optionalRemoteLayer.remoteLayer);
        }
        return this.rawConfig;
    }

    @Provides
    @Singleton
    ConfigLoader getLoader(@LibrariesLayer CompositeConfig libraries, CascadeStrategy cascadingStrategy, Set<ConfigReader> readers) throws ConfigException {
        return DefaultConfigLoader.builder().withConfigReaders(readers).withDefaultCascadingStrategy(cascadingStrategy).withStrLookup(ConfigStrLookup.from((Config)this.rawConfig)).build();
    }

    @Provides
    @Singleton
    public Decoder getDecoder() {
        return DefaultDecoder.INSTANCE;
    }

    @Provides
    @Singleton
    PropertyFactory getPropertyFactory(Config config) {
        return DefaultPropertyFactory.from((Config)config);
    }

    @Provides
    @Singleton
    ConfigProxyFactory getProxyFactory(Decoder decoder, PropertyFactory factory) {
        return new ConfigProxyFactory(decoder, factory);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    static {
        System.setProperty("archaius.default.configuration.class", "com.netflix.archaius.bridge.StaticAbstractConfiguration");
        System.setProperty("archaius.default.deploymentContext.class", "com.netflix.archaius.bridge.StaticDeploymentContext");
    }

    @Singleton
    private static class OptionalRemoteLayer {
        @Inject(optional=true)
        @RemoteLayer
        Config remoteLayer;

        private OptionalRemoteLayer() {
        }
    }
}

