/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.netflix.archaius.ConfigProxyFactory;
import com.netflix.archaius.DefaultConfigLoader;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.CascadeStrategy;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigLoader;
import com.netflix.archaius.api.ConfigReader;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.api.inject.DefaultLayer;
import com.netflix.archaius.api.inject.LibrariesLayer;
import com.netflix.archaius.api.inject.RemoteLayer;
import com.netflix.archaius.api.inject.RuntimeLayer;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.archaius.guice.ApplicationOverride;
import com.netflix.archaius.guice.ConfigurationInjectingListener;
import com.netflix.archaius.guice.Raw;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import com.netflix.archaius.readers.PropertiesConfigReader;
import java.util.Properties;
import java.util.Set;
import javax.inject.Provider;

public final class ArchaiusModule
extends AbstractModule {
    private static final String DEFAULT_CONFIG_NAME = "application";
    private static final String RUNTIME_LAYER_NAME = "RUNTIME";
    private static final String REMOTE_LAYER_NAME = "REMOTE";
    private static final String SYSTEM_LAYER_NAME = "SYSTEM";
    private static final String ENVIRONMENT_LAYER_NAME = "ENVIRONMENT";
    private static final String APPLICATION_LAYER_NAME = "APPLICATION";
    private static final String LIBRARIES_LAYER_NAME = "LIBRARIES";
    private static final String DEFAULT_LAYER_NAME = "DEFAULT";
    private String configName = "application";
    private Class<? extends CascadeStrategy> cascadeStrategy = null;
    private Config applicationOverride;
    private int uniqueNameCounter = 0;

    public ArchaiusModule withConfigName(String value) {
        this.configName = value;
        return this;
    }

    public ArchaiusModule withApplicationOverrides(Properties prop) {
        return this.withApplicationOverrides((Config)MapConfig.from((Properties)prop));
    }

    public ArchaiusModule withApplicationOverrides(Config config) {
        this.applicationOverride = config;
        return this;
    }

    @Deprecated
    public ArchaiusModule withCascadeStrategy(Class<? extends CascadeStrategy> cascadeStrategy) {
        this.cascadeStrategy = cascadeStrategy;
        return this;
    }

    private String getUniqueName(String prefix) {
        ++this.uniqueNameCounter;
        return prefix + "-" + this.uniqueNameCounter;
    }

    protected void configure() {
        this.bindListener(Matchers.any(), new ConfigurationInjectingListener());
        Multibinder.newSetBinder((Binder)this.binder(), ConfigReader.class).addBinding().to(PropertiesConfigReader.class).in(Scopes.SINGLETON);
        if (this.cascadeStrategy != null) {
            this.bind(CascadeStrategy.class).to(this.cascadeStrategy);
        }
        if (this.applicationOverride != null) {
            this.bind(Config.class).annotatedWith(ApplicationOverride.class).toInstance((Object)this.applicationOverride);
        }
    }

    @Provides
    @Singleton
    @RuntimeLayer
    SettableConfig getSettableConfig() {
        return new DefaultSettableConfig();
    }

    @Provides
    @Singleton
    @LibrariesLayer
    CompositeConfig getLibrariesLayer() {
        return new DefaultCompositeConfig();
    }

    @Provides
    @Singleton
    @Raw
    CompositeConfig getRawCompositeConfig() throws Exception {
        return new DefaultCompositeConfig();
    }

    @Provides
    @Singleton
    @Raw
    Config getRawConfig(@Raw CompositeConfig config) throws Exception {
        return config;
    }

    @Provides
    @Singleton
    Config getConfig(ConfigParameters params, @Raw CompositeConfig config, ConfigLoader loader) throws Exception {
        DefaultCompositeConfig applicationLayer = new DefaultCompositeConfig();
        DefaultCompositeConfig remoteLayer = new DefaultCompositeConfig();
        config.addConfig(RUNTIME_LAYER_NAME, (Config)params.runtimeLayer);
        config.addConfig(REMOTE_LAYER_NAME, (Config)remoteLayer);
        config.addConfig(SYSTEM_LAYER_NAME, (Config)SystemConfig.INSTANCE);
        config.addConfig(ENVIRONMENT_LAYER_NAME, (Config)EnvironmentConfig.INSTANCE);
        config.addConfig(APPLICATION_LAYER_NAME, (Config)applicationLayer);
        config.addConfig(LIBRARIES_LAYER_NAME, (Config)params.librariesLayer);
        if (params.defaultConfigs != null) {
            DefaultCompositeConfig defaultLayer = new DefaultCompositeConfig();
            config.addConfig(DEFAULT_LAYER_NAME, (Config)defaultLayer);
            for (Config c : params.defaultConfigs) {
                defaultLayer.addConfig(this.getUniqueName("default"), c);
            }
        }
        if (this.applicationOverride != null) {
            applicationLayer.addConfig(this.getUniqueName("override"), this.applicationOverride);
        }
        applicationLayer.addConfig(this.configName, (Config)loader.newLoader().load(this.configName));
        if (params.remoteLayerProvider != null) {
            remoteLayer.addConfig(this.getUniqueName("remote"), (Config)params.remoteLayerProvider.get());
        }
        return config;
    }

    @Provides
    @Singleton
    ConfigLoader getLoader(@Raw CompositeConfig rawConfig, Set<ConfigReader> readers, OptionalLoaderConfig optional) throws ConfigException {
        return DefaultConfigLoader.builder().withConfigReaders(readers).withDefaultCascadingStrategy((CascadeStrategy)(optional.cascadingStrategy == null ? new NoCascadeStrategy() : optional.cascadingStrategy)).withStrLookup(ConfigStrLookup.from((Config)rawConfig)).build();
    }

    @Provides
    @Singleton
    Decoder getDecoder() {
        return DefaultDecoder.INSTANCE;
    }

    @Provides
    @Singleton
    PropertyFactory getPropertyFactory(Config config) {
        return DefaultPropertyFactory.from((Config)config);
    }

    @Provides
    @Singleton
    ConfigProxyFactory getProxyFactory(Decoder decoder, PropertyFactory factory) {
        return new ConfigProxyFactory(decoder, factory);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    static {
        System.setProperty("archaius.default.configuration.class", "com.netflix.archaius.bridge.StaticAbstractConfiguration");
        System.setProperty("archaius.default.deploymentContext.class", "com.netflix.archaius.bridge.StaticDeploymentContext");
    }

    @Singleton
    private static class OptionalLoaderConfig {
        @Inject(optional=true)
        CascadeStrategy cascadingStrategy;

        private OptionalLoaderConfig() {
        }
    }

    @Singleton
    private static class ConfigParameters {
        @Inject
        @RuntimeLayer
        SettableConfig runtimeLayer;
        @Inject
        @LibrariesLayer
        CompositeConfig librariesLayer;
        @Inject(optional=true)
        @RemoteLayer
        Provider<Config> remoteLayerProvider;
        @Inject(optional=true)
        @DefaultLayer
        Set<Config> defaultConfigs;
        @Inject(optional=true)
        @ApplicationOverride
        Config applicationOverride;

        private ConfigParameters() {
        }
    }
}

