/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.ProvisionListener;
import com.netflix.archaius.ConfigProxyFactory;
import com.netflix.archaius.DefaultConfigLoader;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.CascadeStrategy;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigLoader;
import com.netflix.archaius.api.ConfigReader;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.api.inject.DefaultLayer;
import com.netflix.archaius.api.inject.LibrariesLayer;
import com.netflix.archaius.api.inject.RemoteLayer;
import com.netflix.archaius.api.inject.RuntimeLayer;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.archaius.guice.ApplicationOverride;
import com.netflix.archaius.guice.ApplicationOverrideResources;
import com.netflix.archaius.guice.ConfigurationInjectingListener;
import com.netflix.archaius.guice.Raw;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import com.netflix.archaius.readers.PropertiesConfigReader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Named;
import javax.inject.Provider;

final class InternalArchaiusModule
extends AbstractModule {
    static final String CONFIG_NAME_KEY = "archaius.config.name";
    private static final String DEFAULT_CONFIG_NAME = "application";
    private static final String RUNTIME_LAYER_NAME = "RUNTIME";
    private static final String REMOTE_LAYER_NAME = "REMOTE";
    private static final String SYSTEM_LAYER_NAME = "SYSTEM";
    private static final String ENVIRONMENT_LAYER_NAME = "ENVIRONMENT";
    private static final String APPLICATION_LAYER_NAME = "APPLICATION";
    private static final String LIBRARIES_LAYER_NAME = "LIBRARIES";
    private static final String DEFAULT_LAYER_NAME = "DEFAULT";
    private static AtomicInteger uniqueNameCounter = new AtomicInteger();

    InternalArchaiusModule() {
    }

    private static String getUniqueName(String prefix) {
        return prefix + "-" + uniqueNameCounter.incrementAndGet();
    }

    protected void configure() {
        ConfigurationInjectingListener listener = new ConfigurationInjectingListener();
        this.requestInjection(listener);
        this.bind(ConfigurationInjectingListener.class).toInstance((Object)listener);
        this.requestStaticInjection(new Class[]{ConfigurationInjectingListener.class});
        this.bindListener(Matchers.any(), new ProvisionListener[]{listener});
        Multibinder.newSetBinder((Binder)this.binder(), ConfigReader.class).addBinding().to(PropertiesConfigReader.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @RuntimeLayer
    SettableConfig getSettableConfig() {
        return new DefaultSettableConfig();
    }

    @Provides
    @Singleton
    @LibrariesLayer
    CompositeConfig getLibrariesLayer() {
        return new DefaultCompositeConfig(true);
    }

    @Provides
    @Singleton
    @Raw
    CompositeConfig getRawCompositeConfig() throws Exception {
        return new DefaultCompositeConfig();
    }

    @Provides
    @Singleton
    @Raw
    Config getRawConfig(@Raw CompositeConfig config) throws Exception {
        return config;
    }

    @Provides
    @Singleton
    Config getConfig(ConfigParameters params, @Raw CompositeConfig config, ConfigLoader loader) throws Exception {
        DefaultCompositeConfig applicationLayer = new DefaultCompositeConfig();
        DefaultCompositeConfig remoteLayer = new DefaultCompositeConfig();
        config.addConfig(RUNTIME_LAYER_NAME, (Config)params.runtimeLayer);
        config.addConfig(REMOTE_LAYER_NAME, (Config)remoteLayer);
        config.addConfig(SYSTEM_LAYER_NAME, (Config)SystemConfig.INSTANCE);
        config.addConfig(ENVIRONMENT_LAYER_NAME, (Config)EnvironmentConfig.INSTANCE);
        config.addConfig(APPLICATION_LAYER_NAME, (Config)applicationLayer);
        config.addConfig(LIBRARIES_LAYER_NAME, (Config)params.librariesLayer);
        if (params.hasDefaultConfigs()) {
            DefaultCompositeConfig defaultLayer = new DefaultCompositeConfig();
            config.addConfig(DEFAULT_LAYER_NAME, (Config)defaultLayer);
            for (Config c : params.defaultConfigs) {
                defaultLayer.addConfig(InternalArchaiusModule.getUniqueName("default"), c);
            }
        }
        if (params.hasOverrideResources()) {
            for (String resourceName : params.overrideResources) {
                applicationLayer.addConfig(resourceName, (Config)loader.newLoader().load(resourceName));
            }
        }
        if (params.hasApplicationOverride()) {
            applicationLayer.addConfig(InternalArchaiusModule.getUniqueName("override"), params.applicationOverride);
        }
        applicationLayer.addConfig(params.getConfigName(), (Config)loader.newLoader().load(params.getConfigName()));
        if (params.hasRemoteLayer()) {
            remoteLayer.addConfig(InternalArchaiusModule.getUniqueName("remote"), (Config)params.remoteLayerProvider.get());
        }
        return config;
    }

    @Provides
    @Singleton
    ConfigLoader getLoader(@Raw CompositeConfig rawConfig, Set<ConfigReader> readers, OptionalCascadeStrategy cascadeStrategy) throws ConfigException {
        return DefaultConfigLoader.builder().withConfigReaders(readers).withDefaultCascadingStrategy(cascadeStrategy.get()).withStrLookup(ConfigStrLookup.from((Config)rawConfig)).build();
    }

    @Provides
    @Singleton
    Decoder getDecoder() {
        return DefaultDecoder.INSTANCE;
    }

    @Provides
    @Singleton
    PropertyFactory getPropertyFactory(Config config) {
        return DefaultPropertyFactory.from((Config)config);
    }

    @Provides
    @Singleton
    ConfigProxyFactory getProxyFactory(Config config, Decoder decoder, PropertyFactory factory) {
        return new ConfigProxyFactory(config, decoder, factory);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return InternalArchaiusModule.class.equals(obj.getClass());
    }

    @Singleton
    private static class OptionalCascadeStrategy {
        @Inject(optional=true)
        CascadeStrategy cascadingStrategy;

        private OptionalCascadeStrategy() {
        }

        CascadeStrategy get() {
            return this.cascadingStrategy == null ? new NoCascadeStrategy() : this.cascadingStrategy;
        }
    }

    @Singleton
    private static class ConfigParameters {
        @Inject(optional=true)
        @Named(value="archaius.config.name")
        String configName;
        @Inject
        @RuntimeLayer
        SettableConfig runtimeLayer;
        @Inject
        @LibrariesLayer
        CompositeConfig librariesLayer;
        @Inject(optional=true)
        @RemoteLayer
        Provider<Config> remoteLayerProvider;
        @Inject(optional=true)
        @DefaultLayer
        Set<Config> defaultConfigs;
        @Inject(optional=true)
        @ApplicationOverride
        Config applicationOverride;
        @Inject(optional=true)
        @ApplicationOverrideResources
        Set<String> overrideResources;

        private ConfigParameters() {
        }

        boolean hasApplicationOverride() {
            return this.applicationOverride != null;
        }

        boolean hasDefaultConfigs() {
            return this.defaultConfigs != null;
        }

        boolean hasRemoteLayer() {
            return this.remoteLayerProvider != null;
        }

        boolean hasOverrideResources() {
            return this.overrideResources != null;
        }

        String getConfigName() {
            return this.configName == null ? InternalArchaiusModule.DEFAULT_CONFIG_NAME : this.configName;
        }
    }
}

