/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import com.google.inject.spi.ProvisionListener;
import com.netflix.archaius.ConfigMapper;
import com.netflix.archaius.api.CascadeStrategy;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigLoader;
import com.netflix.archaius.api.IoCContainer;
import com.netflix.archaius.api.annotations.Configuration;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.api.inject.LibrariesLayer;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationInjectingListener
implements ProvisionListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationInjectingListener.class);
    @javax.inject.Inject
    private Config config;
    @javax.inject.Inject
    private Injector injector;
    @javax.inject.Inject
    private ConfigLoader loader;
    @javax.inject.Inject
    @LibrariesLayer
    private CompositeConfig libraries;
    @Inject(optional=true)
    private CascadeStrategy cascadeStrategy;
    private ConfigMapper mapper = new ConfigMapper();

    @javax.inject.Inject
    public static void init(ConfigurationInjectingListener listener) {
        LOG.info("Initializing ConfigurationInjectingListener");
    }

    CascadeStrategy getCascadeStrategy() {
        return this.cascadeStrategy != null ? this.cascadeStrategy : NoCascadeStrategy.INSTANCE;
    }

    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        Configuration configAnnot;
        Class clazz = provision.getBinding().getKey().getTypeLiteral().getRawType();
        ConfigurationSource source = clazz.getDeclaredAnnotation(ConfigurationSource.class);
        if (source != null) {
            if (this.injector == null) {
                LOG.warn("Can't inject configuration into {} until ConfigurationInjectingListener has been initialized", (Object)clazz.getName());
                return;
            }
            CascadeStrategy strategy = source.cascading() != ConfigurationSource.NullCascadeStrategy.class ? (CascadeStrategy)this.injector.getInstance(source.cascading()) : this.getCascadeStrategy();
            List<String> sources = Arrays.asList(source.value());
            Collections.reverse(sources);
            for (String resourceName : sources) {
                LOG.debug("Trying to loading configuration resource {}", (Object)resourceName);
                try {
                    CompositeConfig loadedConfig = this.loader.newLoader().withCascadeStrategy(strategy).load(resourceName);
                    this.libraries.addConfig(resourceName, (Config)loadedConfig);
                }
                catch (ConfigException e) {
                    throw new ProvisionException("Unable to load configuration for " + resourceName, (Throwable)e);
                }
            }
        }
        if ((configAnnot = clazz.getAnnotation(Configuration.class)) != null) {
            if (this.injector == null) {
                LOG.warn("Can't inject configuration into {} until ConfigurationInjectingListener has been initialized", (Object)clazz.getName());
                return;
            }
            try {
                this.mapper.mapConfig(provision.provision(), this.config, new IoCContainer(){

                    public <S> S getInstance(String name, Class<S> type) {
                        return (S)ConfigurationInjectingListener.this.injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
                    }
                });
            }
            catch (Exception e) {
                throw new ProvisionException("Unable to bind configuration to " + clazz, (Throwable)e);
            }
        }
    }
}

