/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.test;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import java.util.Iterator;
import java.util.Properties;

public class TestCompositeConfig
extends DefaultCompositeConfig
implements SettableConfig {
    private static final String CLASS_LEVEL_LAYER_NAME = "CLASS_LEVEL_TEST_OVERRIDES";
    private static final String METHOD_LEVEL_LAYER_NAME = "METHOD_LEVEL_TEST_OVERRIDES";
    private static final String RUNTIME_LAYER_NAME = "RUNTIME";

    public TestCompositeConfig(SettableConfig classLevelOverrides, SettableConfig methodLevelOverrides) {
        try {
            this.addConfig(RUNTIME_LAYER_NAME, (Config)new DefaultSettableConfig());
            this.addConfig(METHOD_LEVEL_LAYER_NAME, (Config)methodLevelOverrides);
            this.addConfig(CLASS_LEVEL_LAYER_NAME, (Config)classLevelOverrides);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void resetForTest() {
        this.clear((SettableConfig)this.getConfig(METHOD_LEVEL_LAYER_NAME));
        this.clear((SettableConfig)this.getConfig(RUNTIME_LAYER_NAME));
    }

    private void clear(SettableConfig config) {
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            config.clearProperty((String)keys.next());
        }
    }

    public void setProperties(Config config) {
        ((SettableConfig)this.getConfig(RUNTIME_LAYER_NAME)).setProperties(config);
    }

    public void setProperties(Properties properties) {
        ((SettableConfig)this.getConfig(RUNTIME_LAYER_NAME)).setProperties(properties);
    }

    public <T> void setProperty(String propName, T propValue) {
        ((SettableConfig)this.getConfig(RUNTIME_LAYER_NAME)).setProperty(propName, propValue);
    }

    public void clearProperty(String propName) {
        ((SettableConfig)this.getConfig(RUNTIME_LAYER_NAME)).clearProperty(propName);
    }
}

