/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.test;

import com.netflix.archaius.test.TestConfigException;
import com.netflix.archaius.test.TestPropertyOverride;
import java.io.IOException;
import java.util.Properties;

public class TestPropertyOverrideAnnotationReader {
    public Properties getPropertiesForAnnotation(TestPropertyOverride annotation) {
        Properties properties = new Properties();
        if (annotation == null) {
            return properties;
        }
        for (String fileName : annotation.propertyFiles()) {
            try {
                properties.load(this.getClass().getClassLoader().getResourceAsStream(fileName));
            }
            catch (IOException e) {
                throw new TestConfigException("Failed to load property file from classpath", e);
            }
        }
        for (String override : annotation.value()) {
            String[] parts = override.split("=", 2);
            if (parts.length < 2) {
                throw new TestConfigException("Error parsing TestPropertyOverride for: " + annotation.value() + " Please ensure you are specifying overrides in the form \"key=value\"");
            }
            properties.put(parts[0], parts[1]);
        }
        return properties;
    }
}

