/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax;

import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.MutationBatchManager;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;

public class ThreadLocalMutationBatchManager
implements MutationBatchManager {
    private ThreadLocal<MutationBatch> batches = new ThreadLocal();
    private final Keyspace keyspace;
    private final ConsistencyLevel cl;
    private final RetryPolicy retryPolicy;

    public ThreadLocalMutationBatchManager(Keyspace keyspace, ConsistencyLevel cl) {
        this(keyspace, cl, null);
    }

    public ThreadLocalMutationBatchManager(Keyspace keyspace, ConsistencyLevel cl, RetryPolicy retryPolicy) {
        this.keyspace = keyspace;
        this.cl = cl;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public MutationBatch getSharedMutationBatch() {
        MutationBatch mb = this.batches.get();
        if (mb == null) {
            mb = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.cl);
            if (this.retryPolicy != null) {
                mb.withRetryPolicy(this.retryPolicy);
            }
            this.batches.set(mb);
        }
        return mb;
    }

    @Override
    public MutationBatch getNewMutationBatch() {
        return this.keyspace.prepareMutationBatch().setConsistencyLevel(this.cl);
    }

    @Override
    public void commitSharedMutationBatch() throws ConnectionException {
        MutationBatch mb = this.batches.get();
        if (mb != null) {
            mb.execute();
            this.batches.remove();
        }
    }

    @Override
    public void discard() {
        this.batches.remove();
    }
}

