/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DateType;
import java.nio.ByteBuffer;
import java.util.Date;

public final class DateSerializer
extends AbstractSerializer<Date> {
    private static final LongSerializer LONG_SERIALIZER = LongSerializer.get();
    private static final DateSerializer instance = new DateSerializer();

    public static DateSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Date obj) {
        if (obj == null) {
            return null;
        }
        return LONG_SERIALIZER.toByteBuffer(obj.getTime());
    }

    @Override
    public Date fromByteBuffer(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer dup = bytes.duplicate();
        return new Date(LONG_SERIALIZER.fromByteBuffer(dup));
    }

    @Override
    public ByteBuffer fromString(String str) {
        return DateType.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return DateType.instance.getString(byteBuffer);
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        return this.toByteBuffer(new Date(this.fromByteBuffer(byteBuffer).getTime() + 1L));
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.DATETYPE;
    }
}

