/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.BigDecimalSerializer;
import com.netflix.astyanax.serializers.BigIntegerSerializer;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.ByteSerializer;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.FloatSerializer;
import com.netflix.astyanax.serializers.Int32Serializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.ObjectSerializer;
import com.netflix.astyanax.serializers.ShortSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;

public class SerializerTypeInferer {
    public static <T> Serializer<T> getSerializer(Object value) {
        AbstractSerializer serializer = null;
        serializer = value == null ? ByteBufferSerializer.get() : (value instanceof UUID ? UUIDSerializer.get() : (value instanceof String ? StringSerializer.get() : (value instanceof Long ? LongSerializer.get() : (value instanceof Integer ? Int32Serializer.get() : (value instanceof Short ? ShortSerializer.get() : (value instanceof Byte ? ByteSerializer.get() : (value instanceof Float ? FloatSerializer.get() : (value instanceof Double ? DoubleSerializer.get() : (value instanceof BigInteger ? BigIntegerSerializer.get() : (value instanceof BigDecimal ? BigDecimalSerializer.get() : (value instanceof Boolean ? BooleanSerializer.get() : (value instanceof byte[] ? BytesArraySerializer.get() : (value instanceof ByteBuffer ? ByteBufferSerializer.get() : (value instanceof Date ? DateSerializer.get() : ObjectSerializer.get()))))))))))))));
        return serializer;
    }

    public static <T> Serializer<T> getSerializer(Class<?> valueClass) {
        AbstractSerializer serializer = null;
        if (valueClass.equals(UUID.class)) {
            serializer = UUIDSerializer.get();
        } else if (valueClass.equals(String.class)) {
            serializer = StringSerializer.get();
        } else if (valueClass.equals(Long.class) || valueClass.equals(Long.TYPE)) {
            serializer = LongSerializer.get();
        } else if (valueClass.equals(Integer.class) || valueClass.equals(Integer.TYPE)) {
            serializer = Int32Serializer.get();
        } else if (valueClass.equals(Short.class) || valueClass.equals(Short.TYPE)) {
            serializer = ShortSerializer.get();
        } else if (valueClass.equals(Byte.class) || valueClass.equals(Byte.TYPE)) {
            serializer = ByteSerializer.get();
        } else if (valueClass.equals(Float.class) || valueClass.equals(Float.TYPE)) {
            serializer = FloatSerializer.get();
        } else if (valueClass.equals(Double.class) || valueClass.equals(Double.TYPE)) {
            serializer = DoubleSerializer.get();
        } else if (valueClass.equals(BigInteger.class)) {
            serializer = BigIntegerSerializer.get();
        } else if (valueClass.equals(BigDecimal.class)) {
            serializer = BigDecimalSerializer.get();
        } else if (valueClass.equals(Boolean.class) || valueClass.equals(Boolean.TYPE)) {
            serializer = BooleanSerializer.get();
        } else if (valueClass.equals(byte[].class)) {
            serializer = BytesArraySerializer.get();
        } else if (valueClass.equals(ByteBuffer.class)) {
            serializer = ByteBufferSerializer.get();
        } else if (valueClass.equals(Date.class)) {
            serializer = DateSerializer.get();
        }
        if (serializer == null) {
            serializer = ObjectSerializer.get();
        }
        return serializer;
    }
}

