/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.Composite;
import com.netflix.astyanax.model.CompositeParser;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.nio.ByteBuffer;
import java.util.UUID;

public class CompositeParserImpl
implements CompositeParser {
    private final Composite composite;
    private int position = 0;

    public CompositeParserImpl(ByteBuffer bb) {
        this.composite = Composite.fromByteBuffer(bb);
    }

    @Override
    public String readString() {
        return this.read(StringSerializer.get());
    }

    @Override
    public Long readLong() {
        return this.read(LongSerializer.get());
    }

    @Override
    public Integer readInteger() {
        return this.read(IntegerSerializer.get());
    }

    @Override
    public Boolean readBoolean() {
        return this.read(BooleanSerializer.get());
    }

    @Override
    public UUID readUUID() {
        return this.read(UUIDSerializer.get());
    }

    @Override
    public <T> T read(Serializer<T> serializer) {
        T obj = this.composite.get(this.position, serializer);
        ++this.position;
        return obj;
    }
}

